//	Zinc Application Framework - Z_STRING.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_STRING_HPP)
#define Z_STRING_HPP
#include <z_env.hpp>

#if defined(ZAF_ISO8859_1)
#	include <string.h>

	int ZAF_EXPORT StrColl(const ZafIChar *s1, const ZafIChar *s2);
	int ZAF_EXPORT StrXFrm(ZafIChar *s1, const ZafIChar *s2, int n);
#	define OSstrcoll	strcoll
#	define OSstrxfrm	strxfrm
#	define strcoll	StrColl
#	define strxfrm	StrXFrm
#elif defined(ZAF_UNICODE)
#	include <string.h>

	extern "C++" ZAF_EXPORT ZafIChar *strcpy(ZafIChar *s1, const ZafIChar *s2);
	extern "C++" ZAF_EXPORT ZafIChar *strncpy(ZafIChar *s1, const ZafIChar *s2, int n);
	extern "C++" ZAF_EXPORT ZafIChar *strcat(ZafIChar *s1, const ZafIChar *s2);
	extern "C++" ZAF_EXPORT ZafIChar *strncat(ZafIChar *s1, const ZafIChar *s2, int n);
	extern "C++" ZAF_EXPORT int strcmp(const ZafIChar *s1, const ZafIChar *s2);
	extern "C++" ZAF_EXPORT int strcoll(const ZafIChar *s1, const ZafIChar *s2);
	extern "C++" ZAF_EXPORT int strncmp(const ZafIChar *s1, const ZafIChar *s2, int n);
	extern "C++" ZAF_EXPORT int strxfrm(ZafIChar *s1, const ZafIChar *s2, int n);
	extern "C++" ZAF_EXPORT ZafIChar *strchr(const ZafIChar *s, int c);
	extern "C++" ZAF_EXPORT int strcspn(const ZafIChar *s1, const ZafIChar *s2);
	extern "C++" ZAF_EXPORT ZafIChar *strpbrk(const ZafIChar *s1, const ZafIChar *s2);
	extern "C++" ZAF_EXPORT ZafIChar *strrchr(const ZafIChar *s, int c);
	extern "C++" ZAF_EXPORT int strspn(const ZafIChar *s1, const ZafIChar *s2);
	extern "C++" ZAF_EXPORT ZafIChar *strstr(const ZafIChar *s1, const ZafIChar *s2);
	extern "C++" ZAF_EXPORT ZafIChar *strtok(ZafIChar *s1, const ZafIChar *s2);
	//*** Can't overload this function (yet?)
	//*** extern "C++" ZAF_EXPORT ZafIChar *strerror(int errnum);
	extern "C++" ZAF_EXPORT int strlen(const ZafIChar *string);

	ZAF_EXPORT ZafIChar *DecomposeCharacter(ZafIChar val);
	ZAF_EXPORT ZafIChar *DecomposeString(const ZafIChar *str, int n = -1);
#else
#	include <string.h>
#endif

#endif
