//	Zinc Application Framework - Z_STDARG.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_STDARG_HPP)
#define Z_STDARG_HPP
#include <stdarg.h>

const int ZAF_MAXPARAMLEN = 512;

typedef void (*objectFormat)(va_list *argList, ZafIChar **ptrBuffer, ZafIChar fmtch, int flags, int width, int prec);
typedef int (*objectParse)(va_list *argList, ZafIChar **ptrBuffer, ZafIChar fmtch, int flags, int width, const ZafIChar **fmt);

const int ALT			= 0x0001;	// alternate form
const int HEXPREFIX		= 0x0002;	// add 0x or 0X prefix
const int LADJUST		= 0x0004;	// left adjustment
const int LONGDBL		= 0x0008;	// long double; unimplemented
const int LONGINT		= 0x0010;	// long integer
const int QUADINT		= 0x0020;	// quad integer; unimplemented
const int SHORTINT		= 0x0040;	// short integer
const int ZEROPAD		= 0x0080;	// zero (as opposed to blank) pad
const int ALTZAF_DIGITS		= 0x0100;	// Use alternate digits
const int CURRENCYx		= 0x0200;	// use currency
const int CREDIT		= 0x0400;	// use credits (xxx)
const int COMMAS		= 0x0800;	// use commas
const int SPACEx		= 0x1000;	// had space flag (not used?)
const int PLUS			= 0x2000;	// had plus flag
const int ZAF_OBJ		= 0x4000;	// pointer to a ZAF_DATA_OBJECT

const int LONGVAL		= 0x001; // l: long or double
const int SHORTVAL		= 0x002; // h: short
const int SUPPRESS		= 0x004; // suppress assignment
//const int LONGDBL		= 0x008; // L: long double; unimplemented
const int POINTER		= 0x010; // weird %p pointer (`fake hex')
const int NOSKIP		= 0x020; // do not skip blanks
// The following are used in numeric conversions only:
// SIGNOK, NZAF_DIGITS, DPTOK, and EXPOK are for floating point;
// SIGNOK, NZAF_DIGITS, PFXOK, and NZZAF_DIGITS are for integral.
const int SIGNOK		= 0x040; // +/- is (still) legal
const int NZAF_DIGITS		= 0x080; // no digits detected
const int DPTOK			= 0x100; // (float) decimal point is still legal
const int EXPOK			= 0x200; // (float) exponent (e+3, etc) still legal
const int PFXOK			= 0x100; // 0x prefix is (still) legal
const int NZZAF_DIGITS		= 0x200; // no zero digits detected
//const int ZAF_OBJ		= 0x4000;	// pointer to a ZAF_DATA_OBJECT

class ZAF_EXPORT ZafStandardArg
{
public:
	static int vsprintf(ZafIChar *buffer, const ZafIChar *format, va_list *argList);
	static int vsscanf(const ZafIChar *buffer, const ZafIChar *format, va_list *argList);
	static void RearrangeArgs(bool isScanf, void *newBuffer,
		const ZafIChar *format, const va_list ap, ZafIChar *newFormat,
		va_list *toRet);
	static int _vsprintf(ZafIChar *fp, const ZafIChar *fmt, va_list *ap);
	static int _vsscanf(const ZafIChar *fp, const ZafIChar *fmt, va_list *ap);
	static void SetSprintf(ZafIChar fmtCH, objectFormat format);
	static void SetSscanf(ZafIChar fmtCH, objectParse parse);
};

#endif
