//	Zinc Application Framework - Z_SCRLL2.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_SCRLL2_HPP)
#define Z_SCRLL2_HPP
#include <z_scrll1.hpp>
#include <z_bitmap.hpp>
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafScrollBar -------------------------------------------------------
// --------------------------------------------------------------------------

enum ZafScrollBarType
{
	ZAF_CORNER_SCROLL = 0,
	ZAF_HORIZONTAL_SCROLL,
	ZAF_VERTICAL_SCROLL,
	ZAF_HORIZONTAL_SLIDER,
	ZAF_VERTICAL_SLIDER,
	ZAF_SIZEGRIP_SCROLL
};

#	if defined(ZAF_MSDOS) || defined(ZAF_CURSES)
	class ZAF_EXPORT ZafScrollButton;
#	endif

class ZAF_EXPORT ZafScrollBar : public ZafWindow
{
public:
	// --- General members ---
	ZafScrollBar(int left, int top, int width, int height,
		ZafScrollData *scrollData = ZAF_NULLP(ZafScrollData),
		ZafScrollBarType scrollType = ZAF_VERTICAL_SCROLL);
	ZafScrollBar(int left, int top, int width, int height,
		long minimum, long maximum, long current, long delta, long showing,
		ZafScrollBarType scrollType = ZAF_VERTICAL_SCROLL);
	ZafScrollBar(const ZafScrollBar &copy);
	virtual ~ZafScrollBar(void);

	// --- Persistent members ---
	ZafScrollBar(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	bool AutoSize(void) const;
	ZafScrollData *ScrollData(void) const;
	ZafScrollBarType ScrollType(void) const;
	// set
	virtual bool SetAutoSize(bool autoSize);
	virtual ZafError SetScrollData(ZafScrollData *scroll);
	virtual ZafScrollBarType SetScrollType(ZafScrollBarType scrollType);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual ZafSelectionType SetSelectionType(ZafSelectionType selectionType);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetFocus(bool currentFocus);
	virtual bool SetParentPalette(bool parentPalette);
	virtual bool SetSupportObject(bool supportObject);
	virtual bool SetVisible(bool visible);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;

protected:
	friend class ZAF_EXPORT OSScrollBar;
	friend class ZAF_EXPORT OSSlider;

	// --- General members ---
	ZafScrollBarType scrollType;
	ZafScrollData *scrollData;
	bool autoSize;

	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafEventType ScrollEvent(const ZafEventStruct &event);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Data access ---
	static ZafError Update(ZafScrollBar *scrollBar, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return scrollBar->OSSetScroll();
		  else if (type == ZAF_UPDATE_DATA) return scrollBar->OSGetScroll();
		  else return (ZAF_ERROR_INVALID); }

	// --- Advanced class members ---
	virtual ZafWindowObject *NotifyFocus(ZafWindowObject *object, bool focus);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual ZafError OSGetScroll(void);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetScroll(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafScrollBar::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
	static ZafNumberID vNumberID;
	static ZafStringID vStringID;
	static ZafNumberID hNumberID;
	static ZafStringID hStringID;
	static ZafNumberID cNumberID;
	static ZafStringID cStringID;

#	if defined(ZAF_MSDOS) || defined(ZAF_CURSES)
	ZafScrollButton *lButton, *mButton, *rButton;
#	endif
};

// --- inline functions ---
inline bool ZafScrollBar::AutoSize(void) const { return autoSize; }
inline ZafScrollData *ZafScrollBar::ScrollData(void) const { return scrollData; }
inline ZafScrollBarType ZafScrollBar::ScrollType(void) const { return scrollType; }

#endif // Z_SCROLL2_HPP

