//	Zinc Application Framework - Z_SCRLL1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_SCRLL1_HPP)
#define Z_SCRLL1_HPP
#include <z_scrll.hpp>
#include <z_data.hpp>

// --------------------------------------------------------------------------
// ----- ZafScrollData ------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafScrollData : public ZafData, public ZafScrollStruct
{
public:
	// -- General members ---
	ZafScrollData(long minimum = 0, long maximum = 0, long current = 0,
		long delta = 1, long showing = 1);
	ZafScrollData(ZafScrollStruct &data);
	ZafScrollData(const ZafScrollData &copy);
	virtual ~ZafScrollData(void);

	// --- Persistence ---
	ZafScrollData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	// get
	long Current(void) const;
	long Delta(void) const;
	long Maximum(void) const;
	long Minimum(void) const;
	long Showing(void) const;
	long Step(void) const;
	// set
	virtual void Clear(void);
	long Decrement(long value);
	long Increment(long value);
	virtual long SetCurrent(long current);
	virtual long SetDelta(long delta);
	virtual long SetMaximum(long maximum);
	virtual long SetMinimum(long minimum);
	virtual long SetShowing(long showing);
	virtual ZafError SetScroll(long minimum, long maximum, long current, long delta, long showing);
	virtual ZafError SetScroll(const ZafScrollStruct &scroll);
	virtual long SetStep(long step);

	// --- Operators ---
	ZafScrollData &operator=(const ZafScrollData &scroll);
	ZafScrollData &operator=(const ZafScrollStruct &scroll);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafData::IsA(compareName)); }

protected:
	// --- Persistence ---
	void ReadData(ZafDataPersistence &persist);
	virtual ZafDataConstructor ReadFunction(void) { return (ZafScrollData::Read); }
	void WriteData(ZafDataPersistence &persist);

	virtual ZafData *Duplicate(void);
};

// --- inline functions ---
inline long ZafScrollData::Current(void) const { return (current); }
inline long ZafScrollData::Delta(void) const { return (delta); }
inline long ZafScrollData::Decrement(long value) { SetScroll(minimum, maximum, current - value, delta, showing); return (current); }
inline long ZafScrollData::Increment(long value) { SetScroll(minimum, maximum, current + value, delta, showing); return (current); }
inline long ZafScrollData::Maximum(void) const { return (maximum); }
inline long ZafScrollData::Minimum(void) const { return (minimum); }
inline long ZafScrollData::Showing(void) const { return (showing); }
inline ZafScrollData &ZafScrollData::operator=(const ZafScrollData &scroll) { SetScroll(scroll); return *this; }
inline ZafScrollData &ZafScrollData::operator=(const ZafScrollStruct &scroll) { SetScroll(scroll); return *this; }
inline long ZafScrollData::SetCurrent(long newCurrent) { SetScroll(minimum, maximum, newCurrent, delta, showing); return (current); }
inline long ZafScrollData::SetDelta(long newDelta) { SetScroll(minimum, maximum, current, newDelta, showing); return (delta); }
inline long ZafScrollData::SetMaximum(long newMaximum) { SetScroll(minimum, newMaximum, current, delta, showing); return (maximum); }
inline long ZafScrollData::SetMinimum(long newMinimum) { SetScroll(newMinimum, maximum, current, delta, showing); return (minimum); }
inline long ZafScrollData::SetShowing(long newShowing) { SetScroll(minimum, maximum, current, delta, newShowing); return (showing); }
inline long ZafScrollData::SetStep(long newStep) { SetScroll(minimum, maximum, current, newStep, showing); return (delta); }
inline long ZafScrollData::Step(void) const { return (delta); }

#endif // Z_SCROLL1_HPP

