//	Zinc Application Framework - Z_SCLWIN.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_SCLWIN_HPP)
#define Z_SCLWIN_HPP
#include <z_win.hpp>
#include <z_scrll2.hpp>

// --------------------------------------------------------------------------
// ----- ZafScrolledWindow --------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafScrolledWindow : public ZafWindow
{
public:
	// --- General members ---
	ZafScrolledWindow(int left, int top, int width, int height,
		int scrollWidth, int scrollHeight, int hzScrollPos = 0,
		int vtScrollPos = 0);
	ZafScrolledWindow(const ZafScrolledWindow &copy);
	virtual ~ZafScrolledWindow(void);
	virtual void GetClip(ZafWindowObject *object, ZafRegionStruct &clip, ZafRegionStruct &virtualRegion);

	// --- Persistent members ---
	ZafScrolledWindow(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	int ScrollHeight(void);
	int ScrollWidth(void);
	int HzScrollPos(void);
	int VtScrollPos(void);
	// set
	void SetScrollHeight(int height);
	void SetScrollWidth(int width);
	void SetHzScrollPos(int pos);
	void SetVtScrollPos(int pos);

	// --- Window object members ---
	virtual void ConvertCoordinates(ZafCoordinateType coordinateType);
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafCoordinateType SetCoordinateType(ZafCoordinateType coordinateType);

	// --- List members ---
	ZafScrolledWindow &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafScrolledWindow &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;
	virtual void OSSize(void);

protected:
	// --- General members ---
	ZafRegionStruct scrollRegion;

	virtual ZafPositionStruct ConvertToOSPosition(const ZafWindowObject *object,
		const ZafPositionStruct *zafPosition = ZAF_NULLP(ZafPositionStruct)) const;
	virtual ZafPositionStruct ConvertToZafPosition(const ZafWindowObject *object,
		const ZafPositionStruct *osPosition = ZAF_NULLP(ZafPositionStruct)) const;
	virtual ZafEventType ScrollEvent(const ZafEventStruct &event);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafScrolledWindow::Read); }
	void WriteData(ZafObjectPersistence &persist);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSRegisterObject(void);

private:
	static ZafEventMap ZAF_FARDATA defaultEventMap[];
};

#endif // Z_SCLWIN_HPP

