//	Zinc Application Framework - Z_PROMPT.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_PROMPT_HPP)
#define Z_PROMPT_HPP
#include <z_str.hpp>
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafPrompt ----------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafPrompt : public ZafWindowObject
{
public:
	// --- General members ---
	ZafPrompt(int left, int top, int width,
		ZafStringData *stringData = ZAF_NULLP(ZafStringData));
	ZafPrompt(int left, int top, int width,
		const ZafIChar *text);
	ZafPrompt(const ZafPrompt &copy);
	virtual ~ZafPrompt(void);

	// --- Persistence ---
	ZafPrompt(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	bool AutoSize(void) const;
	ZafIChar HotKeyChar(void) const;
	int HotKeyIndex(void) const;
	ZafHzJustify HzJustify(void) const;
	ZafStringData *StringData(void) const;
	virtual const ZafIChar *Text(void);
	bool TransparentBackground(void) const;
	ZafVtJustify VtJustify(void) const;
	// set
	virtual bool SetAutoSize(bool setAutoSize);
	virtual ZafIChar SetHotKey(ZafIChar hotKeyChar, int index = -1);
	virtual ZafHzJustify SetHzJustify(ZafHzJustify hzJustify);
	virtual ZafError SetStringData(ZafStringData *string);
	virtual ZafError SetText(const ZafIChar *text);
	virtual bool SetTransparentBackground(bool transparentBackground);
	virtual ZafVtJustify SetVtJustify(ZafVtJustify vtJustify);

	// --- Window object members ---
	virtual void ConvertCoordinates(ZafCoordinateType coordinateType);
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafRegionStruct Region(void) const;
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetChanged(bool changed);
	virtual ZafCoordinateType SetCoordinateType(ZafCoordinateType coordinateType);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetFocus(bool currentFocus);
	virtual ZafLogicalFont SetFont(ZafLogicalFont font);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual void SetRegion(const ZafRegionStruct &region);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual ZafUserFunction SetUserFunction(ZafUserFunction userFunction);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindowObject::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindowObject::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSPrompt;

	// --- General members ---
	ZafStringData *stringData;
	bool autoSize;
	ZafIChar hotKeyChar;
	int hotKeyIndex;
	ZafHzJustify hzJustify;
	ZafVtJustify vtJustify;
	bool transparentBackground;

	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Special OS ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetText(void);
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);
	static ZafError Update(ZafPrompt *prompt, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return prompt->OSSetText();
		  else return (ZAF_ERROR_INVALID); }

	// --- Persistence ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafPrompt::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
	ZafRegionStruct saveRegion;
};

// --- inline functions ---
inline bool ZafPrompt::AutoSize(void) const { return (autoSize); }
inline ZafIChar ZafPrompt::HotKeyChar(void) const { return (hotKeyChar); }
inline int ZafPrompt::HotKeyIndex(void) const { return (hotKeyIndex); }
inline ZafHzJustify ZafPrompt::HzJustify(void) const { return (hzJustify); }
inline bool ZafPrompt::TransparentBackground(void) const { return (transparentBackground); }
inline ZafStringData *ZafPrompt::StringData(void) const { return (stringData); }
inline ZafVtJustify ZafPrompt::VtJustify(void) const { return (vtJustify); }

#endif // Z_PROMPT_HPP

