//	Zinc Application Framework - Z_PRGRSS.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_PRGRSS_HPP)
#define Z_PRGRSS_HPP
#include <z_scrll1.hpp>
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafProgressBar -----------------------------------------------------
// --------------------------------------------------------------------------

enum ZafProgressType
{
	ZAF_PROGRESS_HORIZONTAL,
	ZAF_PROGRESS_VERTICAL
};

enum ZafProgressStyle
{
  	ZAF_PROGRESS_NATIVE,
  	ZAF_PROGRESS_INDENTED,
	ZAF_PROGRESS_FLAT,
	ZAF_PROGRESS_RAISED
};

enum ZafProgressTextStyle
{
	ZAF_PROGRESS_TEXT_NONE,
	ZAF_PROGRESS_TEXT_VALUE,
	ZAF_PROGRESS_TEXT_PERCENT
};

class ZAF_EXPORT ZafProgressBar : public ZafWindowObject
{
public:
	// --- General members ---
	ZafProgressBar(int left, int top, int width, int height,
		ZafScrollData *scrollData);
	ZafProgressBar(const ZafProgressBar &copy);
	virtual ~ZafProgressBar(void);

	// --- Persistent members ---
	ZafProgressBar(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	long Current(void) const;
	long Delta(void) const;
	long Maximum(void) const;
	long Minimum(void) const;
	ZafScrollData *ProgressData(void) const;
	ZafProgressStyle ProgressStyle(void) const;
	ZafProgressType ProgressType(void) const;
	long Step(void) const;
	ZafProgressTextStyle TextStyle(void) const;
	// set
	long Decrement(long value);
	long Increment(long value);
	long SetCurrent(long current);
	long SetDelta(long current);
	long SetMaximum(long maximum);
	long SetMinimum(long minimum);
	bool SetProgressData(ZafScrollData *progress);
	ZafProgressStyle SetProgressStyle(ZafProgressStyle progressStyle);
	long SetStep(long step);
	ZafProgressTextStyle SetTextStyle(ZafProgressTextStyle style);
	ZafProgressType SetProgressType(ZafProgressType progressType);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual ZafLogicalColor SetBackgroundColor(ZafLogicalColor color, ZafLogicalColor mono = ZAF_MONO_NULL);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetFocus(bool currentFocus);
	virtual ZafLogicalFont SetFont(ZafLogicalFont font);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetParentDrawBorder(bool parentDrawBorder);
	virtual bool SetParentDrawFocus(bool parentDrawFocus);
	virtual bool SetParentPalette(bool parentPalette);
	virtual bool SetSelected(bool selected);
	virtual ZafLogicalColor SetTextColor(ZafLogicalColor color, ZafLogicalColor mono = ZAF_MONO_NULL);
	virtual ZafUserFunction SetUserFunction(ZafUserFunction userFunction);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindowObject::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindowObject::IsA(compareName)); }
	
protected:
	ZafProgressTextStyle textStyle;
	ZafProgressType progressType;
	ZafProgressStyle progressStyle;
	ZafScrollData *progressData;

	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Data access ---
	static ZafError Update(ZafProgressBar *progressBar, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return progressBar->OSSetProgress();
		  else if (type == ZAF_UPDATE_DATA) return (ZAF_ERROR_NONE);
		  else return (ZAF_ERROR_INVALID); }

	// --- Special OS members ---
	virtual ZafError OSSetProgress(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafProgressBar::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];

};

// --- inline functions ---
inline long ZafProgressBar::Current(void) const { return (progressData ? progressData->Current() : 0); }
inline long ZafProgressBar::Decrement(long value) { return (progressData ? progressData->Decrement(value) : 0); }
inline long ZafProgressBar::Delta(void) const { return (progressData ? progressData->Delta() : 0); }
inline long ZafProgressBar::Increment(long value) { return (progressData ? progressData->Increment(value) : 0); }
inline long ZafProgressBar::Minimum(void) const { return (progressData ? progressData->Minimum() : 0); }
inline long ZafProgressBar::Maximum(void) const { return (progressData ? progressData->Maximum() : 0); }
inline ZafProgressStyle ZafProgressBar::ProgressStyle(void) const { return (progressStyle); }
inline ZafProgressTextStyle ZafProgressBar::TextStyle(void) const { return (textStyle); }
inline ZafProgressType ZafProgressBar::ProgressType(void) const { return (progressType); }
inline ZafScrollData *ZafProgressBar::ProgressData(void) const { return (progressData); }
inline long ZafProgressBar::SetCurrent(long tcurrent) { return (progressData ? progressData->SetCurrent(tcurrent) : 0); }
inline long ZafProgressBar::SetDelta(long tDelta) { return (progressData ? progressData->SetDelta(tDelta) : 0); }
inline long ZafProgressBar::SetMaximum(long tmaximum) { return (progressData ? progressData->SetMaximum(tmaximum) : 0); }
inline long ZafProgressBar::SetMinimum(long tminimum) { return (progressData ? progressData->SetMinimum(tminimum) : 0); }
inline long ZafProgressBar::SetStep(long tstep) { return (progressData ? progressData->SetDelta(tstep) : 0); }
inline long ZafProgressBar::Step(void) const { return (progressData ? progressData->Delta() : 0); }

#endif

