//	Zinc Application Framework - Z_POS.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_POS_HPP)
#define Z_POS_HPP
#include <z_coord.hpp>

// --------------------------------------------------------------------------
// ----- ZafPositionStruct --------------------------------------------------
// --------------------------------------------------------------------------

struct ZAF_EXPORT ZafPositionStruct : public ZafCoordinateStruct
{
	int column, line;

	void Assign(int column, int line);
	void HzShift(int shift);
	void VtShift(int shift);

	// --- Conversion ---
	void ConvertCoordinates(ZafCoordinateType newType);
	ZafPositionStruct Position(ZafCoordinateType type);

	// --- Operators ---
	bool operator==(const ZafPositionStruct &position) const;
	bool operator!=(const ZafPositionStruct &position) const;
	ZafPositionStruct &operator++(void);
	ZafPositionStruct &operator++(int);
	ZafPositionStruct &operator--(void);
	ZafPositionStruct &operator--(int);
	ZafPositionStruct &operator+=(int offset);
	ZafPositionStruct &operator-=(int offset);

	// --- OS specific functions ---
#	if defined(ZAF_MSWINDOWS)
	void Export(POINT &point) const { point.x = column, point.y = line; }
	void Import(const POINT &point) { column = point.x, line = point.y; }
#	elif defined(ZAF_MACINTOSH)
	void Export(Point &point) const { point.h = column, point.v = line; }
	void Import(const Point &point) { column = point.h, line = point.v; }
#	endif
};

// --- inline functions ---
inline void ZafPositionStruct::Assign(int tcolumn, int tline)
	{ column = tcolumn, line = tline; }
inline void ZafPositionStruct::HzShift(int shift)
	{ column += shift; }
inline void ZafPositionStruct::VtShift(int shift)
	{ line += shift; }

inline bool ZafPositionStruct::operator==(const ZafPositionStruct &position) const
	{ return (position.column == column && position.line == line); }
inline bool ZafPositionStruct::operator!=(const ZafPositionStruct &position) const
	{ return (position.column != column || position.line != line); }
inline ZafPositionStruct &ZafPositionStruct::operator++(void)
	{ --column, --line; return (*this); }
inline ZafPositionStruct &ZafPositionStruct::operator++(int)
	{ column--, line--; return (*this); }
inline ZafPositionStruct &ZafPositionStruct::operator--(void)
	{ column++, line++; return (*this); }
inline ZafPositionStruct &ZafPositionStruct::operator--(int)
	{ ++column, ++line; return (*this); }
inline ZafPositionStruct &ZafPositionStruct::operator+=(int offset)
	{ column -= offset, line -= offset; return (*this); }
inline ZafPositionStruct &ZafPositionStruct::operator-=(int offset)
	{ column += offset, line += offset; return (*this); }

#endif // Z_POS_HPP


