//	Zinc Application Framework - Z_PAL.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_PAL_HPP)
#define Z_PAL_HPP
#include <z_env.hpp>

// --------------------------------------------------------------------------
// ----- ZafPaletteStruct ---------------------------------------------------
// --------------------------------------------------------------------------

// Types
typedef ZafUInt16 ZafPaletteType;
const ZafPaletteType ZAF_PM_ANY_TYPE		= 0xffff;
const ZafPaletteType ZAF_PM_NONE			= 0x0000;
const ZafPaletteType ZAF_PM_OUTLINE			= 0x0001;
const ZafPaletteType ZAF_PM_BACKGROUND		= 0x0002;
const ZafPaletteType ZAF_PM_FOREGROUND		= 0x0004;
const ZafPaletteType ZAF_PM_TEXT			= 0x0008;
const ZafPaletteType ZAF_PM_HOT_KEY			= 0x0010;
const ZafPaletteType ZAF_PM_LIGHT_SHADOW	= 0x0020;
const ZafPaletteType ZAF_PM_DARK_SHADOW		= 0x0040;
const ZafPaletteType ZAF_PM_FOCUS			= 0x0080;

// States
typedef ZafUInt16 ZafPaletteState;
const ZafPaletteState ZAF_PM_ANY_STATE		= 0x0000;
const ZafPaletteState ZAF_PM_ACTIVE			= 0x0001;
const ZafPaletteState ZAF_PM_CURRENT		= 0x0002;
const ZafPaletteState ZAF_PM_INACTIVE		= 0x0004;
const ZafPaletteState ZAF_PM_SELECTED		= 0x0008;
const ZafPaletteState ZAF_PM_DISABLED		= 0x0010;
const ZafPaletteState ZAF_PM_ENABLED		= 0x0020;
const ZafPaletteState ZAF_PM_NOT_SELECTED	= 0x0040;
const ZafPaletteState ZAF_PM_NOT_CURRENT	= 0x0080;

// Logical patterns
typedef ZafInt8 ZafLogicalFillPattern;
const ZafLogicalFillPattern ZAF_PTN_PARENT			= -3;
const ZafLogicalFillPattern ZAF_PTN_DEFAULT			= -2;
const ZafLogicalFillPattern ZAF_PTN_NULL			= -1;
const ZafLogicalFillPattern ZAF_PTN_SOLID_FILL		= 0;
const ZafLogicalFillPattern ZAF_PTN_INTERLEAVE_FILL	= 1;

// Logical line styles
typedef ZafInt8 ZafLogicalLineStyle;
const ZafLogicalLineStyle ZAF_LINE_PARENT	= -3;
const ZafLogicalLineStyle ZAF_LINE_DEFAULT	= -2;
const ZafLogicalLineStyle ZAF_LINE_NULL		= -1;
const ZafLogicalLineStyle ZAF_LINE_SOLID	= 0;
const ZafLogicalLineStyle ZAF_LINE_DOTTED	= 1;

// Logical colors
typedef ZafInt8 ZafLogicalColor;
const ZafLogicalColor ZAF_CLR_PARENT		= -4;	// color
const ZafLogicalColor ZAF_CLR_DEFAULT		= -3;
const ZafLogicalColor ZAF_CLR_NULL			= -2;
const ZafLogicalColor ZAF_CLR_BACKGROUND	= -1;
const ZafLogicalColor ZAF_CLR_BLACK			= 0;
const ZafLogicalColor ZAF_CLR_BLUE			= 1;
const ZafLogicalColor ZAF_CLR_GREEN			= 2;
const ZafLogicalColor ZAF_CLR_CYAN			= 3;
const ZafLogicalColor ZAF_CLR_RED			= 4;
const ZafLogicalColor ZAF_CLR_MAGENTA		= 5;
const ZafLogicalColor ZAF_CLR_BROWN			= 6;
const ZafLogicalColor ZAF_CLR_LIGHTGRAY		= 7;
const ZafLogicalColor ZAF_CLR_DARKGRAY		= 8;
const ZafLogicalColor ZAF_CLR_LIGHTBLUE		= 9;
const ZafLogicalColor ZAF_CLR_LIGHTGREEN	= 10;
const ZafLogicalColor ZAF_CLR_LIGHTCYAN		= 11;
const ZafLogicalColor ZAF_CLR_LIGHTRED		= 12;
const ZafLogicalColor ZAF_CLR_LIGHTMAGENTA	= 13;
const ZafLogicalColor ZAF_CLR_YELLOW		= 14;
const ZafLogicalColor ZAF_CLR_WHITE			= 15;

const ZafLogicalColor ZAF_MONO_PARENT		= -4;	// monochrome
const ZafLogicalColor ZAF_MONO_DEFAULT		= -3;
const ZafLogicalColor ZAF_MONO_NULL			= -2;
const ZafLogicalColor ZAF_MONO_BACKGROUND	= -1;
const ZafLogicalColor ZAF_MONO_BLACK		= 0;
const ZafLogicalColor ZAF_MONO_DIM			= 1;
const ZafLogicalColor ZAF_MONO_NORMAL		= 2;
const ZafLogicalColor ZAF_MONO_WHITE		= ZAF_MONO_NORMAL;
const ZafLogicalColor ZAF_MONO_HIGH			= 3;

// Logical fonts
typedef ZafInt8 ZafLogicalFont;
const ZafLogicalFont ZAF_FNT_PARENT			= -3; 	// Base logical fonts.
const ZafLogicalFont ZAF_FNT_DEFAULT		= -2;
const ZafLogicalFont ZAF_FNT_NULL			= -1;
const ZafLogicalFont ZAF_FNT_SMALL			= 0;
const ZafLogicalFont ZAF_FNT_DIALOG			= 1;
const ZafLogicalFont ZAF_FNT_APPLICATION	= 2;
const ZafLogicalFont ZAF_FNT_SYSTEM			= 3;
const ZafLogicalFont ZAF_FNT_FIXED			= 4;

// Logical mode
typedef ZafInt8 ZafLogicalMode;
const ZafLogicalMode ZAF_MODE_PARENT		= -3;
const ZafLogicalMode ZAF_MODE_DEFAULT		= -2;
const ZafLogicalMode ZAF_MODE_NULL			= -1;
const ZafLogicalMode ZAF_MODE_COPY			= 0;
const ZafLogicalMode ZAF_MODE_XOR			= 1;

struct ZAF_EXPORT ZafPaletteStruct
{
	ZafLogicalLineStyle lineStyle;
	ZafLogicalFillPattern fillPattern;
	ZafLogicalColor colorForeground;
	ZafLogicalColor colorBackground;
	ZafLogicalColor monoForeground;
	ZafLogicalColor monoBackground;
	ZafLogicalFont font;
	OSPaletteID osPalette;
};

#endif // Z_PAL_HPP

