//	Zinc Application Framework - Z_OBJID.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_OBJID_HPP)
#define Z_OBJID_HPP
#include <z_env.hpp>

// --------------------------------------------------------------------------
// ----- ZafClassID ---------------------------------------------------------
// --------------------------------------------------------------------------

const ZafClassID ID_END						= -1;	// Special values
const ZafClassID ID_DEFAULT					= 0;

const ZafClassID ID_ZAF_BORDER				= 1;
const ZafClassID ID_ZAF_BUTTON				= 2;
const ZafClassID ID_ZAF_DATE				= 3;
const ZafClassID ID_ZAF_FORMATTED_STRING	= 4;
const ZafClassID ID_ZAF_ICON				= 5;
const ZafClassID ID_ZAF_INTEGER				= 6;
const ZafClassID ID_ZAF_MAXIMIZE_BUTTON		= 7;
const ZafClassID ID_ZAF_MINIMIZE_BUTTON		= 8;
const ZafClassID ID_ZAF_UTIME				= 9;
const ZafClassID ID_ZAF_CLOSE_BUTTON		= 10;
const ZafClassID ID_ZAF_PROMPT				= 11;
const ZafClassID ID_ZAF_REAL				= 12;
const ZafClassID ID_ZAF_STRING				= 13;
const ZafClassID ID_ZAF_TEXT				= 15;
const ZafClassID ID_ZAF_TIME				= 16;
const ZafClassID ID_ZAF_TITLE				= 17;
const ZafClassID ID_ZAF_WINDOW_OBJECT		= 18;
const ZafClassID ID_ZAF_POP_UP_ITEM			= 19;
const ZafClassID ID_ZAF_IMAGE				= 20;
const ZafClassID ID_ZAF_MESSAGE_WINDOW		= 21;
const ZafClassID ID_ZAF_DIALOG_WINDOW		= 22;
const ZafClassID ID_ZAF_GROUP				= 23;
const ZafClassID ID_ZAF_BIGNUM				= 24;
const ZafClassID ID_ZAF_CHECK_BOX			= 25;
const ZafClassID ID_ZAF_RADIO_BUTTON		= 26;
const ZafClassID ID_ZAF_TREE_ITEM			= 27;
const ZafClassID ID_ZAF_COMBO_BUTTON		= 28;
const ZafClassID ID_ZAF_SPIN_BUTTON			= 29;

const ZafClassID ID_ZAF_ICHAR				= 100;
const ZafClassID ID_ZAF_INT					= 101;
const ZafClassID ID_ZAF_UINT				= 102;
const ZafClassID ID_ZAF_INT8				= 103;
const ZafClassID ID_ZAF_UINT8				= 104;
const ZafClassID ID_ZAF_INT16				= 105;
const ZafClassID ID_ZAF_UINT16				= 106;
const ZafClassID ID_ZAF_INT32				= 107;
const ZafClassID ID_ZAF_UINT32				= 108;

const ZafClassID ID_ZAF_LIST				= 1001;
const ZafClassID ID_ZAF_POP_UP_MENU			= 1002;
const ZafClassID ID_ZAF_PULL_DOWN_ITEM		= 1003;
const ZafClassID ID_ZAF_PULL_DOWN_MENU		= 1004;
const ZafClassID ID_ZAF_SCROLL_BAR			= 1005;
const ZafClassID ID_ZAF_SYSTEM_BUTTON		= 1006;
const ZafClassID ID_ZAF_WINDOW				= 1007;
const ZafClassID ID_ZAF_COMBO_BOX			= 1008;
const ZafClassID ID_ZAF_TOOL_BAR			= 1009;
const ZafClassID ID_ZAF_VT_LIST				= 1010;
const ZafClassID ID_ZAF_HZ_LIST				= 1011;
const ZafClassID ID_ZAF_PROGRESS_BAR		= 1012;
const ZafClassID ID_ZAF_TABLE				= 1013;
const ZafClassID ID_ZAF_TABLE_RECORD		= 1014;
const ZafClassID ID_ZAF_STATUS_BAR			= 1015;
const ZafClassID ID_ZAF_SPIN_CONTROL		= 1017;
const ZafClassID ID_ZAF_NOTEBOOK			= 1018;
const ZafClassID ID_ZAF_CONSTRAINT			= 1019;
const ZafClassID ID_ZAF_ATTACHMENT			= 1020;
const ZafClassID ID_ZAF_DIMENSION_CONSTRAINT= 1021;
const ZafClassID ID_ZAF_RELATIVE_CONSTRAINT	= 1022;
const ZafClassID ID_ZAF_TABLE_HEADER		= 1023;
const ZafClassID ID_ZAF_TREE_LIST			= 1024;
const ZafClassID ID_ZAF_DATA_CONSTRAINT		= 1025;

const ZafClassID ID_ZAF_EVENT_MANAGER		= 2001;
const ZafClassID ID_ZAF_WINDOW_MANAGER		= 2001;
const ZafClassID ID_ZAF_GEOMETRY_MANAGER	= 2003;
const ZafClassID ID_ZAF_ERROR_SYSTEM		= 2004;
const ZafClassID ID_ZAF_HELP_SYSTEM			= 2005;
const ZafClassID ID_ZAF_COLOR_DIALOG		= 2006;
const ZafClassID ID_ZAF_COLOR_SERVICE		= ID_ZAF_COLOR_DIALOG;
const ZafClassID ID_ZAF_FILE_DIALOG			= 2007;
const ZafClassID ID_ZAF_DIRECTORY_SERVICE	= ID_ZAF_FILE_DIALOG;
const ZafClassID ID_ZAF_FONT_DIALOG			= 2008;
const ZafClassID ID_ZAF_FONT_SERVICE		= ID_ZAF_FONT_DIALOG;
const ZafClassID ID_ZAF_PRINT_DIALOG		= 2009;
const ZafClassID ID_ZAF_PRINTER_SERVICE		= ID_ZAF_PRINT_DIALOG;
const ZafClassID ID_ZAF_SCROLLED_WINDOW		= 2010;
const ZafClassID ID_ZAF_MDI_WINDOW			= 2011;

const ZafClassID ID_ZAF_DEVICE				= 3000;
const ZafClassID ID_ZAF_CURSOR				= 3001;
const ZafClassID ID_ZAF_KEYBOARD			= 3002;
const ZafClassID ID_ZAF_MOUSE				= 3003;
const ZafClassID ID_ZAF_TIMER				= 3004;
const ZafClassID ID_ZAF_HELPTIPS			= 3005;

const ZafClassID ID_ZAF_DATA				= 3100;
const ZafClassID ID_ZAF_FORMAT_DATA			= 3101;
const ZafClassID ID_ZAF_DATE_DATA			= 3102;
const ZafClassID ID_ZAF_INTEGER_DATA		= 3103;
const ZafClassID ID_ZAF_REAL_DATA			= 3104;
const ZafClassID ID_ZAF_STRING_DATA			= 3105;
const ZafClassID ID_ZAF_TIME_DATA			= 3106;
const ZafClassID ID_ZAF_LANGUAGE_DATA		= 3107;
const ZafClassID ID_ZAF_LOCALE_DATA			= 3108;
const ZafClassID ID_ZAF_UTIME_DATA			= 3109;
const ZafClassID ID_ZAF_SCROLL_DATA			= 3110;
const ZafClassID ID_ZAF_BIGNUM_DATA			= 3111;
const ZafClassID ID_ZAF_BITMAP_DATA			= 3112;
const ZafClassID ID_ZAF_ICON_DATA			= 3113;
const ZafClassID ID_ZAF_MOUSE_DATA			= 3114;
const ZafClassID ID_ZAF_IMAGE_DATA			= 3115;
const ZafClassID ID_ZAF_HELP_DATA			= 3116;
const ZafClassID ID_ZAF_DATA_RECORD			= 3117;
const ZafClassID ID_ZAF_DATA_MANAGER		= 3118;
const ZafClassID ID_ZAF_PALETTE_DATA		= 3119;
const ZafClassID ID_ZAF_I18N_DATA			= 3120;
const ZafClassID ID_ZAF_CODE_SET_DATA		= 3121;
const ZafClassID ID_ZAF_CHAR_LOOKUP         = 3122;
const ZafClassID ID_ZAF_WCHAR_LOOKUP        = 3123;

const ZafClassID ID_DERIVE_START			= 3500;
const ZafClassID ID_DERIVE_END				= 3999;

#endif // Z_OBJID_HPP

