//	Zinc Application Framework - Z_MSGWIN.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_MSGWIN_HPP)
#define Z_MSGWIN_HPP
#include <z_dlgwin.hpp>
#include <z_button.hpp>
#include <z_icon1.hpp>
#include <z_text.hpp>

// --------------------------------------------------------------------------
// ----- ZafMessageWindow ---------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafMessageWindow : public ZafDialogWindow
{
public:
	// --- General members ---
	ZafMessageWindow(const ZafIChar *title, ZafIconImage iconImage,
		ZafDialogFlags msgFlags, ZafDialogFlags defaultFlag,
		const ZafIChar *format, ...);
	ZafMessageWindow(ZafStringData *title, ZafIconImage iconImage,
		ZafDialogFlags msgFlags, ZafDialogFlags defaultFlag,
		const ZafIChar *format, ...);
	ZafMessageWindow(const ZafMessageWindow &copy);
	virtual ~ZafMessageWindow(void);

	// --- Persistent members ---
	ZafMessageWindow(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafDialogFlags DefaultMessageFlag(void) const;
	ZafIconImage IconImage(void) const;
	const ZafIChar *Message(void) const;
	ZafDialogFlags MessageFlags(void) const;
	// set
	ZafDialogFlags ClearMessageFlag(ZafDialogFlags msgFlags);
	ZafDialogFlags SetDefaultMessageFlag(ZafDialogFlags msgFlags);
	ZafIconImage SetIconImage(ZafIconImage iconImage);
	void SetMessage(const ZafIChar *message);
	ZafDialogFlags SetMessageFlag(ZafDialogFlags msgFlags);

	// --- Window members ---
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual ZafSelectionType SetSelectionType(ZafSelectionType selectionType);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetAutomaticUpdate(bool automaticUpdate);
	virtual bool SetBordered(bool bordered);
	virtual bool SetDisabled(bool disabled);
	virtual const ZafIChar *SetHelpObjectTip(const ZafIChar *helpObjectTip);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

protected:
	ZafDialogFlags msgFlags, defFlag;
	ZafIconImage iconImage;

	void AddFields(void);

	// --- Language & locale support ---
	static ZafLanguageData *language;
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafMessageWindow::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	ZafIcon *icon;
	ZafText *textField;
	ZafTitle *title;
	ZafButton *firstButton;
};

// --- inline functions ---
inline ZafDialogFlags ZafMessageWindow::DefaultMessageFlag(void) const { return (defFlag); }
inline ZafIconImage ZafMessageWindow::IconImage(void) const { return (iconImage); }
inline const ZafIChar *ZafMessageWindow::Message(void) const { return (textField ? textField->Text() : ZAF_NULLP(ZafIChar)); }
inline ZafDialogFlags ZafMessageWindow::MessageFlags(void) const { return (msgFlags); }

#endif // Z_MSGWIN_HPP

