//	Zinc Application Framework - Z_MOUSE1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_MOUSE1_HPP)
#define Z_MOUSE1_HPP
#include <z_idata.hpp>

// --------------------------------------------------------------------------
// ----- ZafMouseData -------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafMouseData : public ZafImageData, public ZafMouseStruct
{
public:
	// --- General members ---
	ZafMouseData(const ZafImageStruct &data);
	ZafMouseData(const ZafMouseStruct &data);
	ZafMouseData(const ZafMouseData &copy);
	virtual ~ZafMouseData(void);

	// --- Persistent members ---
	ZafMouseData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafLogicalColor *Array(void) const;
	int Height(void) const;
	int HotSpotX(void) const;
	int HotSpotY(void) const;
	int Width(void) const;
	// set
	virtual void Clear(void);
	virtual ZafError SetHotSpot(int hotSpotX, int hotSpotY);
	virtual ZafError SetMouse(int width, int height, ZafLogicalColor *array);
	virtual ZafError SetMouse(const ZafMouseStruct &mouse);

	// --- Operators ---
	ZafMouseData &operator=(const ZafMouseData &mouse);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafData::IsA(compareName)); }

protected:
	// --- Persistent members ---
	void ReadData(ZafDataPersistence &persist);
	virtual ZafDataConstructor ReadFunction(void) { return (ZafMouseData::Read); }
	void WriteData(ZafDataPersistence &persist);

	virtual ZafData *Duplicate(void);
};

// --- inline functions ---
inline ZafLogicalColor *ZafMouseData::Array(void) const { return (array); }
inline int ZafMouseData::Height(void) const { return (height); }
inline int ZafMouseData::HotSpotX(void) const { return (hotSpotX); }
inline int ZafMouseData::HotSpotY(void) const { return (hotSpotY); }
inline int ZafMouseData::Width(void) const { return (width); }
inline ZafMouseData &ZafMouseData::operator=(const ZafMouseData &mouse) { SetMouse(mouse); return *this; }

#endif // Z_MOUSE1_HPP

