//	Zinc Application Framework - Z_MOUSE.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_MOUSE_HPP)
#define Z_MOUSE_HPP
#include <z_env.hpp>

// --------------------------------------------------------------------------
// ----- Mouse Information --------------------------------------------------
// --------------------------------------------------------------------------
// --- event.type is E_MOUSE
// --- event.rawCode is the mouse shift state (high byte) and button status (low byte)
// --- event.position.line and event.position.column contains the mouse position

const ZafRawCode M_LEFT				= 0x0100;
const ZafRawCode M_RIGHT			= 0x0200;
const ZafRawCode M_MIDDLE			= 0x0400;
const ZafRawCode M_LEFT_CHANGE		= 0x1000;
const ZafRawCode M_RIGHT_CHANGE		= 0x2000;
const ZafRawCode M_MIDDLE_CHANGE	= 0x4000;

const ZafRawCode ZAF_SIZE_LEFT		= 0x0001; // Sizing left border.
const ZafRawCode ZAF_SIZE_TOP		= 0x0002; // Sizing top border.
const ZafRawCode ZAF_SIZE_RIGHT		= 0x0004; // Sizing right border.
const ZafRawCode ZAF_SIZE_BOTTOM	= 0x0008; // Sizing bottom border.

#endif // Z_MOUSE_HPP

