//	Zinc Application Framework - Z_MIN.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_MIN_HPP)
#define Z_MIN_HPP
#include <z_button.hpp>

// --------------------------------------------------------------------------
// ----- ZafMinimizeButton --------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafMinimizeButton : public ZafButton
{
public:
	// --- General class members ---
	ZafMinimizeButton(void);
	ZafMinimizeButton(const ZafMinimizeButton &copy);
	virtual ~ZafMinimizeButton(void);

	// --- Persistent members ---
	ZafMinimizeButton(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Button members ---
	virtual bool SetAllowDefault(bool allowDefault);
	virtual bool SetAllowToggling(bool allowToggling);
	virtual bool SetAutoRepeatSelection(bool autoRepeatSelection);
	virtual bool SetAutoSize(bool autoSize);
	virtual ZafButtonType SetButtonType(ZafButtonType buttonType);
	virtual int SetDepth(int depth);
	virtual ZafIChar SetHotKey(ZafIChar hotKeyChar, int index = -1);
	virtual ZafHzJustify SetHzJustify(ZafHzJustify hzJustify);
	virtual bool SetSelectOnDoubleClick(bool selectOnDoubleClick);
	virtual bool SetSelectOnDownClick(bool selectOnDownClick);
	virtual bool SetSendMessageWhenSelected(bool sendMessageWhenSelected);
	virtual ZafEventType SetValue(ZafEventType value);
	virtual ZafVtJustify SetVtJustify(ZafVtJustify vtJustify);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetFocus(bool currentFocus);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual const ZafIChar *SetHelpObjectTip(const ZafIChar *helpObjectTip);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetParentDrawBorder(bool parentDrawBorder);
	virtual bool SetParentDrawFocus(bool parentDrawFocus);
	virtual bool SetParentPalette(bool parentPalette);
	virtual const ZafIChar *SetQuickTip(const ZafIChar *quickTip);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSelected(bool selected);
	virtual bool SetSupportObject(bool supportObject);
	virtual ZafUserFunction SetUserFunction(ZafUserFunction userFunction);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindowObject::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindowObject::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSMinimizeButton;

	// --- General class members ---
	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Special OS members ---
	virtual void OSRegisterObject(void);
	virtual void OSSize(void);
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);

	// --- Persistent members ---
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafMinimizeButton::Read); }

	// --- Image support ---
	static char minName[];
	static char ZAF_FARDATA minDepressedName[];
	static ZafBitmapData *minBitmap;
	static ZafBitmapData *minDepressedBitmap;
	static void ImageAllocate(void);
	static void ImageFree(bool globalRequest = false);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

#endif // Z_MIN_HPP

