//	Zinc Application Framework - Z_MDIWIN.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_MDIWIN_HPP)
#define Z_MDIWIN_HPP
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafMDIWindow -------------------------------------------------------
// --------------------------------------------------------------------------

enum ZafMDIType
{
	ZAF_MDI_PARENT		= 0,
	ZAF_MDI_CHILD		= 1
};

class ZAF_EXPORT ZafMDIWindow : public ZafWindow
{
public:
	// --- General members ---
	ZafMDIWindow(int left, int top, int width, int height, ZafMDIType type);
	ZafMDIWindow(const ZafMDIWindow &copy);
	virtual ~ZafMDIWindow(void);

	// --- Persistent members ---
	ZafMDIWindow(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	ZafMDIType MDIType(void) const;
	virtual ZafWindowObject *RootObject(void) const;

	// --- Window members ---
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafEventType Event(const ZafEventStruct &event);
	ZafLogicalEvent LogicalEvent(const ZafEventStruct &event);
	virtual ZafEventType MoveEvent(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetParentPalette(bool parentPalette);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual ZafSelectionType SetSelectionType(ZafSelectionType selectionType);
	virtual bool SetVisible(bool visible);

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));

	ZafMDIWindow &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafMDIWindow &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Advanced class members ---
	virtual ZafWindowObject *NotifyFocus(ZafWindowObject *object, bool focus);

protected:
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafMDIWindow::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	ZafMDIType mdiType;

	static ZafEventMap ZAF_FARDATA defaultEventMap[];
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

// --- inline functions ---
inline ZafMDIType ZafMDIWindow::MDIType(void) const { return (mdiType); }

#endif // Z_MDIWIN_HPP

