//	Zinc Application Framework - Z_LOGEVT.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_LOGEVT_HPP)
#define Z_LOGEVT_HPP
#include <z_event.hpp>
#include <z_sysevt.hpp>

// --------------------------------------------------------------------------
// ----- ZafLogicalEvent ----------------------------------------------------
// --------------------------------------------------------------------------

const ZafLogicalEvent L_EXIT				= 1000;	// General
const ZafLogicalEvent L_VIEW				= 1001;
const ZafLogicalEvent L_SELECT				= 1002;
const ZafLogicalEvent L_BEGIN_SELECT		= 1003;
const ZafLogicalEvent L_CONTINUE_SELECT		= 1004;
const ZafLogicalEvent L_END_SELECT			= 1005;
const ZafLogicalEvent L_BEGIN_ESCAPE		= 1006;
const ZafLogicalEvent L_CONTINUE_ESCAPE		= 1007;
const ZafLogicalEvent L_END_ESCAPE			= 1008;
const ZafLogicalEvent L_HELP				= 1009;
const ZafLogicalEvent L_CANCEL				= 1010;
// unused									= 1011;
const ZafLogicalEvent L_DOUBLE_CLICK		= 1012;
const ZafLogicalEvent L_MOVE_MODE			= 1013;
const ZafLogicalEvent L_SIZE_MODE			= 1014;
const ZafLogicalEvent L_SYSTEM_MENU			= 1015;
const ZafLogicalEvent L_RESTORE				= 1016;
const ZafLogicalEvent L_MINIMIZE			= 1017;
const ZafLogicalEvent L_MAXIMIZE			= 1018;
const ZafLogicalEvent L_CLOSE				= 1019;
const ZafLogicalEvent L_CLOSE_TEMPORARY		= 1020;

const ZafLogicalEvent L_NEXT_WINDOW			= 1040;	// ZafWindowManager
const ZafLogicalEvent L_ALT_KEY				= 1041;

const ZafLogicalEvent L_UP					= 1050;	// ZafWindowObject
const ZafLogicalEvent L_DOWN				= 1051;
const ZafLogicalEvent L_LEFT				= 1052;
const ZafLogicalEvent L_RIGHT				= 1053;
const ZafLogicalEvent L_PREVIOUS			= 1054;
const ZafLogicalEvent L_NEXT				= 1055;
const ZafLogicalEvent L_FIRST				= 1056;
const ZafLogicalEvent L_LAST				= 1057;
const ZafLogicalEvent L_PGUP				= 1058;
const ZafLogicalEvent L_PGDN				= 1059;
const ZafLogicalEvent L_EXTEND_PREVIOUS		= 1060;
const ZafLogicalEvent L_EXTEND_NEXT			= 1061;
const ZafLogicalEvent L_EXTEND_FIRST		= 1062;
const ZafLogicalEvent L_EXTEND_LAST			= 1063;

// unused									= 1101;	// ZafString
// unused									= 1102;
// unused									= 1103;
const ZafLogicalEvent L_CUT					= 1104;
const ZafLogicalEvent L_PASTE				= 1105;
// unused									= 1106;
// unused									= 1107;
const ZafLogicalEvent L_DELETE				= 1108;
const ZafLogicalEvent L_DELETE_WORD			= 1109;
const ZafLogicalEvent L_DELETE_EOL			= 1110;
const ZafLogicalEvent L_INSERT_TOGGLE		= 1114;
const ZafLogicalEvent L_WORD_LEFT			= 1115;
const ZafLogicalEvent L_WORD_RIGHT			= 1116;
const ZafLogicalEvent L_BOL					= 1117;
const ZafLogicalEvent L_EOL					= 1118;
const ZafLogicalEvent L_BACKSPACE			= 1119;

const ZafLogicalEvent L_COPY				= 1127;

const ZafLogicalEvent L_MARK_LEFT	  		= 1130;
const ZafLogicalEvent L_MARK_RIGHT	  		= 1131;
const ZafLogicalEvent L_MARK_UP		  		= 1132;
const ZafLogicalEvent L_MARK_DOWN	  		= 1133;
const ZafLogicalEvent L_MARK_BOL	  		= 1134;
const ZafLogicalEvent L_MARK_EOL	  		= 1135;
const ZafLogicalEvent L_MARK_PGUP	  		= 1136;
const ZafLogicalEvent L_MARK_PGDN	  		= 1137;
const ZafLogicalEvent L_MARK_WORD_RIGHT		= 1138;
const ZafLogicalEvent L_MARK_WORD_LEFT		= 1139;

// unused									= 1200;
// unused									= 1201;
const ZafLogicalEvent L_TOGGLE_EXPANDED		= 1202;	// ZafTreeList

// unused									= 500;	// ZafMDIWindow
const ZafLogicalEvent L_MDI_NEXT_WINDOW		= 501;	
const ZafLogicalEvent L_MDI_MOVE_MODE		= 502;
const ZafLogicalEvent L_MDI_SIZE_MODE		= 503;

const ZafLogicalEvent L_NONE				= L_LOGICAL_LAST;

#endif // Z_LOGEVT_HPP

