//	Zinc Application Framework - Z_LOC.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_LOC_HPP)
#define Z_LOC_HPP
#include <z_i18n.hpp>

// --------------------------------------------------------------------------
// ----- ZafLocaleData ------------------------------------------------------
// --------------------------------------------------------------------------

struct ZAF_EXPORT ZafEraStruct
{
	ZafUInt16 direction;
	ZafUInt16 offset;
	ZafUInt32 startDate;
	ZafUInt32 endDate;
	ZafIChar eraName[6];
	ZafIChar eraFormat[8];
};

struct ZAF_EXPORT ZafLocaleStruct
{
	ZafIChar decimalSeparator[4];
	ZafIChar monDecimalSeparator[4];
	ZafIChar thousandsSeparator[4];
	ZafIChar monThousandsSeparator[4];
	ZafIChar currencySymbol[8];
	char grouping[10];
	char monGrouping[10];
	ZafIChar intCurrencySymbol[5];
	int posCurrencyPrecedes;
	int negCurrencyPrecedes;
	int fractionDigits;
	int intFractionDigits;
	ZafIChar positiveSign[4];
	int posSignPrecedes;
	int posSpaceSeparation;
	ZafIChar negativeSign[4];
	int negSignPrecedes;
	int negSpaceSeparation;

	ZafIChar *creditLeftParen;
	ZafIChar *creditRightParen;

	ZafIChar *integerStringInputFormat;
	ZafIChar *integerStringOutputFormat;
	ZafIChar *realStringInputFormat;
	ZafIChar *realStringOutputFormat;
	ZafIChar *timeStringInputFormat;
	ZafIChar *timeStringOutputFormat;
	ZafIChar *time12StringOutputFormat;
	ZafIChar *dateStringInputFormat;
	ZafIChar *dateStringOutputFormat;
	ZafIChar *dateTimeStringInputFormat;
	ZafIChar *dateTimeStringOutputFormat;
	ZafIChar *defDigits;
	ZafIChar *altDigits;

	ZafIChar timeSeparator[4];
	ZafIChar dateSeparator[4];
	ZafUInt32 beginGregorian;
	ZafUInt16 skipGregorian;
	int eraTableLength;
	ZafEraStruct *eraTable;
};

class ZAF_EXPORT ZafLocaleData : public ZafI18nData, public ZafLocaleStruct
{
public:
	// --- General members ---
	ZafLocaleData(void);
	ZafLocaleData(const ZafLocaleStruct &data);
	ZafLocaleData(const ZafLocaleData &copy);
	virtual ~ZafLocaleData(void);
	static ZafUInt32 TimeStamp(void);

	// --- Persistent members ---
	ZafLocaleData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	// get
	static const ZafIChar *LocaleName(void);
	// set
	virtual void Clear(void);
	ZafError SetLocale(const ZafLocaleStruct &value);
	static ZafError SetLocaleName(const ZafIChar *localeName);

	// --- Default locale ---
	static void LocaleAllocate(const ZafIChar *name = ZAF_NULLP(ZafIChar));
	static void LocaleFree(bool globalRequest = false);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafI18nData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafI18nData::IsA(compareName)); }
	
protected:
	static ZafLocaleData *canonicalLocale;

	// --- Persistent members ---
	void ReadData(ZafDataPersistence &persist);
	virtual ZafDataConstructor ReadFunction(void) { return (ZafLocaleData::Read); }
	void WriteData(ZafDataPersistence &persist);

	virtual ZafData *Duplicate(void);

private:
	static bool OSLocaleInformation(ZafLocaleStruct &localeInfo);
};

extern ZAF_EXPORT ZafLocaleData *zafLocale;

// --- inline functions ---
inline const ZafIChar *ZafLocaleData::LocaleName(void) { return (zafLocale ? zafLocale->StringID() : ZAF_NULLP(ZafIChar)); }

#endif // Z_LOC_HPP

