//	Zinc Application Framework - Z_KEYBRD.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_KEYBRD_HPP)
#define Z_KEYBRD_HPP
#include <z_device.hpp>

// --------------------------------------------------------------------------
// ----- ZafKeyboard --------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafKeyboard : public ZafDevice
{
public:
	// --- General members ---
	ZafKeyboard(ZafDeviceState state = D_ON);
	virtual ~ZafKeyboard(void);

	// --- Attributes & data access ---
	// get
	bool AltPressed(unsigned int shiftState) const { return ((shiftState & S_ALT) ? true : false); }
	bool CtrlPressed(unsigned int shiftState) const { return ((shiftState & S_CTRL) ? true : false); }
	bool ShiftPressed(unsigned int shiftState) const { return ((shiftState & S_SHIFT) ? true : false); }
	// set

#	if defined(ZAF_MSDOS) || defined(ZAF_CURSES)
	static ZafEventType BreakHandlerSet(void);
	static ZafEventType SetBreakHandlerSet(ZafEventType breakHandlerSet);
#	endif

	// --- Device members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual void Poll(void);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafDevice::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafDevice::IsA(compareName)); }

#	if defined(ZAF_MSDOS) || defined(ZAF_CURSES)
protected:
	static ZafEventType breakHandlerSet;
#	endif

private:
	ZafKeyboard(const ZafKeyboard &copy);
};

#	if defined(ZAF_MSDOS) || defined(ZAF_CURSES)
// --- inline functions ---
inline ZafEventType ZafKeyboard::BreakHandlerSet(void) { return breakHandlerSet; }
#	endif

#endif // Z_KEYBRD_HPP

