//	Zinc Application Framework - Z_INT1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_INT1_HPP)
#define Z_INT1_HPP
#include <z_int.hpp>
#include <z_str1.hpp>
#include <z_lang.hpp>
#include <z_loc.hpp>

// --------------------------------------------------------------------------
// ----- ZafInteger ---------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafInteger : public ZafString
{
public:
	// --- General members ---
	ZafInteger(int left, int top, int width,
		ZafIntegerData *integerData = ZAF_NULLP(ZafIntegerData));
	ZafInteger(int left, int top, int width,
		long value);
	ZafInteger(const ZafInteger &copy);
	virtual ~ZafInteger(void);

	// --- Persistent members ---
	ZafInteger(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafIntegerData *IntegerData(void) const;
	// set
	virtual ZafError SetIntegerData(ZafIntegerData *integerData);

	// --- String members ---
	virtual bool SetLowerCase(bool lowerCase);
	virtual bool SetPassword(bool password);
	virtual ZafError SetStringData(ZafStringData *string);
	virtual bool SetUpperCase(bool upperCase);
	virtual bool SetVariableName(bool variableName);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafError SetText(const ZafIChar *text);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafString::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafString::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSInteger;

	// --- General members ---
	virtual ZafWindowObject *Duplicate(void);

	// --- Data access ---
	ZafIntegerData *integerData;
	virtual ZafError Decrement(ZafData *data);
	virtual ZafError Increment(ZafData *data);
	static ZafError Update(ZafInteger *integer, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return integer->OSSetInteger();
		  else if (type == ZAF_UPDATE_DATA) return integer->OSGetInteger();
		  else return (ZAF_ERROR_INVALID); }
	virtual ZafError Validate(bool processError = true);

	// --- Special OS members ---
	ZafError OSGetInteger(void);
	ZafError OSSetInteger(void);

	// --- Language & locale support ---
	static ZafLanguageData *errorStrings;
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafInteger::Read); }
	void WriteData(ZafObjectPersistence &persist);
};

// --- inline functions ---
inline ZafIntegerData *ZafInteger::IntegerData(void) const { return integerData; }
inline ZafError ZafInteger::SetText(const ZafIChar *text) { return (integerData->SetInteger(text, inputFormatData ? inputFormatData->Text() : ZAF_NULLP(ZafIChar))); }

#endif // Z_INT1_HPP

