//	Zinc Application Framework - Z_IDATA.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_IDATA_HPP)
#define Z_IDATA_HPP
#include <z_dsp.hpp>
#include <z_data.hpp>

// --------------------------------------------------------------------------
// ----- ZafImageData -------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafImageData : public ZafData
{
public:
	// --- General members ---
	virtual ~ZafImageData(void);

	// --- Persistent members ---
	ZafImageData(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafData::IsA(compareName)); }

protected:
	// --- General members ---
	ZafImageData(void);
	ZafImageData(const ZafImageData &copy);
	ZafError InitializeImage(ZafImageStruct &image);
	ZafError SetImage(ZafImageStruct &image, const ZafImageStruct &copy);
	ZafError SetImage(ZafImageStruct &image, int width, int height, ZafLogicalColor *array);
};

#endif // Z_IDATA_HPP

