//	Zinc Application Framework - Z_I18N.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_I18N_HPP)
#define Z_I18N_HPP
#include <z_data.hpp>

// --------------------------------------------------------------------------
// ----- ZafI18nData --------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafI18nData : public ZafData
{
public:
	// --- General members ---
	virtual ~ZafI18nData(void);
	static const ZafIChar *CountryCodeToZafLocale(int countryCode);
	static const ZafIChar *OSLanguageToZafLanguage(const ZafIChar *osLanguage);
	static const ZafIChar *ZafLocaleToZafLanguage(const ZafIChar *zafLocale);
	static const ZafIChar *ZafLanguageToZafLocale(const ZafIChar *zafLanguage);
	static const ZafIChar *OSI18nName(void);

	// --- Attributes & data access ---
	// get
	static const ZafIChar *I18nName(void);
	// set
	static ZafError SetI18nName(const ZafIChar *i18nName);
	static ZafError SetI18nName(const ZafIChar *languageName, const ZafIChar *localeName, const ZafIChar *codeSetName);

	// --- Default i18n ---
	static void I18nAllocate(const ZafIChar *i18nName = ZAF_NULLP(ZafIChar));
	static void I18nFree(bool globalRequest = false);
	static void ResetI18n(const ZafIChar *newName = ZAF_NULLP(ZafIChar));

	// --- Persistent members ---
	ZafI18nData(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafData::IsA(compareName)); }

protected:
	// --- General members ---
	ZafI18nData(void);
	ZafI18nData(const ZafI18nData &copy);

private:
	static ZafIChar i18nName[64];
};

#endif // Z_I18N_HPP

