//	Zinc Application Framework - Z_HTIPS.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_HTIPS_HPP)
#define Z_HTIPS_HPP
#include <z_device.hpp>
#include <z_win.hpp>

#if defined(ZAF_MSWINDOWS)
#	include <time.h>
#endif

// --------------------------------------------------------------------------
// ----- ZafHelpTips --------------------------------------------------------
// --------------------------------------------------------------------------

// --- Help tips device messages ---
const ZafDeviceState DH_HELP_TIPS_LAST		= -3300;
const ZafDeviceState DH_SET_HELP_OBJECT		= -3300;
const ZafDeviceState DH_UPDATE_HELP_OBJECT	= -3301;
const ZafDeviceState DH_HELP_TIPS_TIMER	    = -3302;
const ZafDeviceState DH_HELP_TIPS_FIRST		= -3399;

#define ZAF_HELPTIPS_VT_OFFSET				16
#define ZAF_HELPTIPS_QUICK_INTERVAL			25

enum ZafHelpTipsType
{
	ZAF_HELPTIPS_QUICKTIP	= 0,
	ZAF_HELPTIPS_HELPOBJECT	= 1,
	ZAF_HELPTIPS_BOTH		= 2
};

class ZAF_EXPORT ZafHelpTips : public ZafDevice
{
public:
	// --- General members ---
	ZafHelpTips(ZafDeviceState state = D_OFF, ZafHelpTipsType tHelpTipsType = ZAF_HELPTIPS_QUICKTIP);
	virtual ~ZafHelpTips(void);

	// --- Attributes & data access ---
	// get
	ZafWindowObject *HelpObject(void) const;
	ZafHelpTipsType HelpTipsType(void) const;
	int InitialDelay(void);
	int NewHelpTipDelay(void);
	// set
	virtual void SetHelpObject(ZafWindowObject *helpObject);
	virtual ZafHelpTipsType SetHelpTipsType(ZafHelpTipsType helpTipsType);
	void SetUserPalette(ZafPaletteStruct *userPalette);
	static int SetInitialDelay(int initialDelay);
	static int SetNewHelpTipDelay(int newHelpTipDelay);

	// --- Device members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual void Poll(void);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafDevice::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafDevice::IsA(compareName)); }

protected:
	OSTimerHandle displayTimerHandle;
	bool quickTipVisible;
	bool allowQuickSiblingDisplay;
	ZafHelpTipsType helpTipsType;
	ZafPositionStruct lastMousePosition;
	ZafRegionStruct quickTipRegion;
	ZafIChar *replaceText;

	// --- Help tip functions ---
	virtual void DisplayHelpObjectTip(void);
	virtual void DisplayQuickTip(void);
	virtual void RemoveHelpTip(void);
	void Reset(OSTimerHandle &timerHandle, bool resetTimer, unsigned long interval, ZafEventStruct *event);

#if defined(ZAF_MSDOS)
	unsigned long lastTime;
#elif defined(ZAF_MSWINDOWS)
	HBITMAP screenBuffer;
	clock_t lastTime;
#elif defined(ZAF_MOTIF)
	Window quickTipWindow;
	Time lastTime;
#endif

private:
	static int initialDelay;
	static int newHelpTipDelay;
	ZafPaletteStruct quickTipPalette;
	ZafPaletteStruct *userPalette;
	ZafHelpTips(const ZafHelpTips &copy);
};

// --- inline functions ---
inline ZafWindowObject *ZafHelpTips::HelpObject(void) const { return (zafWindowManager ? zafWindowManager->helpObject : ZAF_NULLP(ZafWindowObject)); }
inline ZafHelpTipsType ZafHelpTips::HelpTipsType(void) const { return helpTipsType; }
inline int ZafHelpTips::InitialDelay(void) { return (initialDelay); }
inline int ZafHelpTips::NewHelpTipDelay(void) { return (newHelpTipDelay); }

#endif // Z_HTIPS_HPP

