//	Zinc Application Framework - Z_GROUP.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_GROUP_HPP)
#define Z_GROUP_HPP
#include <z_str.hpp>
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafGroup -----------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafGroup : public ZafWindow
{
public:
	// --- General members ---
	ZafGroup(int left, int top, int width, int height,
		ZafStringData *stringData);
	ZafGroup(int left, int top, int width, int height,
		const ZafIChar *text);
	ZafGroup(const ZafGroup &copy);
	virtual ~ZafGroup(void);

	// --- Persistent members ---
	ZafGroup(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	bool AutoSelect(void) const;
	ZafIChar HotKeyChar(void) const;
	int HotKeyIndex(void) const;
	ZafStringData *StringData(void) const;
	// set
	virtual bool SetAutoSelect(bool autoSelect);
	virtual bool SetBordered(bool bordered);
	virtual ZafIChar SetHotKey(ZafIChar hotKeyChar, int index = -1);
	virtual ZafError SetStringData(ZafStringData *string);

	// --- Window members ---
	virtual ZafWindowObject *NotifyFocus(ZafWindowObject *object, bool focus);
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetDisabled(bool setDisabled);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	ZafLogicalEvent LogicalEvent(const ZafEventStruct &event);
	virtual const ZafIChar *Text(void);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual ZafError SetText(const ZafIChar *text);

	// --- List members ---
	ZafGroup &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafGroup &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);

protected:
	friend class ZAF_EXPORT OSGroup;

	// --- General members ---
	bool autoSelect;
	ZafIChar hotKeyChar;
	int hotKeyIndex;
	int hzSpacing;
	ZafStringData *stringData;

	virtual ZafPositionStruct ConvertToOSPosition(const ZafWindowObject *object,
		const ZafPositionStruct *zafPosition = ZAF_NULLP(ZafPositionStruct)) const;
	virtual ZafPositionStruct ConvertToZafPosition(const ZafWindowObject *object,
		const ZafPositionStruct *osPosition = ZAF_NULLP(ZafPositionStruct)) const;
	virtual ZafEventType DrawBorder(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);
	virtual ZafRegionStruct MaxRegion(ZafWindowObject *object,
		ZafVtJustify vWeight = ZAF_VT_TOP, ZafHzJustify hWeight = ZAF_HZ_LEFT);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetText(void);
	static ZafError Update(ZafGroup *group, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return group->OSSetText();
		  else if (type == ZAF_UPDATE_DATA) return (ZAF_ERROR_NONE);
		  else return (ZAF_ERROR_INVALID); }

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafGroup::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
	static ZafEventMap ZAF_FARDATA defaultEventMap[];
};

// --- inline functions ---
inline bool ZafGroup::AutoSelect(void) const { return autoSelect; }
inline ZafIChar ZafGroup::HotKeyChar(void) const { return hotKeyChar; }
inline int ZafGroup::HotKeyIndex(void) const { return hotKeyIndex; }
inline ZafStringData *ZafGroup::StringData(void) const { return (stringData); }

#endif // Z_GROUP_HPP

