//	Zinc Application Framework - Z_FMTSTR.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_FMTSTR_HPP)
#define Z_FMTSTR_HPP
#include <z_str1.hpp>

// --------------------------------------------------------------------------
// ----- ZafFormattedString -------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafFormattedString : public ZafString
{
public:
	// --- General members ---
	ZafFormattedString(int left, int top, int width,
		const ZafIChar *compressedText, const ZafIChar *format,
		const ZafIChar *deleteText);
	ZafFormattedString(int left, int top, int width,
		ZafStringData *compressedText, ZafStringData *format,
		ZafStringData *deleteText);
	ZafFormattedString(const ZafFormattedString &copy);
	virtual ~ZafFormattedString(void);

	// --- Persistent members ---
	ZafFormattedString(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafStringData *CompressedData(void) const;
	ZafStringData *DeleteData(void) const;
	ZafStringData *ExpandedData(void) const;
	ZafStringData *FormatData(void) const;
	virtual const ZafIChar *Text(void);
	// set
	virtual ZafError SetCompressedData(ZafStringData *compressedData);
	virtual ZafError SetCompressedText(const ZafIChar *compressedText);
	virtual ZafError SetDeleteData(ZafStringData *deleteData);
	virtual ZafError SetDeleteText(const ZafIChar *format);
	virtual ZafError SetExpandedData(ZafStringData *expandedData);
	virtual ZafError SetExpandedText(const ZafIChar *expanded);
	virtual ZafError SetFormatData(ZafStringData *formatData);
	virtual ZafError SetFormatText(const ZafIChar *format);
	virtual ZafError SetText(const ZafIChar *text);
	virtual bool SetUnanswered(bool unanswered);

	// --- String members ---
	virtual bool SetLowerCase(bool lowerCase);
	ZafError SetOutputFormat(const ZafIChar *format);
	virtual ZafError SetOutputFormatData(ZafStringData *format);
	virtual bool SetPassword(bool password);
	ZafError SetRange(const ZafIChar *range);
	virtual ZafError SetRangeData(ZafStringData *range);
	virtual bool SetUpperCase(bool upperCase);
	virtual bool SetVariableName(bool variableName);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafString::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafString::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSFormattedString;

	// --- General members ---
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Data access ---
	ZafStringData *compressedData;
	ZafStringData *deleteData;
	void DeleteText(ZafEventType ccode);
	void InsertChar(ZafIChar textValue);
	void InsertText(ZafIChar *textValue);
	ZafIChar IsLegalChar(ZafIChar textValue, int offset) const;
	bool IsLiteralChar(ZafIChar textValue) const;
	void MoveCursor(ZafEventType ccode);
	void UpdateCompressedData(void);
	void UpdateExpandedData(void);
	static ZafError UpdateExpanded(ZafFormattedString *fmtString, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) fmtString->UpdateCompressedData();
		  return (ZafString::Update(fmtString, type)); }

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual ZafError OSGetText(void);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetText(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafFormattedString::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

// --- inline functions ---
inline ZafStringData *ZafFormattedString::CompressedData(void) const { return (compressedData); }
inline ZafStringData *ZafFormattedString::DeleteData(void) const { return (deleteData); }
inline ZafStringData *ZafFormattedString::ExpandedData(void) const { return (stringData); }
inline ZafStringData *ZafFormattedString::FormatData(void) const { return (ZafString::inputFormatData); }
inline bool ZafFormattedString::IsLiteralChar(ZafIChar value) const { return (value == 'L'); }

#endif // Z_FMTSTR_HPP

