//	Zinc Application Framework - Z_FILDLG.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_FILDLG_HPP)
#define Z_FILDLG_HPP
#include <z_dlgwin.hpp>
#include <z_cset.hpp>

#if defined(ZAF_MSDOS)
#	include <d_fildlg.hpp>
#endif

// --------------------------------------------------------------------------
// ----- ZafFileDialog ------------------------------------------------------
// --------------------------------------------------------------------------

enum ZafFileDialogRequest
{
	ZAF_FILE_DIALOG_NEW				= 0,
	ZAF_FILE_DIALOG_OPEN		 	= 1,
	ZAF_FILE_DIALOG_SAVEAS			= 2
};

class ZAF_EXPORT ZafFileDialog : public ZafDialogWindow
{
public:
	// --- General members ---
	ZafFileDialog(int left, int top, int width, int height);
	ZafFileDialog(const ZafFileDialog &copy);
	virtual ~ZafFileDialog(void);

	// File Dialog control.
	ZafDialogEvent GetFile(ZafFileDialogRequest request);

	// --- Attributes & data access ---
	// get
	const ZafIChar *Directory(void) const;
	const ZafIChar *File(void) const;
	const ZafIChar *Filter(void) const;
	void FullPath(ZafIChar *pathBuffer, int bufferSize);
	// set
	virtual void SetDirectory(const ZafIChar *directory);
	virtual void SetFile(const ZafIChar *file);
	virtual void SetFilter(const ZafIChar *filter);
								 
	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafDialogWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafDialogWindow::IsA(compareName)); }

protected:
	// --- Special OS members ---
	virtual void OSRegisterObject(void);
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;
	virtual void OSSize(void);

	// --- Language & locale support ---
	static ZafLanguageData *language;
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);

private:
	ZafIChar directory[ZAF_MAXPATHLEN];
	ZafIChar file[ZAF_MAXPATHLEN];
	ZafIChar filter[ZAF_MAXPATHLEN];

#if defined(ZAF_MOTIF)
	ZafFileDialogRequest request;
#elif defined(ZAF_MSDOS)
	int originalDrive;
	int currentDrive;
	ZafIChar originalPath[ZAF_MAXPATHLEN];
	ZafIChar currentPath[ZAF_MAXPATHLEN];
	ZafIChar requestedFile[ZAF_MAXPATHLEN];

	static void Close(void);
	static int DriveError(int drive);
	static int FindFirst(const ZafIChar *pathName, DeviceInfo &info, DeviceClassification classification);
	static int FindNext(DeviceInfo &info);
	static int GetDrive(void);
	static int GetPath(ZafIChar *pathName);
	static void Open(void);
	static int SetDrive(int drive);
	static int SetPath(ZafIChar *pathName);

	void DirectoryUpdate(void);
	void DriveUpdate(void);
	void FileUpdate(void);
#endif
};

// --- inline functions ---
inline const ZafIChar *ZafFileDialog::Directory(void) const { return (directory); }
inline const ZafIChar *ZafFileDialog::File(void) const { return (file); }
inline const ZafIChar *ZafFileDialog::Filter(void) const { return (filter); }

#endif // Z_FILE_DIALOG_HPP

