//	Zinc Application Framework - Z_DSKFIL.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_DSKFIL_HPP)
#define Z_DSKFIL_HPP
#include <z_file.hpp>
#include <z_stdio.hpp>

// --------------------------------------------------------------------------
// ----- ZafDiskFileSystem --------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafDiskFileSystem : public ZafFileSystem
{
public:
	static void AppendFullPath(ZafIChar *fullPath,
		const ZafIChar *pathName = ZAF_NULLP(ZafIChar),
		const ZafIChar *fileName = ZAF_NULLP(ZafIChar),
		const ZafIChar *extension = ZAF_NULLP(ZafIChar));
	static void ChangeExtension(ZafIChar *name, const ZafIChar *newExtension);
	static void MakeFullPath(ZafIChar *tmppath);
	static void StripFullPath(const ZafIChar *fullPath,
		ZafIChar *pathName = ZAF_NULLP(ZafIChar),
		ZafIChar *fileName = ZAF_NULLP(ZafIChar),
		ZafIChar *objectName = ZAF_NULLP(ZafIChar),
		ZafIChar *objectPathName = ZAF_NULLP(ZafIChar));
	static void TempName(ZafIChar *tempname);
	static bool ValidName(const ZafIChar *name, bool create = false);

	ZafDiskFileSystem(void);
	virtual ~ZafDiskFileSystem(void);

	int GetDriveNames(ZafIChar **driveName[]);
	void DeleteDriveNames(ZafIChar *driveName[]);
	int SetDrive(const ZafIChar *driveName);

	// --- Directory Members ---
	virtual int ChDir(const ZafIChar *newPath);
	virtual int FindFirst(ZafFileInfoStruct &fileInfo, const ZafIChar *searchName,
		ZafStringID stringID = ZAF_NULLP(ZafIChar), ZafNumberID numberID = 0);
	virtual int FindNext(ZafFileInfoStruct &fileInfo, const ZafIChar *searchName,
		ZafStringID stringID = ZAF_NULLP(ZafIChar), ZafNumberID numberID = 0);
	virtual int FindClose(ZafFileInfoStruct &fileInfo);
	virtual int GetCWD(ZafIChar *pathName, int pathLength);
	virtual int MkDir(const ZafIChar *pathName,
		ZafStringID stringID = ZAF_NULLP(ZafIChar), ZafNumberID numberID = 0);
	virtual int RmDir(const ZafIChar *pathName, bool deleteContents = false);

	// --- File Members ---
	virtual void Close(ZafFile *file);
	virtual ZafFile *Open(const ZafIChar *fileName, const ZafFileMode mode,
		ZafStringID stringID = ZAF_NULLP(ZafIChar), ZafNumberID numberID = 0);
	virtual int Remove(const ZafIChar *name);
	virtual int Rename(const ZafIChar *oldName, const ZafIChar *newName);
};

// --------------------------------------------------------------------------
// ----- ZafDiskFile --------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafDiskFile : public ZafFile
{
public:
	ZafDiskFile(const ZafIChar *pathName, ZafFileMode mode);
	virtual ~ZafDiskFile(void);

	// --- General members ---
	bool Destroyable(void) const;

	// --- Search functions ---
	virtual ZafOffset Length(void) const;
	virtual int Seek(ZafOffset offset, ZafSeek location);
	virtual ZafOffset Tell(void) const;

	// --- I/O functions ---
	virtual int ReadData(void *buffer, int size);
	virtual int WriteData(const void *buffer, int size);

#if defined(ZAF_MACINTOSH)
	static OSType fileCreator;
	static OSType fileType;
#endif

protected:
	int useCount;

	ZafIChar *pathName;
#	if defined(ZAF_MACINTOSH)
	short file;
#	else
	FILE *file;
#	endif
};

// --- inline functions ---
inline bool ZafDiskFile::Destroyable(void) const { return (useCount ? false : true); }

#endif // ZAF_DSKFIL_HPP
