//	Zinc Application Framework - Z_DEVICE.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_DEVICE_HPP)
#define Z_DEVICE_HPP
#include <z_list.hpp>
#include <z_event.hpp>

// --------------------------------------------------------------------------
// ----- ZafDevice ----------------------------------------------------------
// --------------------------------------------------------------------------

// --- Device type messages ---
const ZafDeviceType E_OSEVENT			= 1;
const ZafDeviceType E_MSWINDOWS			= E_OSEVENT;
const ZafDeviceType E_OS2				= E_OSEVENT;
const ZafDeviceType E_MACINTOSH			= E_OSEVENT;
const ZafDeviceType E_XT				= E_OSEVENT;
const ZafDeviceType E_MOTIF				= E_XT;
const ZafDeviceType E_KEY 				= 10;
const ZafDeviceType E_MOUSE 			= 30;
const ZafDeviceType E_CURSOR			= 50;
const ZafDeviceType E_TIMER				= 70;
const ZafDeviceType E_HELPTIPS			= 71;
const ZafDeviceType E_DEVICE			= 99;

// --- Device image messages ---
typedef ZafDeviceState ZafDeviceImage;

// --- Device state messages ---
const ZafDeviceState D_OFF				= -3000;
const ZafDeviceState D_ON				= -3001;
const ZafDeviceState D_HIDE				= -3002;
const ZafDeviceState D_ACTIVATE			= -3003;
const ZafDeviceState D_DEACTIVATE		= -3004;
const ZafDeviceState D_STATE			= -3005;
const ZafDeviceState D_INITIALIZE		= -3006;
const ZafDeviceState D_DEINITIALIZE		= -3007;
const ZafDeviceState D_POSITION			= -3008;

class ZAF_EXPORT ZafDevice : public ZafElement
{
	friend class ZAF_EXPORT ZafEventManager;

public:
	enum ZafAltState
	{
		ZAF_ALT_NOT_PRESSED,
		ZAF_ALT_PRESSED_NO_EVENTS,
		ZAF_ALT_PRESSED_EVENTS
	};
	static ZafDisplay *display;
	static ZafEventManager *eventManager;

	// --- General members ---
	ZafDevice(ZafDeviceType type, ZafDeviceState state);
	virtual ~ZafDevice(void);
	virtual ZafEventType Event(const ZafEventStruct &event) = 0;
	virtual void Poll(void) = 0;

	// --- Attributes & data access ---
	// get
	ZafDeviceState DeviceState(void) const;
	ZafDeviceType DeviceType(void) const;
	bool Installed(void) const;
	// set
	virtual ZafDeviceState SetDeviceState(ZafDeviceState deviceState);

	// --- Element members ---
	ZafDevice *Next(void) const { return ((ZafDevice *)next); }
	ZafDevice *Previous(void) const { return ((ZafDevice *)previous); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafElement::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafElement::IsA(compareName)); }

protected:
	static ZafAltState altState;

	bool installed;
	ZafDeviceType deviceType;
	ZafDeviceState deviceState;

	static int CompareDevices(void *device1, void *device2);
};

// --- inline functions ---
inline ZafDeviceState ZafDevice::DeviceState(void) const { return deviceState; }
inline ZafDeviceType ZafDevice::DeviceType(void) const { return deviceType; }
inline bool ZafDevice::Installed(void) const { return installed; }

#endif // Z_DEVICE_HPP

