//	Zinc Application Framework - Z_CURSOR.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_CURSOR_HPP)
#define Z_CURSOR_HPP
#include <z_bitmap.hpp>
#include <z_device.hpp>

// --------------------------------------------------------------------------
// ----- ZafCursor ----------------------------------------------------------
// --------------------------------------------------------------------------

// --- Cursor image messages ---
const ZafDeviceImage DC_CURSOR_LAST			= -3100;
const ZafDeviceImage DC_INSERT				= -3100;
const ZafDeviceImage DC_OVERSTRIKE			= -3101;
const ZafDeviceImage DC_CURSOR_FIRST		= -3199;

const int ZAF_MAXCURSORIMAGES				= 8;

class ZAF_EXPORT ZafCursor : public ZafDevice
{
public:
	// --- General members ---
	ZafCursor(ZafDeviceState state = D_ON, ZafDeviceImage imageType = DC_INSERT);
	virtual ~ZafCursor(void);
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual void Poll(void);

	// --- Attributes & data access ---
	// get
	static int BlinkRate(void);
	ZafDeviceImage ImageType(void) const;
	// set
	static int SetBlinkRate(int blinkRate);
	virtual ZafDeviceImage SetImageType(ZafDeviceImage imageType);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafDevice::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafDevice::IsA(compareName)); }

protected:
	static int blinkRate;
	ZafPositionStruct offset;
	ZafDeviceImage imageType;
	ZafPositionStruct position;

	// --- Image support ---
	static ZafBitmapData *imageTable[ZAF_MAXCURSORIMAGES];
	static void ImageAllocate(void);
	static void ImageFree(bool globalRequest = false);

private:
	ZafCursor(const ZafCursor &copy);
};

// --- inline functions ---
inline int ZafCursor::BlinkRate(void) { return blinkRate; }
inline ZafDeviceImage ZafCursor::ImageType(void) const { return imageType; }

#endif // Z_CURSOR_HPP

