//	Zinc Application Framework - Z_CTYPE.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_CTYPE_HPP)
#define Z_CTYPE_HPP
#include <z_env.hpp>

#if defined(ZAF_ISO8859_1)
	// Support for international ISO helper functions.
	int IsNonspacing(ZafIChar value);

	// Support for international Ctype functions.
	ZAF_EXPORT int IsAlnum(ZafIChar value);
	ZAF_EXPORT int IsAlpha(ZafIChar value);
	ZAF_EXPORT int IsAscii(ZafIChar value);
	ZAF_EXPORT int IsCntrl(ZafIChar value);
	ZAF_EXPORT int IsDigit(ZafIChar value);
	ZAF_EXPORT int IsGraph(ZafIChar value);
	ZAF_EXPORT int IsLower(ZafIChar value);
	ZAF_EXPORT int IsPrint(ZafIChar value);
	ZAF_EXPORT int IsPunct(ZafIChar value);
	ZAF_EXPORT int IsSpace(ZafIChar value);
	ZAF_EXPORT int IsUpper(ZafIChar value);
	ZAF_EXPORT int IsXDigit(ZafIChar value);
	ZAF_EXPORT ZafIChar ToLower(ZafIChar value);
	ZAF_EXPORT ZafIChar ToUpper(ZafIChar value);

#	if defined(isalnum)
#		undef isalnum
#	endif
#	if defined(isalpha)
#		undef isalpha
#	endif
#	if defined(iscntrl)
#		undef iscntrl
#	endif
#	if defined(isdigit)
#		undef isdigit
#	endif
#	if defined(isgraph)
#		undef isgraph
#	endif
#	if defined(islower)
#		undef islower
#	endif
#	if defined(isprint)
#		undef isprint
#	endif
#	if defined(ispunct)
#		undef ispunct
#	endif
#	if defined(isspace)
#		undef isspace
#	endif
#	if defined(isupper)
#		undef isupper
#	endif
#	if defined(isxdigit)
#		undef isxdigit
#	endif
#	if defined(isascii)
#		undef isascii
#	endif
#	if defined(toascii)
#		undef toascii
#	endif
#	if defined(_toupper)
#		undef _toupper
#	endif
#	if defined(_tolower)
#		undef _tolower
#	endif
#	if defined(toupper)
#		undef toupper
#	endif
#	if defined(tolower)
#		undef tolower
#	endif

#	define isalnum(c)	IsAlnum(c)
#	define isalpha(c)	IsAlpha(c)
#	define iscntrl(c)	IsCntrl(c)
#	define isdigit(c)	IsDigit(c)
#	define isgraph(c)	IsGraph(c)
#	define islower(c)	IsLower(c)
#	define isprint(c)	IsPrint(c)
#	define ispunct(c)	IsPunct(c)
#	define isspace(c)	IsSpace(c)
#	define isupper(c)	IsUpper(c)
#	define isxdigit(c)	IsXDigit(c)
#	define isascii(c)	IsAscii(c)
#	define toascii(c)	ToAscii(c)
#	define _toupper(c)	ToUpper(c)
#	define _tolower(c)	ToLower(c)
#	define toupper(c)	ToUpper(c)
#	define tolower(c)	ToLower(c)
#elif defined(ZAF_UNICODE)
	// Support for international Unicode/ISO helper functions.
	int chartod(const ZafIChar value);
	int IsNonspacing(ZafIChar value);

	// Support for international Ctype functions.
	ZAF_EXPORT int IsAlnum(ZafIChar value);
	ZAF_EXPORT int IsAlpha(ZafIChar value);
	ZAF_EXPORT int IsAscii(ZafIChar value);
	ZAF_EXPORT int IsCntrl(ZafIChar value);
	ZAF_EXPORT int IsDigit(ZafIChar value);
	ZAF_EXPORT int IsGraph(ZafIChar value);
	ZAF_EXPORT int IsLower(ZafIChar value);
	ZAF_EXPORT int IsPrint(ZafIChar value);
	ZAF_EXPORT int IsPunct(ZafIChar value);
	ZAF_EXPORT int IsSpace(ZafIChar value);
	ZAF_EXPORT int IsUpper(ZafIChar value);
	ZAF_EXPORT int IsXDigit(ZafIChar value);
	ZAF_EXPORT ZafIChar ToLower(ZafIChar value);
	ZAF_EXPORT ZafIChar ToUpper(ZafIChar value);

#	if defined(isalnum)
#		undef isalnum
#	endif
#	if defined(isalpha)
#		undef isalpha
#	endif
#	if defined(iscntrl)
#		undef iscntrl
#	endif
#	if defined(isdigit)
#		undef isdigit
#	endif
#	if defined(isgraph)
#		undef isgraph
#	endif
#	if defined(islower)
#		undef islower
#	endif
#	if defined(isprint)
#		undef isprint
#	endif
#	if defined(ispunct)
#		undef ispunct
#	endif
#	if defined(isspace)
#		undef isspace
#	endif
#	if defined(isupper)
#		undef isupper
#	endif
#	if defined(isxdigit)
#		undef isxdigit
#	endif
#	if defined(isascii)
#		undef isascii
#	endif
#	if defined(toascii)
#		undef toascii
#	endif
#	if defined(_toupper)
#		undef _toupper
#	endif
#	if defined(_tolower)
#		undef _tolower
#	endif
#	if defined(toupper)
#		undef toupper
#	endif
#	if defined(tolower)
#		undef tolower
#	endif

#	define isalnum(c)	IsAlnum(c)
#	define isalpha(c)	IsAlpha(c)
#	define iscntrl(c)	IsCntrl(c)
#	define isdigit(c)	IsDigit(c)
#	define isgraph(c)	IsGraph(c)
#	define islower(c)	IsLower(c)
#	define isprint(c)	IsPrint(c)
#	define ispunct(c)	IsPunct(c)
#	define isspace(c)	IsSpace(c)
#	define isupper(c)	IsUpper(c)
#	define isxdigit(c)	IsXDigit(c)
#	define isascii(c)	IsAscii(c)
#	define toascii(c)	ToAscii(c)
#	define _toupper(c)	ToUpper(c)
#	define _tolower(c)	ToLower(c)
#	define toupper(c)	ToUpper(c)
#	define tolower(c)	ToLower(c)
#else
#	include <ctype.h>
#	define IsAlnum(c)	isalnum(c)
#	define IsAlpha(c)	isalpha(c)
#	define IsCntrl(c)	iscntrl(c)
#	define IsDigit(c)	isdigit(c)
#	define IsGraph(c)	isgraph(c)
#	define IsLower(c)	islower(c)
#	define IsPrint(c)	isprint(c)
#	define IsPunct(c)	ispunct(c)
#	define IsSpace(c)	isspace(c)
#	define IsUpper(c)	isupper(c)
#	define IsXDigit(c)	isxdigit(c)
#	define IsAscii(c)	isascii(c)
#	define ToAscii(c)	toascii(c)
#	if defined(_toupper)
#		define ToUpper(c)	_toupper(c)
#		define ToLower(c)	_tolower(c)
#	else
#		define ToUpper(c)	toupper(c)
#		define ToLower(c)	tolower(c)
#	endif
#endif

#endif
