//	Zinc Application Framework - Z_COORD.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_COORD_HPP)
#define Z_COORD_HPP
#include <z_env.hpp>

enum ZafCoordinateType
{
	ZAF_CELL		= 0,
	ZAF_MINICELL 	= 1,
	ZAF_PIXEL 		= 2,
	ZAF_POINTS		= 3,
	ZAF_TWIPS 		= 4
};

struct ZAF_EXPORT ZafCoordinateStruct
{
	// Coordinate conversion values.
	static int cellWidth;
	static int cellHeight;
	static long miniNumeratorX;
	static long miniDenominatorX;
	static long miniNumeratorY;
	static long miniDenominatorY;
	static long pixelsPerInchX;
	static long pixelsPerInchY;

	// --- Member Data ---
	ZafCoordinateType coordinateType;

	// --- Coordinate Conversion Functions ---
	long ConvertXValue(long value, ZafCoordinateType typeIn, ZafCoordinateType typeOut);
	long ConvertYValue(long value, ZafCoordinateType typeIn, ZafCoordinateType typeOut);
};

#endif // Z_COORD_HPP
