//	Zinc Application Framework - Z_COMBO.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_COMBO_HPP)
#define Z_COMBO_HPP
#include <z_vlist.hpp>

// --------------------------------------------------------------------------
// ----- ZafComboBox --------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafComboBox : public ZafWindow
{
public:
	// --- General members ---
	ZafVtList *list;

	ZafComboBox(int left, int top, int width, int height);
	ZafComboBox(const ZafComboBox &copy);
	virtual ~ZafComboBox(void);

	// --- Persistent members ---
	ZafComboBox(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	bool AutoSortData(void) const;
	bool ViewOnly(void) const;
	// set
	virtual bool SetAutoSortData(bool autoSortData);
	virtual bool SetViewOnly(bool viewOnly);

	// --- Window members ---
	virtual void BroadcastEvent(const ZafEventStruct &event);
	virtual ZafWindowObject *GetObject(ZafNumberID numberID);
	virtual ZafWindowObject *GetObject(const ZafIChar *stringID);
	virtual bool SetDestroyable(bool destroyable);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetLocked(bool locked);
	virtual bool SetMaximized(bool maximized);
	virtual bool SetMinimized(bool minimized);
	virtual bool SetMoveable(bool moveable);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual ZafSelectionType SetSelectionType(ZafSelectionType selectionType);
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	ZafLogicalEvent LogicalEvent(const ZafEventStruct &event);
	virtual ZafWindowObject *FocusObject(void) const;
	virtual bool SetAutomaticUpdate(bool automaticUpdate);
	virtual ZafLogicalColor SetBackgroundColor(ZafLogicalColor color, ZafLogicalColor mono = ZAF_MONO_NULL);
	virtual bool SetBordered(bool bordered);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual const ZafIChar *SetHelpObjectTip(const ZafIChar *helpObjectTip);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetFocus(bool currentFocus);
	virtual ZafLogicalFont SetFont(ZafLogicalFont font);
	virtual bool SetOSDraw(bool osDraw);
	virtual const ZafIChar *SetQuickTip(const ZafIChar *quickTip);
	virtual ZafError SetText(const ZafIChar *text);
	virtual ZafLogicalColor SetTextColor(ZafLogicalColor color, ZafLogicalColor mono = ZAF_MONO_NULL);
	virtual bool SetVisible(bool visible);
	virtual const ZafIChar *Text(void);

	// --- List members ---
	virtual ZafWindowObject *Add(ZafWindowObject *object, ZafWindowObject *position = ZAF_NULLP(ZafWindowObject));
	virtual ZafCompareFunction CompareFunction(void) const;
	int Count(void) { return (list->Count()); }
	ZafWindowObject *Current(void) const { return ((ZafWindowObject *)list->Current()); }
	virtual void Destroy(void);
	ZafWindowObject *First(void) const { return (list->First()); }
	ZafWindowObject *Get(int index) { return ((ZafWindowObject *)list->ZafList::Get(index)); }
	int Index(ZafWindowObject const *element) { return (list->Index(element)); }
	ZafWindowObject *Last(void) const { return(list->Last()); }
	virtual ZafCompareFunction SetCompareFunction(ZafCompareFunction compareFunction);
	virtual void Sort(void);
	virtual ZafWindowObject *Subtract(ZafWindowObject *object);
	ZafWindowObject *SupportFirst(void) const { return(list->SupportFirst()); }
	ZafWindowObject *SupportLast(void) const { return(list->SupportLast()); }

	ZafComboBox &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafComboBox &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const
		{ return ((compareID == classID || compareID == ID_ZAF_LIST) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const
		{ return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

	// --- Special OS members ---
	virtual OSWindowID OSScreenID(ZafScreenIDType type = ZAF_SCREENID) const;
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);

protected:
	friend class ZAF_EXPORT OSComboBox;

	// --- General members ---
	bool viewOnly;

	ZafWindowObject *ComboCurrent(void) const { return ((ZafWindowObject *)current); }
	ZafWindowObject *ComboFirst(void) const { return ((ZafWindowObject *)first); }
	ZafWindowObject *ComboLast(void) const { return ((ZafWindowObject *)last); }

	virtual ZafRegionStruct ConvertToDrawRegion(const ZafWindowObject *object,
		const ZafRegionStruct *zafRegion = ZAF_NULLP(ZafRegionStruct)) const;
	virtual ZafEventType DragDropEvent(const ZafEventStruct &event);
	virtual ZafEventType DrawBorder(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafEventType DrawFocus(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual void GetClip(ZafWindowObject *object, ZafRegionStruct &clip, ZafRegionStruct &virtualRegion);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);
	ZafWindowObject *MatchInput(ZafIChar matchValue);
	virtual ZafWindowObject *NotifyFocus(ZafWindowObject *object, bool focus);
	virtual ZafWindowObject *NotifySelection(ZafWindowObject *object, bool selected);
	virtual ZafEventType ScrollEvent(const ZafEventStruct &event) { return (list->ScrollEvent(event)); }

	// --- Special OS members ---
	virtual void OSDestroy(void);
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual ZafError OSGetText(void);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetText(void);
	virtual void OSSize(void);
	virtual void OSSort(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafComboBox::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
	static ZafEventMap ZAF_FARDATA defaultEventMap[];

#	if defined(ZAF_MOTIF)
	ZafRegionStruct selectRegion;
	ZafWindowObject *comboItem;
	void DrawArrow(bool depressed);
#	elif defined(ZAF_MSDOS) || defined(ZAF_CURSES)
	ZafWindowObject *comboString, *comboButton;
#	elif defined(ZAF_MACINTOSH)
	ZafWindowObject *comboString;
#	endif
};

// --- inline functions ---
inline bool ZafComboBox::AutoSortData(void) const { return list->AutoSortData(); }
inline ZafCompareFunction ZafComboBox::CompareFunction(void) const { return list->CompareFunction(); }
inline bool ZafComboBox::ViewOnly(void) const { return viewOnly; }

#endif // Z_COMBO_HPP

