//	Zinc Application Framework - Z_BNUM1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_BNUM1_HPP)
#define Z_BNUM1_HPP
#include <z_bnum.hpp>
#include <z_str1.hpp>

// --------------------------------------------------------------------------
// ----- ZafBignum ----------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafBignum : public ZafString
{
public:
	// --- General members ---
	ZafBignum(int left, int top, int width,
		ZafBignumData *bignumData = ZAF_NULLP(ZafBignumData));
	ZafBignum(int left, int top, int width, long value);
	ZafBignum(int left, int top, int width, double value);
	ZafBignum(const ZafBignum &copy);
	virtual ~ZafBignum(void);

	// --- Persist members ---
	ZafBignum(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafBignumData *BignumData(void) const;
	// set
	virtual ZafError SetBignumData(ZafBignumData *bignumData);

	// --- String members ---
	virtual bool SetLowerCase(bool lowerCase);
	virtual bool SetPassword(bool password);
	virtual ZafError SetStringData(ZafStringData *string);
	virtual bool SetUpperCase(bool upperCase);
	virtual bool SetVariableName(bool variableName);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafError SetText(const ZafIChar *text);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafString::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafString::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSBignum;

	// --- General members ---
	virtual ZafWindowObject *Duplicate(void);

	// --- Data access ---
	ZafBignumData *bignumData;
	virtual ZafError Decrement(ZafData *data);
	virtual ZafError Increment(ZafData *data);
	static ZafError Update(ZafBignum *bignum, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return bignum->OSSetBignum();
		  else if (type == ZAF_UPDATE_DATA) return bignum->OSGetBignum();
		  else return (ZAF_ERROR_INVALID); }
	virtual ZafError Validate(bool processError = true);

	// --- Persist members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafBignum::Read); }
	void WriteData(ZafObjectPersistence &persist);

	// --- Special OS members ---
	ZafError OSGetBignum(void);
	ZafError OSSetBignum(void);

	// --- Language & locale support ---
	static ZafLanguageData *errorStrings;
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);
};

// --- inline functions ---
inline ZafBignumData *ZafBignum::BignumData(void) const { return bignumData; }
inline ZafError ZafBignum::SetText(const ZafIChar *text) { return (bignumData->SetBignum(text, inputFormatData ? inputFormatData->Text() : ZAF_NULLP(ZafIChar))); }

#endif // Z_BNUM1_HPP

