//	Zinc Application Framework - Z_BITMAP.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_BITMAP_HPP)
#define Z_BITMAP_HPP
#include <z_idata.hpp>

// --------------------------------------------------------------------------
// ----- ZafBitmapData ------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafBitmapData : public ZafImageData, public ZafBitmapStruct
{
public:
	// --- General members ---
	ZafBitmapData(const ZafImageStruct &data);
	ZafBitmapData(const ZafBitmapStruct &data);
	ZafBitmapData(const ZafBitmapData &copy);
	virtual ~ZafBitmapData(void);

	// --- Persist members ---
	ZafBitmapData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafLogicalColor *Array(void) const;
	int Height(void) const;
	int Width(void) const;
	// set
	virtual void Clear(void);
	virtual ZafError SetBitmap(int width, int height, ZafLogicalColor *array);
	virtual ZafError SetBitmap(const ZafBitmapStruct &bitmap);

	// --- Operators ---
	ZafBitmapData &operator=(const ZafBitmapData &bitmap);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafData::IsA(compareName)); }

protected:
	// --- Persist members ---
	void ReadData(ZafDataPersistence &persist);
	virtual ZafDataConstructor ReadFunction(void) { return (ZafBitmapData::Read); }
	void WriteData(ZafDataPersistence &persist);

	virtual ZafData *Duplicate(void);
};

// --- inline functions ---
inline ZafLogicalColor *ZafBitmapData::Array(void) const { return (array); }
inline int ZafBitmapData::Height(void) const { return (height); }
inline int ZafBitmapData::Width(void) const { return (width); }
inline ZafBitmapData &ZafBitmapData::operator=(const ZafBitmapData &bitmap) { SetBitmap(bitmap); return *this; }

#endif // Z_BITMAP_HPP

