//	Zinc Application Framework - Z_APP.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_APP_HPP)
#define Z_APP_HPP
#include <z_env.hpp>

// --------------------------------------------------------------------------
// ----- ZafApplication -----------------------------------------------------
// --------------------------------------------------------------------------

typedef void (*ZafStaticModule)(bool);

class ZafApplication
{
public:
	// --- General members ---
	int argc;
	ZafIChar **argv;

	ZAF_EXPORT ZafApplication(int argc, char **argv);
	ZAF_EXPORT ~ZafApplication(void);

	ZAF_EXPORT static bool AddStaticModule(ZafStaticModule module);
	ZAF_EXPORT ZafEventType Control(void);
	void LinkMain(void);
	int Main(void);
	ZAF_EXPORT static bool SubtractStaticModule(ZafStaticModule module);

private:
	static ZafStaticModule *staticModule;
};

#endif // Z_APP_HPP

