# Zinc Application Framework - ZAFBOR.MAK
# COPYRIGHT (C) 1990-1997.  All Rights Reserved.
# Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#############################################################################
#
# "zafbor.mak" is the second in a series of three make files used to easily
# build ZAF projects from the command prompt -- it should not be invoked
# directly.  This file is also used when building the ZAF libraries.
#
# The three files used to build ZAF projects are:
# 1. makefile.mak - User supplied make file (see example below)
# 2. zafbor.mak   - The main ZAF make file unique to each compiler
# 3. optsbor.mak  - Compiler options and tools shared by ZAF and apps
#
# Your main make file should take the following form (example only):
#
# --- makefile.mak ----------------------------------------------------------
# # Define macros used by main make file
# ZAF_ROOT = c:\zaf500
# PLATFORM = WIN32
# TARGET_TYPE = EXEDLL
# TARGET = myapp.exe
# SOURCE_FILES = myapp1.cpp myapp2.cpp
# DEFINITION_FILE = myapp.def
# RESOURCE_FILE = bitmaps.rc
# DEBUG = off
#
# # Chain to main make file
# !include "$(ZAF_ROOT)\include\zafbor.mak"
# ---------------------------------------------------------------------------
#
# Macro options and descriptions:
#
# ZAF_ROOT        - Root directory of the ZAF installation
#
# PLATFORM        - Target platform supported by this make file
#      options:   WIN32     - 32 bit windows
#                 WIN16     - 16 bit windows
#
# TARGET_TYPE     - The type target to be built
#      options:   EXE       - Executable file statically linked with ZAF
#                 EXEDLL    - Executable file dynamically linked with ZAF
#                 LIB       - Library file
#                 LIBDLL    - Library that calls functions in a ZAF DLL
#                 DLL       - Dynamically linked library file
#
# TARGET          - Name of the target file
#
# SOURCE_FILES    - Source files needed to build the target
#
# IMPORT_LIBRARY (DLLs only)
#                 - Name of import library used with DLL
#
# PERSISTENCE (optional)
#                 - Persistance jump table control.
#      options:   none      - No objects in jump table (default)
#                 all       - All objects in jump table
#                 user      - Jump table provided by user
#
# ADD_OBJECT_FILES (optional)
#                 - Additional object files, if any
#
# ADD_LIBRARIES (optional)
#                 - Additional libraries, if any
#
# DEFINITION_FILE (optional)
#                 - Windows definition file, if any
#
# RESOURCE_FILE (optional)
#                 - Windows Resource file, if any
#
# DEBUG (optional)
#                 - Build with debug information
#      options:   off       - No debug information (default)
#                 on        - Debug information included
#
#############################################################################


#
# Make sure all of the necessary macros are defined.
#
!if !$d(ZAF_ROOT)
!error "ZAF_ROOT" not defined.
!elif !$d(TARGET)
!error "TARGET" not defined.
!elif !$d(TARGET_TYPE)
!error "TARGET_TYPE" not defined.
!elif !$d(PLATFORM)
!error "PLATFORM" not defined.
!elif !$d(SOURCE_FILES)
!error "SOURCE_FILES" not defined.
!endif
!if !$d(ADD_LIBRARIES)
ADD_LIBRARIES=
!endif
!if !$d(ADD_OBJECT_FILES)
ADD_OBJECT_FILES=
!endif
!if !$d(DEFINITION_FILE)
DEFINITION_FILE=
!endif
!if !$d(RESOURCE_FILE)
RESOURCE_FILE=
!endif

#
# Include the borland compiler options.
#
!ifndef OPTSBOR_MAK
OPTSBOR_MAK=
!include "$(ZAF_ROOT)\include\optsbor.mak"
!endif

#
# Debug additions.
#
!if $(DEBUG) == on
DEBUG_COMPILE_OPTIONS=$(DEBUG_COMPILE_OPTIONS_ON)
DEBUG_LINK_OPTIONS=$(DEBUG_LINK_OPTIONS_ON)
DEBUG_LIBRARY_OPTIONS=$(DEBUG_LIBRARY_OPTIONS_ON)
!else
DEBUG_COMPILE_OPTIONS=$(DEBUG_COMPILE_OPTIONS_OFF)
DEBUG_LINK_OPTIONS=$(DEBUG_LINK_OPTIONS_OFF)
DEBUG_LIBRARY_OPTIONS=$(DEBUG_LIBRARY_OPTIONS_OFF)
!endif


#
# Define the rule macros.
#
!if $(PLATFORM) == WIN16

#
# Windows 16 bit macros.
#
!if $(TARGET_TYPE) == EXE || $(TARGET_TYPE) == LIB
OBJECT_FILE_EXTENSION=.ob1
COMPILER=$(W16_COMPILER)
COMPILE_OPTIONS=$(W16_COMPILE_OPTIONS) $(DEBUG_COMPILE_OPTIONS)
LINKER=$(W16_LINKER)
LINK_OPTIONS=$(W16_LINK_OPTIONS) $(DEBUG_LINK_OPTIONS)
LIBRARIAN=$(W16_LIBRARIAN)
LIBRARY_OPTIONS=$(W16_LIBRARY_OPTIONS) $(DEBUG_LIBRARY_OPTIONS)
RESOURCE_COMPILER=$(W16_RESOURCE_COMPILER)
RESOURCE_COMPILE_OPTIONS=$(W16_RESOURCE_OPTIONS)
OBJECT_FILES=$(W16_OBJECT_FILES) $(ADD_OBJECT_FILES)
LIBRARIES=$(W16_LIBRARIES) $(ADD_LIBRARIES)
!if !$d(PERSISTENCE) || $(PERSISTENCE) == none
LIBRARIES=$(LIBRARIES) $(PERSIST_LIBRARY_NONE_16)
!elif $(PERSISTENCE) == all
LIBRARIES=$(LIBRARIES) $(PERSIST_LIBRARY_ALL_16)
!endif

#
# Invalid target type.
#
!else
!error Invalid target type: $(TARGET_TYPE)
!endif

!elif $(PLATFORM) == WIN32
#
# Windows 32 bit macros (statically linked executable or library)
#
!if $(TARGET_TYPE) == EXE || $(TARGET_TYPE) == LIB
OBJECT_FILE_EXTENSION=.obw
COMPILER=$(W32_COMPILER)
COMPILE_OPTIONS=$(W32_COMPILE_OPTIONS) $(DEBUG_COMPILE_OPTIONS)
LINKER=$(W32_LINKER)
LINK_OPTIONS=$(W32_LINK_OPTIONS) $(DEBUG_LINK_OPTIONS)
LIBRARIAN=$(W32_LIBRARIAN)
LIBRARY_OPTIONS=$(W32_LIBRARY_OPTIONS) $(DEBUG_LIBRARY_OPTIONS)
RESOURCE_COMPILER=$(W32_RESOURCE_COMPILER)
RESOURCE_COMPILE_OPTIONS=$(W32_RESOURCE_OPTIONS)
OBJECT_FILES=$(W32_OBJECT_FILES) $(ADD_OBJECT_FILES)
LIBRARIES=$(W32_LIBRARIES) $(ADD_LIBRARIES)
!if !$d(PERSISTENCE) || $(PERSISTENCE) == none
LIBRARIES=$(LIBRARIES) $(PERSIST_LIBRARY_NONE_32)
!elif $(PERSISTENCE) == all
LIBRARIES=$(LIBRARIES) $(PERSIST_LIBRARY_ALL_32)
!endif

#
# Windows 32 bit macros (dynamically linked executable or library)
#
!elif $(TARGET_TYPE) == EXEDLL || $(TARGET_TYPE) == LIBDLL
OBJECT_FILE_EXTENSION=.obi
COMPILER=$(W32_COMPILER)
COMPILE_OPTIONS=$(W32_DLL_IMPORT_COMPILE_OPTIONS) $(DEBUG_COMPILE_OPTIONS)
LINKER=$(W32_LINKER)
LINK_OPTIONS=$(W32_LINK_OPTIONS) $(DEBUG_LINK_OPTIONS)
LIBRARIAN=$(W32_LIBRARIAN)
LIBRARY_OPTIONS=$(W32_LIBRARY_OPTIONS) $(DEBUG_LIBRARY_OPTIONS)
RESOURCE_COMPILER=$(W32_RESOURCE_COMPILER)
RESOURCE_COMPILE_OPTIONS=$(W32_RESOURCE_OPTIONS)
OBJECT_FILES=$(W32_DLL_IMPORT_OBJECT_FILES) $(ADD_OBJECT_FILES)
LIBRARIES=$(W32_DLL_IMPORT_LIBRARIES) $(ADD_LIBRARIES)

#
# Windows 32 bit DLL macros.
#
!elif $(TARGET_TYPE) == DLL
OBJECT_FILE_EXTENSION=.obx
COMPILER=$(W32_COMPILER)
COMPILE_OPTIONS=$(W32_DLL_EXPORT_COMPILE_OPTIONS) $(DEBUG_COMPILE_OPTIONS)
LINKER=$(W32_LINKER)
LINK_OPTIONS=$(W32_DLL_LINK_OPTIONS) $(DEBUG_LINK_OPTIONS)
LIBRARIAN=$(W32_LIBRARIAN)
LIBRARY_OPTIONS=$(W32_LIBRARY_OPTIONS) $(DEBUG_LIBRARY_OPTIONS)
RESOURCE_COMPILER=$(W32_RESOURCE_COMPILER)
RESOURCE_COMPILE_OPTIONS=$(W32_RESOURCE_OPTIONS)
OBJECT_FILES=$(W32_DLL_EXPORT_OBJECT_FILES) $(ADD_OBJECT_FILES)
LIBRARIES=$(W32_DLL_EXPORT_LIBRARIES) $(ADD_LIBRARIES)

#
# Invalid target type.
#
!else
!error Invalid target type: $(TARGET_TYPE)
!endif

#
# Invalid platform
#
!else
!error Invalid platform: $(PLATFORM)
!endif


DEPENDENT_OBJECT_FILES_LINK=$(SOURCE_FILES:.cpp=$(OBJECT_FILE_EXTENSION))
DEPENDENT_OBJECT_FILES_LIB=$(DEPENDENT_OBJECT_FILES_LINK: =+)

#
# Explicit rule for building executables.
#
!if $(TARGET_TYPE) == EXE || $(TARGET_TYPE) == EXEDLL
$(TARGET): $(DEPENDENT_OBJECT_FILES_LINK)
	$(LINKER) $(LINK_OPTIONS) @&&|
$(OBJECT_FILES)+$(DEPENDENT_OBJECT_FILES_LINK)
$*, , $(LIBRARIES), $(DEFINITION_FILE)
|
!endif

#
# Explicit rule for building DLL's.
#
!if $(TARGET_TYPE) == DLL
$(TARGET): $(DEPENDENT_OBJECT_FILES_LINK)
	$(LINKER) $(LINK_OPTIONS) @&&|
$(OBJECT_FILES)+$(DEPENDENT_OBJECT_FILES_LINK)
$*, , $(LIBRARIES), $(DEFINITION_FILE)
|
	-@del $(IMPORT_LIBRARY)
	implib $(IMPORT_LIBRARY) $(TARGET)
!endif

#
# Explicit rule for building libraries.
#
!if $(TARGET_TYPE) == LIB || $(TARGET_TYPE) == LIBDLL
$(TARGET): $(DEPENDENT_OBJECT_FILES_LINK)
	-@del $(TARGET)
	$(LIBRARIAN) $(LIBRARY_OPTIONS) $(TARGET) @&&|
+$(DEPENDENT_OBJECT_FILES_LIB)
|
!endif

