.EXTENSIONS:
.EXTENSIONS: .o32 .obw .ob1 .obo .obm .obx .obi .o .cpp .c

!ifeq DEBUG on
DEBUG_CPP_OPTS = -d2
DEBUG_LINK_OPTS = d all
!else
DEBUG_CPP_OPTS = 
DEBUG_LINK_OPTS = 
!endif


COMMON_CPP_OPTS = /zq $(DEBUG_CPP_OPTS)
COMMON_LINK_OPTS = $(DEBUG_LINK_OPTS)

# ----- DOS 32 bit (DOS4GW extender) compiler options -----------------------
D32_CPP=wpp386
D32_LINK=wlink
D32_LIBRARIAN=wlib

D32_CPP_OPTS=/bt=dos /dDOS386 
D32_LINK_OPTS=SYSTEM dos4g OP stack=20000 DISA 1124
D32_LIB_OPTS=-p=64 -q

# --- Use the next line for Meta Graphics ---
D32_OBJS=
D32_LIBS=d32_zaf,met_xr3l

.cpp.o32:
	$(D32_CPP) $(D32_CPP_OPTS) -fo=$[*.o32 $<

# ----- 16 bit Windows compiler options -------------------------------------
WIN_CPP=wpp
WIN_LINK=wlink
WIN_LIBRARIAN=wlib
WIN_RC=wrc

WIN_CPP_OPTS= -zw -zc -w1 -ml -bt=windows -zt4 $(COMMON_CPP_OPTS)
WIN_RC_OPTS=/bt=windows
WIN_LINK_OPTS=SYS windows OP heapsize=16k OP stack=24k $(COMMON_LINK_OPTS)
WIN_LIB_OPTS=/p=64

WIN_OBJS=
WIN_LIBS=windows,zafw16,zafw16n

.cpp.ob1:
	$(WIN_CPP) $(WIN_CPP_OPTS) -fo=$[*.ob1 $<

# ----- 32 bit Windows compiler options -------------------------------------
W32_CPP=wpp386
W32_LINK=wlink
W32_LIBRARIAN=wlib
W32_RC=wrc

W32_CPP_OPTS=/bt=nt -DWIN32 -mf -xr $(COMMON_CPP_OPTS)
W32_RC_OPTS=/bt=nt
W32_LINK_OPTS=SYS nt_win libpath . $(COMMON_LINK_OPTS)
W32_LIB_OPTS=/p=128

W32_OBJS=
W32_LIBS=nt,zafw32,comctl32,zafw32n

.cpp.obw:
	$(W32_CPP) $(W32_CPP_OPTS) -fo=$[*.obw $<

# ----- 32 bit Windows DLL compiler options ---------------------------------

W32_DLL_EXPORT_CPP_OPTS=/bt=nt_dll -DWIN32 -mf -bd -DZAF_DLL_EXPORT -xr $(COMMON_CPP_OPTS)
W32_DLL_EXPORT_LINK_OPTS=SYS nt_dll $(COMMON_LINK_OPTS)
W32_DLL_EXPORT_LIBS=comctl32,nt,kernel32,user32,gdi32,comdlg32

W32_DLL_IMPORT_CPP_OPTS=/bt=nt -DWIN32 -mf -DZAF_DLL_IMPORT -xr $(COMMON_CPP_OPTS)
W32_DLL_IMPORT_LINK_OPTS=SYS nt_win libpath . $(COMMON_LINK_OPTS)
W32_DLL_IMPORT_LIBS=nt,zafw32nd,comctl32,zafw32i,kernel32,user32,zafw32d

.cpp.obx:
	$(W32_CPP) $(W32_DLL_EXPORT_CPP_OPTS) -fo=$[*.obx $<
.cpp.obi:
	$(W32_CPP) $(W32_DLL_IMPORT_CPP_OPTS) -fo=$[*.obi $<

# ----- OS/2 compiler options -----------------------------------------------
OS2_CPP=wpp386
OS2_LINK=wlink
OS2_LIBRARIAN=wlib
OS2_RC=rc

OS2_CPP_OPTS=/bt=OS2 
OS2_LINK_OPTS=SYSTEM os2v2_pm OP ST=96000
OS2_LIB_OPTS=/p=64
OS2_RC_OPTS=

OS2_OBJS=
OS2_LIBS=os2_zaf,os2386

.cpp.obo:
	$(OS2_CPP) $(OS2_CPP_OPTS) -fo=$[*.obo $<

# ----- QNX Motif compiler options ------------------------------------------
QNX_INC_DIRS= -I.
QNX_LIB_DIRS= -L../lib -L/usr/lib/X11
QNX_LIB_NAME= ../lib/libZafMtf.a
QNX_CPP= CC
QNX_LINK= CC
QNX_LIBRARIAN= wlib

QNX_CPP_OPTS= 
QNX_LINK_OPTS= -@3m
QNX_LIB_OPTS= -p=128

QNX_OBJS=
QNX_LIBS= -l$(QNX_LIB_NAME) -lXm_s -lXt_s -lX11_s -lXqnx_s -lsocket

.cpp.o:
	$(QNX_CPP) $(QNX_CPP_OPTS) $(QNX_INC_DIRS) -c $<


