# Zinc Application Framework - ZAFBOR.MAK
# COPYRIGHT (C) 1990-1997.  All Rights Reserved.
# Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#############################################################################
#
# "optsbor.mak" is the third in a series of three make files used to easily
# build ZAF projects from the command prompt -- it should not be invoked
# directly.  This file is also used when building the ZAF libraries.
#
# The three files used to build ZAF projects are:
# 1. makefile.mak - User supplied make file (see example below)
# 2. zafbor.mak   - The main ZAF make file unique to each compiler
# 3. optsbor.mak  - Compiler options and tools shared by ZAF and apps
#
# Applications and ZAF libraries should be build with identical compiler
# options to ensure compatibility.  If changes are made to this file the
# ZAF libraries should be rebuilt prior to building applications.
#
#############################################################################

#
# ----- Shared  options -----------------------------------------------------
#

#
# Compile options
#
# -O1   - opimization level 1 (optimize for size)
# -x-   - disable exception handling
# -I    - look for include files in the specified directory
SHARED_COMPILE_OPTIONS=-O1 -x- -I$(ZAF_ROOT)\include 

#
# Link options
#
# -c    - Case sensitive symbols
# -x    - No map file
# /L    - Specify library search paths
SHARED_LINK_OPTIONS=-c -x

#
# Library options
#
# /C    - Case sensitive library
SHARED_LIBRARY_OPTIONS=/C


#
# Debug options
#
# -v    - source level debugging
DEBUG_COMPILE_OPTIONS_ON=-v
# -v    - full symbolic debug information
DEBUG_LINK_OPTIONS_ON=-v
# /P    - page size
DEBUG_LIBRARY_OPTIONS_ON=/P512

DEBUG_COMPILE_OPTIONS_OFF=
DEBUG_LINK_OPTIONS_OFF=
# /P    - page size
DEBUG_LIBRARY_OPTIONS_OFF=/P64

#
# ----- 16 bit Windows options ----------------------------------------------
#

W16_COMPILER=bcc
W16_LINKER=tlink
W16_LIBRARIAN=tlib
W16_RESOURCE_COMPILER=brc

# -dc   - Move string literals from data segment to code segment
# -ml   - Compile using large memory model
# -Vf   - Far C++ virtual tables
# -WE   - Make the target a Windows .EXE with explicit functions exportable
# -h    - Use fast huge pointer arithmetic
W16_COMPILE_OPTIONS=$(SHARED_COMPILE_OPTIONS) -dc -ml -Vf -WE -h

# -C    - Case sensitive exports and imports
# -Twe - Build a Window .EXE file
W16_LINK_OPTIONS=$(SHARED_LINK_OPTIONS) -C -Twe

W16_LIBRARY_OPTIONS=$(SHARED_LIBRARY_OPTIONS)

# -16   - 16 bit windows compatible res/exe files
# -k    - Do not create fastload area.
W16_RESOURCE_OPTIONS=-16 -k

W16_OBJECT_FILES=c0wl

PERSIST_LIBRARY_NONE_16= zafw16n
PERSIST_LIBRARY_ALL_16= zafw16p

W16_LIBRARIES=zafw16 import mathwl cwl ctl3dv2


#
# ----- 32 bit Windows options ----------------------------------------------
#

W32_COMPILER=bcc32
W32_LINKER=tlink32
W32_LIBRARIAN=tlib
W32_RESOURCE_COMPILER=brc32

W32_COMPILE_OPTIONS=$(SHARED_COMPILE_OPTIONS)

# -Tpe  - Build a Windows .EXE file 
# -aa   - Specifies application target type as Windows
W32_LINK_OPTIONS=$(SHARED_LINK_OPTIONS) -Tpe -aa

W32_LIBRARY_OPTIONS=$(SHARED_LIBRARY_OPTIONS)

# -32   - 32 bit windows compatible res/exe files
W32_RESOURCE_OPTIONS=-32


W32_OBJECT_FILES=c0w32

PERSIST_LIBRARY_NONE_32= zafw32n
PERSIST_LIBRARY_ALL_32= zafw32p

W32_LIBRARIES=zafw32 import32 cw32 ctl3d32


#
# ----- 32 bit Windows DLL options ------------------------------------------
#

# -D    - Define the given macro
# -tWDE - Make the target a Windows .DLL with explicit functions exportable
W32_DLL_EXPORT_COMPILE_OPTIONS=$(SHARED_COMPILE_OPTIONS) -DZAF_DLL_EXPORT -tWDE

# -D    - Define the given macro
# -tWE - Make the target a Windows .EXE with explicit functions exportable
W32_DLL_IMPORT_COMPILE_OPTIONS=$(SHARED_COMPILE_OPTIONS) -DZAF_DLL_IMPORT -tWE

# -Tpd  - Build a Windows .DLL file 
# -aa   - Specifies application target type as Windows
W32_DLL_LINK_OPTIONS=$(SHARED_LINK_OPTIONS) -Tpd -aa

W32_DLL_EXPORT_OBJECT_FILES=c0d32
W32_DLL_EXPORT_LIBRARIES=import32 cw32i ctl3d32

W32_DLL_IMPORT_OBJECT_FILES=c0w32
W32_DLL_IMPORT_LIBRARIES=zafw32d zafw32i import32 cw32i 


#
# Impicit rule for building object files.
#
.cpp.ob1:
	$(W16_COMPILER) $(W16_COMPILE_OPTIONS) -c -o$*.ob1 $<

.cpp.obw:
	$(W32_COMPILER) $(W32_COMPILE_OPTIONS) -c -o$*.obw $<

.cpp.obx:
	$(W32_COMPILER) $(W32_DLL_EXPORT_COMPILE_OPTIONS) -c -o$*.obx $<

.cpp.obi:
	$(W32_COMPILER) $(W32_DLL_IMPORT_COMPILE_OPTIONS) -c -o$*.obi $<
