;****************************************************************************
; ClockMan95 Automation Assistant support file - TAPCIS script
; (c) 1995 Graphical Dynamics, Inc. The "Common helper functions" are placed
; in the public domain; otherwise permission is granted to use/modify this
; script file as long as it's not for resale.
;
; Written by: Jennifer Palonus
;
; Date    Who   Major changes
;-------  ---   -------------------------------------------------------------
;22nov95  jlp   Created.
;22nov95
;****************************************************************************

[*About this script*]
Gets the latest Harris Poll. This poll on current issues is updated
every Monday.

[*Script Setup*]
Title=Harris Poll

;****************************************************************************
; Main processing section.
;****************************************************************************

[*MenuItems*]
text=Harris Poll
item=1


[Begin]
	set @Timeout# 120
	let ServiceName$	= "CIS:SYN-27"
	let ServiceHasHdr	= @FALSE
	let SubjectLine$	= "The Harris Poll"
	let Prompt$			= "^J!"
	gosub "GoService"
	if (OK = @FALSE) fail

	ForEach in MenuItems[] gosub "HandleMenu"
	if (HMTFound = @FALSE) end

	gosub "CaptureMsg"
	end


;****************************************************************************
; Common helper functions. (These are placed in the "public domain" by GDI.)
;****************************************************************************
; [GoService]
;
; Carries out a GO command & passes over the introductory text (if any).
; When this returns, you're ready to capture or parse the service's top menu.
;
; ServiceName$		The CIS service you want to GO to.
; ServiceHasHdr		Does this service have an intro paragraph ending with a
;					"MORE !" prompt?
;****************************************************************************
[GoService]
	let OK = @TRUE
	send "GO " ServiceName$

	if (ServiceHasHdr = @FALSE) return
	let Prompt$ = "^JMORE !"		 
	gosub "WaitForPrompt"
	send ""
	return

	
;****************************************************************************
; [HandleMenu]
;
; Traverses the tree of menus until you're ready to capture a particular
; article. To call this function, declare an array section (ex.: [*Menus*])
; with menu item text and/or item numbers to look for, in either of these forms:
;     text=<text in menu item>
;     item=<menu item's number>
;     
; Then, call this function in a ForEach stmt: ForEach in Menus[] gosub "HandleMenu"
;
; SubjectLine$		The generated mail message's subject line.
; Prompt$			The prompt that ends the article. Usu. "^J!".
;
; Upon return, OK is @TRUE or @FALSE depending on whether any matching items
; were found. If @TRUE then you're ready to capture the selected article or
; parse the submenu.
;****************************************************************************
[HandleMenu]
	let HMTFound = @FALSE
	;Dispatch to HMText or HMItem, depending on how to choose menu item (by
	;"Text" or menu "Item" #)...
	goto "HM" @arrItem$
	;else bad menu cmd...
	 	Echo "Unrecognized menu item search type '" @arrItem$ "' in [HandleMenu]"
		fail

[HMText]
	let HMSearchText$ = @arrValue$

;1 or more menu sections. If >1, they're separated by "MORE !" prompts...
[HMTLoop]
	waitlist
		1 = "^JMORE !"
		2 = "^J!"
	endlist
	DoWaitMenu TheMenuLines[]
	if (@waitMatch# = 0) goto "HMTNoMatchTimeout"

	ForEach in TheMenuLines[] gosub "HMTSelectItem"
	if (HMTFound = @TRUE) return

[HMTNoMatch]
	if (@waitMatch# = 1) goto "HMTNoMatchMore"
	if (@waitMatch# = 2) goto "HMTNoMatchEOM"

[HMTNoMatchTimeout]
	Echo "Timed out waiting for full menu"
	fail

[HMTNoMatchMore]
	send ""
	goto "HMTLoop"

[HMTNoMatchEOM]
	return


[HMTSelectItem]
	if (HMTFound = @TRUE) return

	if (@strstr (@arrValue$, HMSearchText$) = @FALSE) return
	let HMTFound = @TRUE
	Echo "We found '" HMSearchText$ "': #" @arrItem$ " = '" @arrValue$ "'!"
	
	send @arrItem$
	return


[HMItem]
	let HMTFound = @TRUE
	let Prompt$ = ""
	gosub "WaitForPrompt"

	Echo "Selecting item #" @arrValue$
	send @arrValue$
	return

	
;****************************************************************************
; [CaptureMsg]
;
; Assuming CIS is about to send us the text that we want to place into a mail
; message, this routine captures the text 'till we get a <CR> & ! prompt.
;
; SubjectLine$		The custom subject line if different than the default.
; Prompt$			The prompt that ends the article. Usu. "^J!".
;****************************************************************************
[CaptureMsg]
	if (@capName$ = "") let @capName$ = @pathMsg$ @svcName$ '.MSG'
	let @hdrSub$ = SubjectLine$
	Echo "Capturing article to " @capName$
	CapHeader

	let OK = @TRUE

	let Prompt$ = "^J!"
	gosub "WaitForPrompt"
	CapClose

	let SubjectLine$ = ""
	return


;****************************************************************************
; [WaitForPrompt]
;
; Wait till the end of a menu or opening text. This routine handles menus
; split up into multiple chunks, each of which end in "MORE !" prompts.
; If you DO want to wait for "MORE !", then set Prompt$ to it.
;
; Prompt$			The prompt you're waiting for. Usu. "^J!".
;****************************************************************************
[WaitForPrompt]
	let OK = @TRUE
	if (Prompt$ = "") let Prompt$ = "^J!"

[WFPLoop]
	waitlist
		1 = Prompt$
		2 = "^JMORE !"
		3 = "^J!"
	endlist
	DoWaitMenu TheMenuLines[]
	if (@waitMatch# = 1) return
	if (@waitMatch# = 2) goto "WFPMore"
	if (@waitMatch# = 3) return

	; else...
	let OK = @FALSE
	Echo "...timed out waiting for a prompt"
	return

[WFPMore]
	Send ""
	goto "WFPLoop"


;****************************************************************************
[HandleErrors]
	fail

