;Gets the latest column by Cokie Roberts && Steven Roberts. It's updated
;every Wednesday.

;****************************************************************************
; ClockMan95 Automation Assistant support file
; (c) 1995 Graphical Dynamics, Inc. The "Common helper functions" are placed
; in the public domain; otherwise permission is granted to use/modify this
; script file as long as it's not for resale.
;
; Written by: Jennifer Palonus
;
; Date    Who	Major changes
;-------  ---	-------------------------------------------------------------
;16aug95  jlp	Created.
;****************************************************************************
	define $ServiceName		; used by GoService
	define #ServiceHasHdr	; used by GoService
	define $MenuItem		; used by ChooseMenuItem & FindMenuItem
	define $SubjectLine		; used by CaptureMsg
	define $Prompt			; used by WaitForPrompt
	define #OK				; used everywhere. Routines return %TRUE or /%FALSE
	onerror HandleErrors
	timeout 90


;****************************************************************************
; Main processing section.
;****************************************************************************
	set $ServiceName    "CIS:SYN-27"
	set #ServiceHasHdr  %FALSE
	set $Prompt         ^M^J "!"
	gosub GoService

	set $MenuItem       "Cokie Roberts"
	gosub FindMenuItem
	if #OK = %FALSE fail

 	set $MenuItem       "1"
	gosub ChooseMenuItem

	set $SubjectLine    "Cokie Roberts/Steven Roberts"
	gosub CaptureMsg
	end


;****************************************************************************
; Common helper functions. (These are placed in the "public domain" by GDI.)
;****************************************************************************
; GoService
;
; Carries out a GO command & passes over the introductory text (if any).
; When this returns, you're ready to capture or parse the service's top menu.
;
; $ServiceName		The CIS service you want to GO to.
; #ServiceHasHdr	Does this service have an intro paragraph ending with a
;					"MORE !" prompt?
;****************************************************************************
GoService:
	set #OK %TRUE
	sendln "GO " $ServiceName

	if #ServiceHasHdr = %FALSE return
	set $Prompt ^M^J "MORE !"		 
	gosub WaitForPrompt
	send %CR
	return

	
;****************************************************************************
; ChooseMenuItem
;
; Selects an article (by item #) from a menu. Upon return, you're ready to
; CaptureMsg it.
;
; $MenuItem			The menu selection #.
; $SubjectLine		The generated mail message's subject line if different
;					than the default.
; $Prompt			The prompt that ends the article. Usu. ^M^J "!".
;****************************************************************************
ChooseMenuItem:
	set #OK %TRUE
	set $Prompt ^M^J "!"
	gosub WaitForPrompt

	sendln $MenuItem
	wait ^M^J			; Skip echo of menu item #
	return


;****************************************************************************
; FindMenuItem
;
; Selects the first item in a menu that contains the string in $MenuItem.
; Assumes the menu is being sent & ready to parse.
;
; This is for services that keep adding articles to the front of the menu,
; and the article we're looking for always has the same title. There can end
; up being 0, 1, or more items with the same name, in unpredictable positions
; in the menu. The 1st one we find (lowest item #) is the most recent one.
; (ex.: AP's "Today in History", or "<day>'s Most Active Stocks", etc.)
;
; Using this routine also protects you when the provider moves items around
; within a menu. (It doesn't protect against the provider changing menu
; item names or moving items to other menus.)
;
; Upon return, #OK is %TRUE or %FALSE depending on whether any items were
; found that contained $MenuItem. If %TRUE then $MenuItem is also set to the
; full menu item description & caller is ready to capture or parse the
; selected article/submenu.
;
; If $MenuItem is found in the preface to the menu, then I guess we could get
; into trouble!
;
; $MenuItem			The menu selection name (or partial name).
; $SubjectLine		The generated mail message's subject line if different
;					than the default.
; $Prompt			The prompt that ends the article. Usu. ^M^J "!".
;****************************************************************************
FindMenuItem:
	define $FMILine
	define $FMIItem
	define $FMINum
	define #FMIToken
	define #FMIFound

	set #OK %TRUE
	FMILoop:
		add 1 "!"
		add 2 ^M^J				; Examine each line in turn...
		mwait #FMIToken
		
		if #FMIToken = 2 goto FMICheckWholeLine

		; ...else this is either a "!" or "MORE !" prompt, or a
		; stray "!" or "MORE !" inside a whole line...
		set $FMILine %COMDATA
		trim $FMILine

		; If multipart menu, tell CIS to send next part...
		if $FMILine = "MORE !" send %CR
		if $FMILine = "MORE !" goto FMILoop

		; If end of full menu & item wasn't found...
		if $FMILine = "!" set #OK %FALSE
		if $FMILine = "!" return

		FMICheckWholeLine:
		set $FMILine %LCOMDATA
		
		; Split off what should be item description & check it...
		midstr $FMILine 4 255 $FMIItem
		posnc #FMIFound $MenuItem $FMIItem
	if #FMIFound = 0 goto FMILoop
	
	; If we get here, we've found $MenuItem in a line...
	midstr $FMILine 1 2 $FMINum
	trim $FMINum		; We ASSUME first nonblank chars are a real menu item #!

	; Now that we have our item, skip the rest of the menu...
	set $Prompt ^M^J "!"
	gosub WaitForPrompt
	sendln $FMINum
	wait ^M^J					; Skip echo of menu item #
	set $MenuItem $FMIItem		; Return full menu item description
	return


;****************************************************************************
; CaptureMsg
;
; Assuming CIS is about to send us the text that we want to place into a mail
; message, this routine captures the text 'till we get a <CR> & ! prompt.
;
; $SubjectLine		The custom subject line if different than the default.
; $Prompt			The prompt that ends the article. Usu. ^M^J "!".
;****************************************************************************
CaptureMsg:
	set #OK %TRUE
	capture on CISMAIL.MSG
	if $SubjectLine =  "" WMH
	if $SubjectLine <> "" WMH $SubjectLine

	gosub WaitForPrompt
	capture off

	set $SubjectLine ""
	return


;****************************************************************************
; WaitForPrompt
;
; Wait till the end of a menu or opening text. This routine handles menus
; split up into multiple chunks, each of which end in "MORE !" prompts.
; If you DO want to wait for "MORE !", then set $Prompt to it.
;
; $Prompt			The prompt you're waiting for. Usu. ^M^J "!".
;****************************************************************************
WaitForPrompt:
	define #WFPToken
	set #OK %TRUE
	
	add 1 $Prompt
	add 2 ^M^J "MORE !"
	mwait #WFPToken
	if #WFPToken = 2 send %CR
	if #WFPToken = 2 goto WaitForPrompt

	return


;****************************************************************************
HandleErrors:
	fail

