/********************************************************************************************
 *
 * DCIHDW.H
 *
 * Private header file for Mario multi-vendor direct hardware access DLL.
 *
 *******************************************************************************************/

#if !defined __DCIHDW_H
#define __DCIHDW_H

#include <dciddi.h>

/* useful function macro */
#define LOCAL static _near

/* Default width and height for EnumSurface() */
#define DCISAMP_MAX_WIDTH       1024
#define DCISAMP_MAX_HEIGHT      768

/* clipping state flags */
#define  CS_NOCLIP		0x0000
#define  CS_CLIPPED		0x0001
#define  CS_OBSCURED	        0x0002
		
#define BI_IF09 mmioFOURCC('I','F','0','9')
#define COLORSUPPORT             enum ColorSupport

/* native format preferred by the display hardware */
enum ColorSupport
{
   NoColorSupport                = 0,
   YVU9_Planar                   = 1,
   YUV411_Packed                 = 2,
   YVU12_Planar                  = 3,
   YUV422_Packed                 = 4,
   RGB8_CLUT                     = 5,
   RGB16_555                     = 6,
   RGB16_565                     = 7,
   RGB24_888                     = 8,
   YVU9_Packed                   = 9,
   YVU12_Packed                  = 10,
   RGB32                         = 11,
   RGBAlpha32                    = 12,
   Alpha1                        = 13,
   Alpha8                        = 14,
   YUV211_Packed                 = 15
};

enum VID_DISPATCH { VDSP_SETBANK      =  1
                  , VDSP_SAVECONTEXT  =  2
                  , VDSP_RESTCONTEXT  =  3
                  , VDSP_SETTARGET    =  4
                  , VDSP_IDENTIFY     =  5
                  , VDSP_VERSION      =  6
                  , VDSP_QUERYBANK    =  7
                  , VDSP_SCANWIDTH    =  8
                  , VDSP_TERMINATE    =  9
                  };

/* CLIPRECTINFO is nodetype for MarioBlit() list */
typedef struct
{       
	DWORD   dwcGap;
	DWORD   dwcLen;
	DWORD   dwfWall;
} CLIPRECTINFO, FAR *LPCLIPRECTINFO;

typedef struct tagPrimeInfo
{
	DCIPRIMARY	Surface;
	HGLOBAL	   	hPrimeInfo;
} PRIMESURFINFO, FAR *LPPRIMESURFINFO;

typedef struct  
{
  int iBitsPerPixel;                        /* returned by GetDeviceCaps */
  int iBytesPerPixel;                       /* derived from iBitsPerPixel */
  int iPlanes;                              /* returned by GetDeviceCaps */
  WORD wVertRes;                            /* returned by GetDeviceCaps */
  int iSizePalette;                         /* returned by GetDeviceCaps */
  WORD wScanLineWidth;                      /* byte width of adapter scan line */
  DWORD dwLastPixelOffset;                  /* offset of last pixel in buffer */
  BOOL fBanked;                             /* TRUE for discrete banks */
  LPVOID lpvHdwDisp;                        /* addr of adapter dispatch routine */
  COLORSUPPORT Color;                       /* current adapter color mode */
} GLOBALDATA;

typedef struct tagOffScreenInstInfo
{
	DCIOFFSCREEN	OffSurface;     /* DCIOFFSCREEN structure			*/
	HGLOBAL			hOffInfo;       /* handle to OffScreen Info struct  */
	HGLOBAL			hOffSurf;       /* handle to OffScreen buffer	    */	
	WORD			wSelScrn;       /* Selector of Frame Buffer         */
	DWORD			dwOffScrn;      /* Offset of Frame Buffer           */
	LONG			lStrideScrn;    /* Stride of Frame Buffer           */
	HGLOBAL			hCBlit;	        /* handle to ClipBlit buffer	    */
	WORD			wSelCBlit;      /* Selector of ClipBlit buffer	    */
	DWORD			dwOffCBlit;     /* Offset of ClipBlit buffer   	    */
	RECT			rSrc;           /* current src rect					*/
	RECT			rDst;           /* current dst rect					*/ 
	RECT			rBound;			/* current bounding rect			*/
	WORD			fClipState;     /* flag for clipstate				*/
	LPCLIPRECTINFO	lpClipInfo;     /* info list for ClipBlit           */	
	HANDLE			hClipInfo;      /* handle for ClipInfo              */
	int				iInfoWall;      /* saved vallue for ClipBlit        */
	DWORD			dwTop;          /* screen coords. of top & left     */
	DWORD			dwLeft;         /* of window for clipping           */
	BYTE			bXcode[DCISAMP_MAX_WIDTH];   /* horizontal stretch codes         */
	BYTE			bYcode[DCISAMP_MAX_HEIGHT];  /* vertical stretch codes           */
} OFFINSTINFO, FAR *LPOFFINSTINFO;

/* Data definitions */
typedef VOID  (FAR CDECL * SAVEBANK)(WORD, WORD);
typedef VOID  (FAR CDECL * RESTBANK)(WORD, WORD);
typedef DWORD (FAR CDECL * SETTARG)(WORD, DWORD);

/* defined in dcihdw.c */
BOOL           VidInitialize ();
BOOL _loadds   VidWEP ();
void           VidGetDevMemAccess(DWORD, DWORD, LPWORD, LPDWORD, LPDWORD, 
                                  LPWORD);
COLORSUPPORT   VidQueryColorSupport();
void           VidStartDevMemAccess(BOOL);
void           VidDoneDevMemAccess(BOOL);

/* defined in validbmp.c */
COLORSUPPORT   ValidateBMP (HDC hdc);

/* clipped blit helper function: cblit.asm */
void FAR cblitLines(WORD, LPDWORD, DWORD, WORD, LPDWORD, DWORD, 
                    CLIPRECTINFO FAR *, DWORD );

/* ATI Mach32 detection code: ati68800.asm */
WORD FAR CDECL DispatchATI68800 ();

/* Weitek P9000 detection code: p9000.asm */
WORD FAR CDECL DispatchP9000 ();

/* DCI Command functions: dcisamp.c */
int     FAR PASCAL _loadds DCICreatePrimarySurface(LPVOID, LPVOID);
int     FAR PASCAL _loadds DCIEnumSurface(LPVOID, LPVOID);
int     FAR PASCAL _loadds DCICreateOffScreenSurface(LPVOID, LPVOID);

/* Primary Surface callbacks: dcisamp.c */
DCIRVAL CALLBACK _loadds BeginAccess(LPVOID, LPRECT);
void    CALLBACK _loadds EndAccess(LPVOID);
void    CALLBACK _loadds DestroySurface(LPVOID);

/* Extended Surface callbacks: dciexfns.c */
DCIRVAL CALLBACK _loadds BeginAccessOff(LPVOID, LPRECT);
void    CALLBACK _loadds EndAccessOff(LPVOID);
void    CALLBACK _loadds DestroySurfaceOff(LPVOID);
DCIRVAL CALLBACK _loadds DrawOff(LPVOID);
DCIRVAL CALLBACK _loadds SetCliplistOff(LPVOID, LPRGNDATA);
DCIRVAL CALLBACK _loadds SetDestinationOff(LPVOID, LPRECT, LPRECT);

/* Indeo format to YUV 4:2:2 converter: convert.asm */
void    FAR IF09TO422(WORD,DWORD,WORD,DWORD,DWORD,DWORD,DWORD);
/* stretch code generation: bresenham.c */
void    FAR CalculateStretchCode(LONG srcLength, LONG dstLength, LPBYTE code);
/* strecth blit routine: strblit.asm */
void    FAR StretchBlit(WORD, DWORD, DWORD, WORD, DWORD, DWORD, 
                        DWORD, DWORD, DWORD, DWORD, DWORD);
/* clipped blit routine: clipblit.c */
void    FAR ClipBlit(LPOFFINSTINFO);

#endif                                      /* __DCIHDW_H */