;//////////////////////////////////////////////////////////////////////////
;//                                                                      //
;//              INTEL CORPORATION PROPRIETARY INFORMATION               //
;//                                                                      //
;//      This software is supplied under the terms of a license          //
;//      agreement or nondisclosure agreement with Intel Corporation     //
;//      and may not be copied or disclosed except in accordance         //
;//      with the terms of that agreement.                               //
;//                                                                      //
;//////////////////////////////////////////////////////////////////////////

     ASSUME nothing

memS   EQU   0
?PLM   EQU   0
?WIN   EQU   1

_DATA        SEGMENT DWORD PUBLIC 'DATA'
; locals being kept in data space and not on stack to conserve register usage
ALIGN	4				;align on dword boundary
_DATA		ENDS

.386

ifndef SEGNAME
        SEGNAME equ <_DCISAMP32>
endif

;sBegin  Code
;createSeg %SEGNAME, CodeSeg, word, PUBLIC, use32, CODE
%SEGNAME        SEGMENT WORD PUBLIC USE32 'CODE'

ASSUME cs : _DCISAMP32
ASSUME ds : _DATA
ASSUME es : nothing
ASSUME fs : nothing

; CLIPINFO structure -- .c definition in rtv.h
CLIPINFO STRUCT
	dwcGap		DD	?
	dwcLen		DD	?
	dwfWall		DD	?
CLIPINFO ENDS   


; MarioBlit() helper function.  Copies a specified number
; of scan lines from the system buffer to the frame buffer,
; taking into account gaps between 
PUBLIC _cblitLines
_cblitLines PROC FAR

; set up equates for params
wSrcSel		EQU	WORD	PTR	ss:[ebp+0]
lpdwibSrc 	EQU	DWORD	PTR	ss:[ebp+2]
dwcSrcWidth	EQU	DWORD	PTR	ss:[ebp+6]
wDstSel		EQU	WORD	PTR ss:[ebp+10]
lpdwibDst 	EQU	DWORD	PTR	ss:[ebp+12]
dwStride	EQU	DWORD	PTR ss:[ebp+16]
lpInfo		EQU	DWORD	PTR ss:[ebp+20]
wcLines		EQU	DWORD	PTR	ss:[ebp+24]

;  other aliases
wInfoOff	EQU WORD	PTR ss:[ebp+20]

; set up stack frame
	push	ebp
    push	edi
    push	esi
	push	ds
    movzx	ebp, sp			; bp now pointing to last pushed reg
	add		ebp, 20			; inc past pushed regs and ret addr

; set up register usage

	mov		ds, wSrcSel		
	xor		esi, esi
	lfs		si, lpdwibSrc
	mov		esi, fs:[esi]	; ds:esi now points to src buffer

	mov		es,	wDstSel
	xor		edi, edi
	lfs		di, lpdwibDst
	mov		edi, fs:[edi]	; es:edi now points to dst buffer

	xor		ebx, ebx
	lgs		bx,	lpInfo		; gs:ebx now points to Info List

	mov		eax, wcLines	; eax holds number of scan lines to copy
	xor		edx, edx
	cld
	
; ds:esi  = source buffer
; es:edi  = destination buffer
; gs:ebx  = InfoList
; eax     = number of lines to write
	
	DoLines:
		
		add		ebx, SIZEOF CLIPINFO				; inc past Door record
			
		DoScanLine:
			add		esi, (CLIPINFO PTR gs:[ebx]).dwcGap	; inc to left edge of next rect
			
			add		edi, (CLIPINFO PTR gs:[ebx]).dwcGap
		
			mov		ecx, (CLIPINFO PTR gs:[ebx]).dwcLen	; # of bytes to copy
			
			xor 	edx, edx
						
			shrd	edx, ecx, 2							
			rol		edx, 2								; edx now holds ecx%4
			shr		ecx, 2								; ecx now holds ecx/4
			rep		movsd							; copy ecx DWORDS
				
			mov		ecx, edx							; ecx now holds 0 or 1 or 2 or 3 
			rep		movsb							; copy last bytes
					
			add		ebx, SIZEOF CLIPINFO				; inc to next Info record
			cmp		(CLIPINFO PTR gs:[ebx]).dwfWall, 0	; check for Wall record	
			jz		DoScanLine
	
		sub		esi, (CLIPINFO PTR gs:[ebx]).dwcGap		; subtract to left edge

		add		esi, dwcSrcWidth						; add source stride
		
		sub		edi, (CLIPINFO PTR gs:[ebx]).dwcGap		; subtract to left edge
		
		add		edi, dwStride							; add dest. stride
		
;		dec		(CLIPINFO PTR gs:[ebx]).dwcLen			; we've just finished a line
		mov		bx, wInfoOff							; reload Info ptr to start rec of stripe
		
		dec		eax
		jnz		DoLines
	
	xor		eax, eax
	lfs		ax, lpdwibSrc
	mov		fs:[eax], esi		; update src offset
	
	xor		eax, eax
	lfs		ax, lpdwibDst
	mov		fs:[eax], edi		; update dst offset
	
	xor		ebx, ebx        	; clean up code. Clear seg registers. Pop saved registers.
	mov		fs,  bx
	pop		ds      
	pop		esi             
	pop		edi             
	pop		ebp             
	db		66h             	; toggle to 16bit style return
	retf

_cblitLines endp

%SEGNAME ENDS
end
