// SaveDlg.cpp : implementation file
//
// Source module for Boot Options version 1.0
// Copyright 1996 Ziff Davis Publishing
// First published in PC Magazine September 24, 1996
// Written by Gregory A. Wolking.

#include "stdafx.h"
#include "bootopt.h"
#include "MyEdit.h"
#include "SaveDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSaveAsDlg dialog

CSaveAsDlg::CSaveAsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSaveAsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSaveAsDlg)
	m_strName = _T("");
	//}}AFX_DATA_INIT
}

void CSaveAsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSaveAsDlg)
	DDX_Control(pDX, IDC_txtName, m_txtName);
	DDX_Control(pDX, IDOK, m_cmdOK);
	DDX_Text(pDX, IDC_txtName, m_strName);
	DDV_MaxChars(pDX, m_strName, 40);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSaveAsDlg, CDialog)
	//{{AFX_MSG_MAP(CSaveAsDlg)
	ON_EN_CHANGE(IDC_txtName, OnChangetxtName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSaveAsDlg message handlers

//////////////////////////
// This function "watches" the edit field
// and disables the OK button if the name is illegal.
//////////////////////////
void CSaveAsDlg::OnChangetxtName() 
{
	CString scratch;

	m_txtName.GetWindowText(scratch);			// Get the text.
	scratch.TrimRight();						// Trim leading and trailing spaces.
	scratch.TrimLeft();
	m_cmdOK.EnableWindow(!(	scratch.IsEmpty() ||
							scratch.CompareNoCase("(Original)") == 0 ||
							scratch.CompareNoCase("(Current file settings)") == 0));
}

BOOL CSaveAsDlg::OnInitDialog()
{
	CDialog::OnInitDialog();		// Initialize dialog controls,
	m_txtName.SetFilterText("\\");	// set filter to exclude backslashes,
	OnChangetxtName();				// then enable/disable the OK button appropriately.
	return TRUE;					// Return TRUE to let dialog set initial focus.
}

void CSaveAsDlg::OnOK() 
{
	CDialog::OnOK();		// Get edit field contents into m_strName
	m_strName.TrimRight();	// Trim leading and trailing spaces
	m_strName.TrimLeft();	// before closing the window.
}
