// BOOTOPT.h : main header file for the BOOTOPT application
//
// Source module for Boot Options version 1.0
// Copyright 1996 Ziff Davis Publishing
// First published in PC Magazine September 24, 1996
// Written by Gregory A. Wolking.

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// main symbols

/////////////////////////////////////////////////////////////////////////////
// CBootOptApp:
// See BOOTOPT.cpp for the implementation of this class
//

// Structure for option data.
struct OPT_KEY_DATA
{
	char *name;		// Option key string used in MSDOS.SYS.
	int sysdefault;	// System default value.
	int min;		// Minimum possible value.
	int max;		// Maximum possible value.
	int file;		// Original value read from file.
	int setting;	// Setting applied by user
	BOOL forced;	// Flag; FALSE means key was not specified in the file when initially read.
	CWnd *control;	// Pointer to control window.
};

// Return values for CBootOptDlg::Save_Settings()
enum save_settings_status 
{
	SAVE_OK,
	SAVE_FAIL_NO_ACCESS,
	SAVE_FAIL_NO_BACKUP,
	SAVE_FAIL_RESTORED,
	SAVE_FAIL_NOT_RESTORED,
	SAVE_FAIL_NOT_CREATED,
};

class CBootOptApp : public CWinApp
{
public:
	CBootOptApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBootOptApp)
	public:
	virtual BOOL InitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(CBootOptApp)
		// NOTE - the ClassWizard will add and remove member functions here.
	afx_msg void OnHelp();
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	BOOL do_uninstall;
	// Variables
	CString which_profile;
	BOOL do_restart;
	BOOL do_load;
	BOOL do_warning;
	// Functions
	BOOL Bad_Parm(LPCTSTR msg);
	BOOL Check_Command_Line();
	BOOL Do_Setup(void);
	BOOL Find_Correct_Drive(void);
};


/////////////////////////////////////////////////////////////////////////////
