// BOOTOPT.cpp : Defines the class behaviors for the application.
//
// Source module for Boot Options version 1.0
// Copyright 1996 Ziff Davis Publishing
// First published in PC Magazine September 24, 1996
// Written by Gregory A. Wolking.

#include "stdafx.h"
#include "BOOTOPT.h"
#include "BootDlg.h"
#include "Resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBootOptApp

// Global variables.
char sysfilename[13] = "C:\\MSDOS.SYS";
char bakfilename[13] = "C:\\MSDOS.BKP";
CString win_directory;
BOOL win_drive_compressed, file_paths_bad;
char win_host_drive;

BEGIN_MESSAGE_MAP(CBootOptApp, CWinApp)
	//{{AFX_MSG_MAP(CBootOptApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	ON_COMMAND(ID_HELP, OnHelp)
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBootOptApp construction

CBootOptApp::CBootOptApp()
{
	// Set application name -- this is used by AfxMessageBox functions to
	// provide the caption for the message box.
	m_pszAppName = "Boot Options";
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CBootOptApp object

CBootOptApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CBootOptApp initialization

BOOL CBootOptApp::InitInstance()
{
	ATOM myAtom;
	OSVERSIONINFO vi;
	HWND main_dlg, save_dlg;

	vi.dwOSVersionInfoSize = sizeof(vi);	// Initialize OSVERSIONINFO structure.
	GetVersionEx(&vi);						// Get version information.
	if ((vi.dwMajorVersion != 0x4) || (vi.dwPlatformId != VER_PLATFORM_WIN32_WINDOWS))	// Windows 95?
	{
		AfxMessageBox(MSG_WRONG_VERSION, MB_OK);	// Report error and quit if not.
		return FALSE;
	}
	myAtom = GlobalFindAtom("BootOpt Active");	// If so, see if our atom exists in the global atom table.

// Debug-version-only code allows programmer to delete the atom in case the last run crashed.
#ifdef _DEBUG
	if (myAtom)
	{
		if (::MessageBox(NULL, "Atom exists. Delete it?", m_pszAppName, MB_YESNO) == IDYES)
		{
			GlobalDeleteAtom(myAtom);
			myAtom = NULL;
		}
	}
#endif
// End debugging code.

	if (myAtom)		// If atom exists, we're already running.
	{
		main_dlg = FindWindowEx(NULL, NULL, "#32770", "Boot Options");	// Look for other instance's window.
		if (main_dlg != NULL)											// If found,
		{
			save_dlg = FindWindowEx(NULL, NULL, "#32770", "Save Profile");	// Look for Save Profile dialog.
			if (save_dlg != NULL)						// If the Save Profile dialog is visible,
				SetForegroundWindow(save_dlg);			// activiate it.
			else
			{	// If not, look for the About box.
				save_dlg = FindWindowEx(NULL, NULL, "#32770", "About Boot Options");
				if (save_dlg != NULL)					// If found,
					SetForegroundWindow(save_dlg);		// activate the About box.
				else
				{
					if (IsIconic(main_dlg))					// If main window is minimized,
						ShowWindow(main_dlg, SW_RESTORE);	// restore it,
					else
						SetForegroundWindow(main_dlg);		// otherwise activate it.
				}
			}

		}
		else										// Otherwise, previous instance has no visible windows,
			AfxMessageBox(MSG_NO_MULT_INST, MB_OK);	// (e.g., it has crashed) so just display error message.
	}
	else
	{												// Otherwise, we're the only instance so
		myAtom = GlobalAddAtom("BootOpt Active");	// install our atom.
		CBootOptDlg dlg;			// declare our main dialog object,
		m_pMainWnd = &dlg;			// and get a pointer to it.
		if (Do_Setup())				// If setup succeeds and no automatic-mode functions,
			dlg.DoModal();			// activate the main dialog.
		else
			m_pMainWnd = NULL;		// Otherwise indicate that we have no main window.
		GlobalDeleteAtom(myAtom);	// Delete our multiple-instance flag.
	}
	return FALSE;	// And we're done -- returning FALSE exits the program.
}

///////////////////////////
// This overrides the CWinApp:: version of OnHelp()
///////////////////////////
void CBootOptApp::OnHelp()
{
	CWnd * wnd;

	wnd = m_pMainWnd->GetFocus();	// Find out which dialog control (if any) has the focus.
	if (wnd != NULL)				// If a control has the focus,
		((CBootOptDlg *) m_pMainWnd)->SetHelpID(wnd->GetDlgCtrlID());	// set the dialog's context.
	CWinApp::OnHelp();	// Call the base class to launch WinHelp.
}

// Helper functions
/////////////////////////////////////
// Parse the command line
// Returns FALSE if any invalid parameters.
// Otherwise, sets the do_restart, do_load, do_warning, and do_uninstall flags,
// the which_profile string, and returns TRUE.
/////////////////////////////////////
BOOL CBootOptApp::Check_Command_Line()
{
	CString cmdLine(m_lpCmdLine), scratch(m_lpCmdLine);	// Make two copies of the command line arguments.
	int pos_restart, pos_silent, pos_profile, pos_uninstall;

	do_restart = FALSE;		// Set default flag values.
	do_warning = TRUE;
	do_load = FALSE;
	do_uninstall = FALSE;
	if (cmdLine.IsEmpty())	// Nothing to do if command line is blank.
		return TRUE;
	scratch.MakeLower();	// Convert 2nd copy of command line to lowercase.
	pos_restart = scratch.Find("/restart");	// Find out which parms were specified and where.
	pos_silent = scratch.Find("/silent");
	pos_profile = scratch.Find("/profile:");
	pos_uninstall = scratch.Find("/uninstall");
	if ((pos_restart < 0) && 
		(pos_silent < 0) &&
		(pos_profile < 0) &&
		(pos_uninstall < 0))	// Error if none of the expected parms present.
		return Bad_Parm("No recognizeable arguments found.");
	do_load = (pos_profile >= 0);
	do_restart = (pos_restart >= 0 && (do_load ? pos_profile > pos_restart : TRUE));
	do_warning = !(pos_silent >= 0 && (do_load ? pos_profile > pos_silent : TRUE));
	do_uninstall = (pos_uninstall >= 0 && (do_load ? pos_profile > pos_uninstall : TRUE));
	if (do_load)	// Was /PROFILE: present?
	{
		pos_profile += 9;							// Move past "/PROFILE:"
		if (pos_profile >= scratch.GetLength())		// Error if end of line.
			return Bad_Parm("/PROFILE: argument is missing.");
		which_profile = cmdLine.Mid(pos_profile);	// Extract profile name.
		which_profile.TrimLeft();					// Trim leading and trailing whitespace.
		which_profile.TrimRight();
		if (which_profile.IsEmpty())				// Error if profile name is blank.
			return Bad_Parm("/PROFILE: argument is missing.");
	}
	return TRUE;	// Signal no syntax errors to caller.
}

///////////////////////////////
// Command line error message.
///////////////////////////////
BOOL CBootOptApp::Bad_Parm(LPCTSTR msg)
{
	CString scratch("Syntax error on command line:\n\n");

	scratch += msg;
	::MessageBox(NULL, scratch, m_pszAppName, MB_ICONEXCLAMATION);
	return FALSE;
}
/////////////////////////////
// Handles command-line processing and such.
// Returns TRUE if the dialog should be launched.
// If there are any syntax errors, an appropriate message is displayed
/////////////////////////////
BOOL CBootOptApp::Do_Setup(void)
{
	CString msg;
	CBootOptDlg * mydlg = (CBootOptDlg*) m_pMainWnd;	// Get a properly-cast pointer to the dialog.

	if (Check_Command_Line())
	{
		if (do_uninstall)			// "/UNINSTALL" specified?
		{							// Present warning prompt.
			if (AfxMessageBox(MSG_UNINSTALL_WARN, MB_YESNO | MB_ICONSTOP | MB_DEFBUTTON2) == IDYES)
			{						// If user said "Yes", try to delete Registry data.
				if (RegDeleteKey(HKEY_CURRENT_USER, "Software\\PC Magazine\\Boot Options") == ERROR_SUCCESS)
					AfxMessageBox(MSG_UNINSTALL_DONE, MB_ICONINFORMATION);
				else
					AfxMessageBox(MSG_UNINSTALL_FAIL, MB_ICONEXCLAMATION);
			}
			else
				AfxMessageBox(MSG_UNINSTALL_CANCEL, MB_ICONINFORMATION);
			return FALSE;			// "/UNINSTALL" overrides other parms, so return FALSE to exit program.
		}
		if (!Find_Correct_Drive())		// Find correct letters for boot and windows drives.
			return FALSE;				// Can't continue if call fails.
		if (do_restart && do_warning)	// Was /RESTART specified without /SILENT?
										// If so, display warning
			if (AfxMessageBox(MSG_QUERY_RESTART, MB_OKCANCEL | MB_ICONSTOP | MB_DEFBUTTON2) != IDOK)
				return FALSE;			// and quit unless user says "Yes".
		if (do_load)									// If /PROFILE: was specified,
		{
			if (mydlg->Load_Profile(which_profile))		// Try to load the profile.
			{											// If load succeeded,
				if (mydlg->Save_Settings() != SAVE_OK)	// try to rewrite MSDOS.SYS
					return FALSE;						// Bail out if write failed.
			}
			else										// If load failed, report the error and quit.
				return Bad_Parm("Unable to load the specified profile.");
			if ((!do_restart) && do_warning)			// If /RESTART was not specified with /SILENT,
			{											// display rewrite confirmation message.
				msg.Format("MSDOS.SYS rewritten using profile '%s'.", which_profile);
				AfxMessageBox(msg);
				return FALSE;
			}
		}
		if (do_restart)	// Was /RESTART specified?
		{				// Restart system and quit if so.
			ExitWindowsEx(EWX_LOGOFF | EWX_REBOOT, NULL);
			return FALSE;
		}
	}
	return TRUE;
}

/////////////////////////////////////
// This function determines the correct copy of MSDOS.SYS to modify
// as well as the proper setting for the HostWinBootDrv= key.
// If successful, returns TRUE and sets the following global variables:
//    sysfilename[]
//    bakfilename[]
//    win_drive_compressed
//    win_host_drive
//    win_directory
// Otherwise, displays appropriate error message and returns FALSE.
/////////////////////////////////////
BOOL CBootOptApp::Find_Correct_Drive(void)
{
	char * drive_spec = "C:\\";
	char * file_part;
	int i, pos;
	DWORD max_length, flags, drive_bits, file_size, bytes_read;
	BOOL result, boot_compressed, ini_locked, any_compressed;
	char buffer[MAX_PATH];
	HANDLE fh;
	SECURITY_ATTRIBUTES sa = {sizeof(sa), NULL, FALSE};
	CString swapped_drives;

	GetWindowsDirectory(buffer, MAX_PATH);			// Get the "official" Windows directory.
	win_directory = buffer;
	win_directory.MakeUpper();						// Force uppercase for comparison.
													// Get info for drive C:
	result = GetVolumeInformation(drive_spec, NULL, 0, NULL, &max_length, &flags, NULL, 0);
	boot_compressed = (flags & FS_VOL_IS_COMPRESSED) != 0;	// Set flag if C: is compressed.
	if (win_directory[0] == 'C')					// If Windows is on C:,
		win_drive_compressed = boot_compressed;		// Windows drive compression state is the same.
	else
	{
		drive_spec[0] = win_directory[0];			// Otherwise, get info for Windows drive.
		result = GetVolumeInformation(drive_spec, NULL, 0, NULL, &max_length, &flags, NULL, 0);
		win_drive_compressed = (flags & FS_VOL_IS_COMPRESSED) != 0;		// Set flag if it's compressed.
	}
	ini_locked = FALSE;					// Clear DBLSPACE.INI status flag.
	drive_bits = GetLogicalDrives() >> 2;	// Get list of existing drive letters, shift bits to skip a: and b:.
	//drive_bits >>= 2;					// Shift bits down to ignore A: and B:

	for (i = 'C';						// Start with drive C:
		(boot_compressed				// If boot drive is compressed,
			? (i <= 'Z')				// Check all drives, otherwise
			: (i == 'C'));				// check only drive C:
		drive_bits >>= 1, i++)			// Shift bits and update letter on each loop.
	{
		if (drive_bits & 1)							// If the letter exists,
		{
			drive_spec[0] = i;						// Get info for that drive.
			result = GetVolumeInformation(drive_spec, NULL, 0, NULL, &max_length, &flags, NULL, 0);
			if (flags & FS_VOL_IS_COMPRESSED)		// Is it compressed?
			{
				any_compressed = TRUE;				// If so, set flag
				continue;							// and move on to the next drive.
			}
			if (SearchPath(drive_spec, "DBLSPACE", ".INI", sizeof(buffer), buffer, &file_part))
			{	// If DBLSPACE.INI exists on the drive, try to open and lock it.
				fh = CreateFile(buffer,	GENERIC_READ, 0, &sa, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
				if (fh == INVALID_HANDLE_VALUE)		// If open failed,
				{									// set flag if file was locked
					ini_locked |= (GetLastError() == ERROR_ACCESS_DENIED);
					continue;						// and continue with next drive.
				}
				file_size = GetFileSize(fh, NULL);	// Get size of file.
				CString file_data('X', file_size);	// Make buffer big enough to hold the whole thing.
				result = ReadFile(fh, file_data.GetBuffer(file_size), file_size, &bytes_read, NULL);
				file_data.ReleaseBuffer();			// Clean up the CString after direct access.
				file_data.MakeUpper();				// Convert to uppercase.
				CloseHandle(fh);					// Close the file.
				if ((!result) || (bytes_read != file_size))
					continue;						// Next drive if read error.
				// Build string of swapped drive letters according to DBLSPACE.INI.
				while((pos = file_data.Find("ACTIVATEDRIVE=")) >= 0)
				{
					file_data = file_data.Mid(pos);			// Chop data prior to first "ACTIVATEDRIVE=".
					if (file_data.GetLength() < 17)			// If less than 17 bytes remaining, file is damaged.
						break;
					file_data = file_data.Mid(14);			// Cut off "ACTIVATEDRIVE=".
					swapped_drives += file_data.Left(3);	// Add drive letters to the list.
				}
				if (boot_compressed)							// If boot drive was compressed,
				{
					if (swapped_drives.GetLength() == 0)		// If no swapped letters found,
						continue;								// could be a bogus copy of the file.
					buffer[1] = ',';							// Make the drive where this copy of DBLSPACE.INI
					buffer[2] = 'C';							// is found is the host for drive C:
					buffer[3] = 0;						 		// If so, we know we've found the right copy of
					if (swapped_drives.Find(buffer) >= 0)		// the file, so our map information is correct
						break;									// and we can stop looking.
					swapped_drives.Empty();						// Otherwise, reset the swapped drive string
				}
			}
		}
	}
	if (boot_compressed)										// If boot drive was compressed,
	{
		if (swapped_drives.GetLength())							// Did we get a valid drive map?
			sysfilename[0] = bakfilename[0] = drive_spec[0];	// If so, adjust filenames appropriately.
		else													// Otherwise,
		{
			if (any_compressed && ini_locked)					// Was DBLSPACE.INI locked?
				AfxMessageBox(MSG_NO_DBLSPACE, MB_ICONSTOP);	// If so, report it.
			else												// If not, 
				AfxMessageBox(MSG_NO_FIND_MSDOS, MB_ICONSTOP);	// must not be using DrvSpace!
			return FALSE;										// report failure.
		}
	}
	if (win_drive_compressed)									// Windows drive compressed?
	{
		if (swapped_drives.GetLength())							// If so, got valid compression map?
		{
			sprintf(buffer, ",%c", win_directory[0]);			// Look for "," + drive letter.
			if ((pos = swapped_drives.Find(buffer)))			// Is Windows drive present in map?
			{
				win_host_drive = swapped_drives[--pos];			// If so, set host drive letter
				return TRUE;									// and report success.
			}
		}
	}
	else														// Windows drive _not_ compressed,
	{
		win_host_drive = win_directory[0];						// So set drive letter and
		return TRUE;											// report success.
	}
	// If we got this far, Windows drive is compressed but we could not
	// determine its host letter. Display message and report failure.
	AfxMessageBox(MSG_NO_FIND_MSDOS, MB_ICONSTOP);
	return FALSE;
}
