// BootDlg.h : header file
//
// Source module for Boot Options version 1.0
// Copyright 1996 Ziff Davis Publishing
// First published in PC Magazine September 24, 1996
// Written by Gregory A. Wolking.

/////////////////////////////////////////////////////////////////////////////
// CBootOptDlg dialog
// Enumerated types for key indexes.
// Note that the number and order of the keys in this list must match the
// order of the initializers for the opt_data[] array declared in BOOTDLG.CPP
// If you decide to alter this, existing Registry profiles will not be useable.
enum opt_key
{
	BootDelay,
	BootMenu,
	BootKeys,
	BootGUI,
	BootMulti,
	BootMenuDefault,
	BootMenuDelay,
	BootSafe,
	BootWarn,
	BootWin,
	DblSpace,
	DisableLog,
	DoubleBuffer,
	DrvSpace,
	LoadTop,
	Logo,
	Network,
	SystemReg,
	// SettingCount tells us how big the opt_data array is.
	SettingCount
};

enum {
	HostWinBootDrv,
	WinBootDir,
	WinDir
};

// Return bit fields for Compare_Paths()
enum {
	CP_PATHS_MATCH = 1,
	CP_REG_FAIL = 2,
	CP_REG_CORRECT = 4,
	CP_FILE_CORRECT = 8
};


class CBootOptDlg : public CDialog
{
// Construction
public:
	CBootOptDlg(CWnd* pParent = NULL);	// standard constructor
	BOOL Load_Profile(LPCTSTR profile_name);
	int Save_Settings(void);

// Dialog Data
	//{{AFX_DATA(CBootOptDlg)
	enum { IDD = IDD_BOOTOPT_DIALOG };
	CStatic	m_lblTimeout;
	CStatic	m_lblStartup;
	CStatic	m_lblSelection;
	CStatic	m_lblStatus;
	CEdit	m_txtDelay;
	CButton	m_chkSystem1;
	CButton	m_chkSystem2;
	CButton	m_chkSystem3;
	CButton	m_chkDisable1;
	CButton	m_chkDisable2;
	CButton	m_chkDisable3;
	CButton	m_chkBootWin;
	CButton	m_chkAlways;
	CButton	m_chkKeys;
	CButton	m_cmdDeleteProfile;
	CButton	m_fraAdvanced;
	CComboBox	m_cmbProfile;
	CButton	m_chkSafeMode;
	CButton	m_chkNetwork;
	CButton	m_chkWarn;
	CButton	m_chkTop;
	CButton	m_chkLogo;
	CButton	m_chkGUI;
	CButton	m_chkDualBoot;
	CButton	m_chkDrvSpace;
	CButton	m_chkDoubleBuffer;
	CButton	m_chkDblSpace;
	CEdit	m_txtTimeOut;
	CComboBox	m_cmbDefault;
	UINT	m_int_Timeout;
	UINT	m_int_Delay;
	int		m_int_DisableLog;
	int		m_int_SystemReg;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBootOptDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void OnOK();
	virtual void OnCancel();
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CBootOptDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnchkAlways();
	afx_msg void OnchkBootWin();
	afx_msg void OnchkDblSpace();
	afx_msg void OnchkDoubleBuffer();
	afx_msg void OnchkDrvSpace();
	afx_msg void OnchkDualBoot();
	afx_msg void OnchkGUI();
	afx_msg void OnchkKeys();
	afx_msg void OnchkLogo();
	afx_msg void OnchkNetwork();
	afx_msg void OnchkTop();
	afx_msg void OnchkWarn();
	afx_msg void OnSelendokcmbDefault();
	afx_msg void OnKillfocustxtDelay();
	afx_msg void OnKillfocustxtTimeOut();
	afx_msg void OncmdRestart();
	afx_msg void OncmdApply();
	afx_msg void OnchkSafeMode();
	afx_msg void OncmdSaveProfile();
	afx_msg void OncmdDeleteProfile();
	afx_msg void OnchkDisable1();
	afx_msg void OnchkSystem1();
	afx_msg void OnChangetxtDelay();
	afx_msg void OnChangetxtTimeout();
	afx_msg void OnDropdowncmbProfile();
	afx_msg void OncmdFindProfile();
	afx_msg void OncmdAbout();
	afx_msg void OnSelendokcmbProfile();
	//}}AFX_MSG

// Overridden function to capture the ID_HELP_USING message.
	afx_msg void OnHelpUsing();
	afx_msg void OnContextHelp();
	DECLARE_MESSAGE_MAP()

private:
	CString current_name;
	void Set_Button_Status(void);
	BOOL dirty;
	UINT popup_context;
	int current_profile;
	BOOL shut_down;
	int last_loaded[SettingCount];

	void Build_Menu_List(void);
	void Copy_To_Last(void);
	void Get_Profile_Names(void);
	void Load_Controls(void);
	void Synch_Profile_Name(void);
	void Update_Profile_Selection(void);
	BOOL Compare_To_Last(void);
	BOOL Do_Initial_Setup(void);
	BOOL Read_File(void);
	BOOL Save_Profile(LPCTSTR profile_name);
	void Do_Path_Warning(void);
};
