// BootDlg.cpp : implementation file
//
// Source module for Boot Options version 1.0
// Copyright 1996 Ziff Davis Publishing
// First published in PC Magazine September 24, 1996
// Written by Gregory A. Wolking.

#include "stdafx.h"
// #include <winreg.h>		Moved to stdafx.h for pre-compiled header.
#include "BOOTOPT.h"
#include "BootDlg.h"
#include "MyEdit.h"
#include "SaveDlg.h"
#include "resource.h"
#include "resource.hm"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Global data for the various option settings.

// The number and order of the initializers for this array MUST match
// the opt_key enumerated type (declared in BootDlg.h)
struct OPT_KEY_DATA opt_data[SettingCount] =
{
	{"BootDelay",		2, 0, 32767, 0, 0, FALSE},
	{"BootMenu",		0, 0, 1, 0, 0, FALSE},
	{"BootKeys",		1, 0, 1, 0, 0, FALSE},
	{"BootGUI",			1, 0, 1, 0, 0, FALSE},
	{"BootMulti",		0, 0, 1, 0, 0, FALSE},
	{"BootMenuDefault",	1, 1, 8, 0, 0, FALSE},
	{"BootMenuDelay",	30, 0, 32767, 0, 0, FALSE},
	{"BootSafe",		0, 0, 1, 0, 0, FALSE},
	{"BootWarn",		1, 0, 1, 0, 0, FALSE},
	{"BootWin",			1, 0, 1, 0, 0, FALSE},
	{"DblSpace",		1, 0, 1, 0, 0, FALSE},
	{"DisableLog",		0, 0, 1, 0, 0, FALSE},
	{"DoubleBuffer",	0, 0, 1, 0, 0, FALSE},
	{"DrvSpace",		1, 0, 1, 0, 0, FALSE},
	{"LoadTop",			1, 0, 1, 0, 0, FALSE},
	{"Logo",			1, 0, 1, 0, 0, FALSE},
	{"Network",			0, 0, 1, 0, 0, FALSE},
	{"SystemReg",		0, 0, 1, 0, 0, FALSE},
};

// Global variables (declared in BOOTOPT.CPP)
extern char sysfilename[13], bakfilename[13];
extern CString win_directory;
extern BOOL win_drive_compressed, file_paths_bad;
extern char win_host_drive;

// File keys for [Paths] section of MSDOS.SYS
const char* path_keys[3] =
{
	"HostWinBootDrv",
	"WinBootDir",
	"WinDir"
};

// Until further notice, this is all Class Wizard code.
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBootOptDlg dialog

CBootOptDlg::CBootOptDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBootOptDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBootOptDlg)
	m_int_Timeout = 0;
	m_int_Delay = 0;
	m_int_DisableLog = -1;
	m_int_SystemReg = -1;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBootOptDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBootOptDlg)
	DDX_Control(pDX, IDC_lblTimeout, m_lblTimeout);
	DDX_Control(pDX, IDC_lblStartup, m_lblStartup);
	DDX_Control(pDX, IDC_lblSelection, m_lblSelection);
	DDX_Control(pDX, IDC_lblStatus, m_lblStatus);
	DDX_Control(pDX, IDC_txtDelay, m_txtDelay);
	DDX_Control(pDX, IDC_chkSystem1, m_chkSystem1);
	DDX_Control(pDX, IDC_chkSystem2, m_chkSystem2);
	DDX_Control(pDX, IDC_chkSystem3, m_chkSystem3);
	DDX_Control(pDX, IDC_chkDisable1, m_chkDisable1);
	DDX_Control(pDX, IDC_chkDisable2, m_chkDisable2);
	DDX_Control(pDX, IDC_chkDisable3, m_chkDisable3);
	DDX_Control(pDX, IDC_chkBootWin, m_chkBootWin);
	DDX_Control(pDX, IDC_chkAlways, m_chkAlways);
	DDX_Control(pDX, IDC_chkKeys, m_chkKeys);
	DDX_Control(pDX, IDC_cmdDeleteProfile, m_cmdDeleteProfile);
	DDX_Control(pDX, IDC_cmbProfile, m_cmbProfile);
	DDX_Control(pDX, IDC_chkSafeMode, m_chkSafeMode);
	DDX_Control(pDX, IDC_chkNetwork, m_chkNetwork);
	DDX_Control(pDX, IDC_chkWarn, m_chkWarn);
	DDX_Control(pDX, IDC_chkTop, m_chkTop);
	DDX_Control(pDX, IDC_chkLogo, m_chkLogo);
	DDX_Control(pDX, IDC_chkGUI, m_chkGUI);
	DDX_Control(pDX, IDC_chkDualBoot, m_chkDualBoot);
	DDX_Control(pDX, IDC_chkDrvSpace, m_chkDrvSpace);
	DDX_Control(pDX, IDC_chkDoubleBuffer, m_chkDoubleBuffer);
	DDX_Control(pDX, IDC_chkDblSpace, m_chkDblSpace);
	DDX_Control(pDX, IDC_txtTimeout, m_txtTimeOut);
	DDX_Control(pDX, IDC_cmbDefault, m_cmbDefault);
	DDX_Text(pDX, IDC_txtTimeout, m_int_Timeout);
	DDV_MinMaxUInt(pDX, m_int_Timeout, 0, 32767);
	DDX_Text(pDX, IDC_txtDelay, m_int_Delay);
	DDV_MinMaxUInt(pDX, m_int_Delay, 0, 32767);
	DDX_Radio(pDX, IDC_chkDisable1, m_int_DisableLog);
	DDX_Radio(pDX, IDC_chkSystem1, m_int_SystemReg);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBootOptDlg, CDialog)
	//{{AFX_MSG_MAP(CBootOptDlg)
	ON_WM_CONTEXTMENU()
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_chkAlways, OnchkAlways)
	ON_BN_CLICKED(IDC_chkBootWin, OnchkBootWin)
	ON_BN_CLICKED(IDC_chkDblSpace, OnchkDblSpace)
	ON_BN_CLICKED(IDC_chkDoubleBuffer, OnchkDoubleBuffer)
	ON_BN_CLICKED(IDC_chkDrvSpace, OnchkDrvSpace)
	ON_BN_CLICKED(IDC_chkDualBoot, OnchkDualBoot)
	ON_BN_CLICKED(IDC_chkGUI, OnchkGUI)
	ON_BN_CLICKED(IDC_chkKeys, OnchkKeys)
	ON_BN_CLICKED(IDC_chkLogo, OnchkLogo)
	ON_BN_CLICKED(IDC_chkNetwork, OnchkNetwork)
	ON_BN_CLICKED(IDC_chkTop, OnchkTop)
	ON_BN_CLICKED(IDC_chkWarn, OnchkWarn)
	ON_CBN_SELENDOK(IDC_cmbDefault, OnSelendokcmbDefault)
	ON_EN_KILLFOCUS(IDC_txtDelay, OnKillfocustxtDelay)
	ON_EN_KILLFOCUS(IDC_txtTimeout, OnKillfocustxtTimeOut)
	ON_BN_CLICKED(IDC_cmdRestart, OncmdRestart)
	ON_BN_CLICKED(IDC_cmdApply, OncmdApply)
	ON_BN_CLICKED(IDC_chkSafeMode, OnchkSafeMode)
	ON_BN_CLICKED(IDC_cmdSaveProfile, OncmdSaveProfile)
	ON_BN_CLICKED(IDC_cmdDeleteProfile, OncmdDeleteProfile)
	ON_BN_CLICKED(IDC_chkDisable1, OnchkDisable1)
	ON_BN_CLICKED(IDC_chkSystem1, OnchkSystem1)
	ON_EN_CHANGE(IDC_txtDelay, OnChangetxtDelay)
	ON_EN_CHANGE(IDC_txtTimeout, OnChangetxtTimeout)
	ON_CBN_DROPDOWN(IDC_cmbProfile, OnDropdowncmbProfile)
	ON_BN_CLICKED(IDC_cmdFindProfile, OncmdFindProfile)
	ON_BN_CLICKED(IDC_cmdAbout, OncmdAbout)
	ON_CBN_SELENDOK(IDC_cmbProfile, OnSelendokcmbProfile)
	ON_BN_CLICKED(IDC_chkDisable2, OnchkDisable1)
	ON_BN_CLICKED(IDC_chkDisable3, OnchkDisable1)
	ON_BN_CLICKED(IDC_chkSystem2, OnchkSystem1)
	ON_BN_CLICKED(IDC_chkSystem3, OnchkSystem1)
	//}}AFX_MSG_MAP

// These macros activate the HELP_USING, HELP_FINDER, and CONTEXT_HELP messages.
// Note that they are placed outside the AFX_MSG_MAP block so that the Class
// Wizard doesn't get confused.
	ON_COMMAND(ID_HELP_USING, OnHelpUsing)		// OnHelpUsing is overridden.
	ON_COMMAND(ID_CONTEXT_HELP, OnContextHelp)	// OnContextHelp is overridden.
	ON_COMMAND(ID_HELP_FINDER, OnHelpFinder)	// OnHelpFinder is not.
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBootOptDlg message handlers

// First, the generic handlers provided by the App Wizard.
void CBootOptDlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

void CBootOptDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.
void CBootOptDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CBootOptDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// Next, the custom handlers.

// Called when user selects "What's this" from a context pop-up.
// I'm subverting the ID_HELP_USING message; it normally
// handles the "Help on Help" menu item, which this dialog doesn't have.
void CBootOptDlg::OnHelpUsing()
{	// Context ID's for popup help are shifted upwards by 0x40000 in MAKEHELP.BAT.
	WinHelp(popup_context + 0x40000, HELP_CONTEXTPOPUP);
}

// Called when user selects "Why is it disabled?" from a context pop-up.
// As with ID_HELP_USING, I'm subverting the ID_CONTEXT_HELP message,
// which is normally not supported in the CDialog base class
void CBootOptDlg::OnContextHelp()
{
	WinHelp(popup_context + 0x60000, HELP_CONTEXTPOPUP);
}

// Setting the shutdown flag prevents the dialog from getting
// "stuck" if one of the delay fields contains an illegal entry.
void CBootOptDlg::OnCancel()
{
	shut_down = TRUE;
	CDialog::OnCancel();
}

// OnInitDialog() is also provided by the App Wizard,
// but additional stuff is added to the basic code.
BOOL CBootOptDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);
	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

// Now we get into the custom code!
	if (Do_Initial_Setup())		// Attempt initial setup
	{							// If successful,
		shut_down = FALSE;		// initialize the flag used by the OnCancel() handler,
		Get_Profile_Names();	// spin up the Profile Names combo box,
		Synch_Profile_Name();	// and make sure the current selection matches.
	}
	else						// If setup fails,
		EndDialog(IDOK);		// shut down.
	return TRUE;				// Let focus default to first control in the tab order.
}

/////////////////////////
// We don't want the {Enter} key to terminate the dialog (default behavior for CDialog).
// Therefore, we override the OnOK member function and do not call the base class handler.
/////////////////////////
void CBootOptDlg::OnOK()
{
	int id;

	id = GetFocus()->GetDlgCtrlID();					// Which control had the focus?
	if (id == IDC_txtDelay || id == IDC_txtTimeout)		// If txtDelay or txtTimeout,
		if (UpdateData(TRUE))							// check their contents,
		{
			opt_data[BootDelay].setting = m_int_Delay;	// and store them if valid.
			opt_data[BootMenuDelay].setting = m_int_Timeout;
			Update_Profile_Selection();
		}
}

/////////////////////////////////
// Overriding PreTranslateMessage lets us intercept the {Esc} key
// so that it doesn't close the dialog (default behavior for the CDialog class).
/////////////////////////////////
BOOL CBootOptDlg::PreTranslateMessage(MSG* pMsg)
{
	const HWND target_wnd = pMsg->hwnd;	// Quick access to the handle of the active window.
	
	if (pMsg->message == WM_KEYDOWN)	// Is this a WM_KEYDOWN message?
	{
		if (pMsg->wParam == VK_ESCAPE)	// If so, was it the {Esc} key?
		{
			if (target_wnd == m_cmbProfile.m_hWnd)		// If Profile Name box is active
			{
				if (m_cmbProfile.GetDroppedState())		// and the list is open,
					m_cmbProfile.ShowDropDown(FALSE);	// close the list,
				return TRUE;							// and signal that message has been processed.
			}
			if (target_wnd == m_cmbDefault.m_hWnd)		// Same for the Menu Default box
			{
				if (m_cmbDefault.GetDroppedState())
					m_cmbDefault.ShowDropDown(FALSE);
				return TRUE;
			}
			if (target_wnd == m_txtDelay.m_hWnd)		// Boot delay text box?
				m_txtDelay.SetSel(0x0000FFFF);			// Cancel selection if so.
			else
				if (target_wnd == m_txtTimeOut.m_hWnd)	// Menu timeout text box?
					m_txtTimeOut.SetSel(0x0000FFFF);	// Cancel selection if so.
			return TRUE;	// Signal that the message has been handled.
		}
	}
	// Otherwise, pass the message along to the base class handler.
	return CDialog::PreTranslateMessage(pMsg);
}

//////////////////////////////////////////
// Context menu handler.
// Activated when user clicks the right mouse button over the main window.
// If mouse was pointing at a control, sets the context ID for that control
// then displays the context menu.
//////////////////////////////////////////
void CBootOptDlg::OnContextMenu(CWnd* pWnd, CPoint point)
{
	UINT context;
	CWnd * wnd;
	CPoint local(point);	// Make a copy of the point parameter.

	ScreenToClient(&local);	// Convert mouse position from screen to client area coordinates.
	// Get handle of the non-transparent control window (if any) the mouse pointer was over
	// Note that all of the dialog's static frames are transparent, otherwise
	// ChildWindowFromPoint might return the frame instead of a control within the frame.
	// If mouse wansn't over the dialog's client area,	nothing to do.
	if ((wnd = ChildWindowFromPoint(local, CWP_SKIPTRANSPARENT)) == NULL)
		return;
	if (!(context = wnd->GetDlgCtrlID()))		// Get ID of the control(if any) the mouse was over.
	{											// If no ID returned,
												// try again, including all windows in the search.
		if ((wnd = ChildWindowFromPoint(local, CWP_ALL)) == NULL)
			return;								// nothing to do if not pointing at any control.
		if (!(context = wnd->GetDlgCtrlID()))	// Get the ID of the control the mouse was pointing at.
			return;								// Nothing to do if not pointing at any control.
	}
	popup_context = context;		// Set context for "What's this" from the popup menu.
// This portion of this function was created by the Component Gallery.
	CMenu menu;
	VERIFY(menu.LoadMenu(CG_IDR_POPUP_BOOT_OPT_DLG));
	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);
// Custom code!
	if (!wnd->IsWindowEnabled())	// If the target window is disabled,
		pPopup->AppendMenu(MF_ENABLED, ID_CONTEXT_HELP, "Why is it &disabled?");	// Add an item to the menu.
// Component Gallery code again.
	CWnd* pWndPopupOwner = this;
	while (pWndPopupOwner->GetStyle() & WS_CHILD)
		pWndPopupOwner = pWndPopupOwner->GetParent();
	pPopup->TrackPopupMenu(TPM_CENTERALIGN | TPM_RIGHTBUTTON, point.x, point.y, pWndPopupOwner);
}

////////////////////////////////
// Check box handlers
////////////////////////////////
// Most of these handlers do essentially the same thing:
// Transfer the control's new setting to the global array,
// then update the Profile Name combo box selection.
///////////////////////////////

void CBootOptDlg::OnchkAlways()
{
	opt_data[BootMenu].setting = m_chkAlways.GetCheck();
	m_txtDelay.EnableWindow(!opt_data[BootMenu].setting);
	m_lblStartup.EnableWindow(!opt_data[BootMenu].setting);
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkBootWin()
{
	int setting;

	setting = (opt_data[BootWin].setting = m_chkBootWin.GetCheck());
	m_chkDualBoot.EnableWindow(setting);	// If booting DOS, disable the Win 95-only options.
	m_chkGUI.EnableWindow(setting);
	m_chkLogo.EnableWindow(setting);
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkDblSpace() 
{
	opt_data[DblSpace].setting = m_chkDblSpace.GetCheck();	
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkDoubleBuffer() 
{
	opt_data[DoubleBuffer].setting = m_chkDoubleBuffer.GetCheck();	
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkDrvSpace() 
{
	opt_data[DrvSpace].setting = m_chkDrvSpace.GetCheck();	
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkDualBoot() 
{
	int setting, which;

	setting = m_chkDualBoot.GetCheck();
	opt_data[BootMulti].setting = setting;	// When Dual Boot changes, so does the Startup Menu.
	which = m_cmbDefault.GetCurSel();		// Preserve the current setting
	Build_Menu_List();						// and rebuild the combo box list.
	if (!setting)								// If user has just disabled Dual Boot,
	{
		if (which == m_cmbDefault.GetCount())	// and their menu default was Original DOS version,
		{
			opt_data[BootMenuDefault].setting = 1;	// set the selection back to the Windows default.
			AfxMessageBox(MSG_DUAL_BOOT_GONE, MB_ICONINFORMATION);	// Let them know what happened.
			m_cmbDefault.SetFocus();	// Put focus on the combo box
		}
	}
	m_cmbDefault.SetCurSel(which);	// Make sure the proper menu item is selected.
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkGUI() 
{
	opt_data[BootGUI].setting = m_chkGUI.GetCheck();	
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkKeys() 
{
	int setting;

	setting = m_chkKeys.GetCheck();
	opt_data[BootKeys].setting = setting;
	// Enable/Disable controls that BootKeys= overrides.
	m_txtTimeOut.EnableWindow(setting);
	m_lblTimeout.EnableWindow(setting);
	m_txtDelay.EnableWindow(setting && !opt_data[BootMenu].setting);
	m_lblStartup.EnableWindow(setting && !opt_data[BootMenu].setting);
	m_chkAlways.EnableWindow(setting);
	m_chkNetwork.EnableWindow(setting);
	m_cmbDefault.EnableWindow(setting);
	m_lblSelection.EnableWindow(setting);
	m_chkDualBoot.EnableWindow(setting);
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkLogo() 
{
	opt_data[Logo].setting = m_chkLogo.GetCheck();	
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkNetwork() 
{
	// When Network= changes, the Startup Menu's contents change also.
	if (m_chkNetwork.GetCheck())
	{
		opt_data[Network].setting = 1;				// Turn Network= setting on.
		if (opt_data[BootMenuDefault].setting > 3)	// Adjust startup menu default setting.
			++opt_data[BootMenuDefault].setting;
	}
	else
	{
		opt_data[Network].setting = 0;				// Turn Network= off.
		if (opt_data[BootMenuDefault].setting > 3)	// Adjust menu default if it was 4 or above..
			--opt_data[BootMenuDefault].setting;
	}
	Build_Menu_List();								// Rebuild the Default Selection combo box.
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkSafeMode() 
{
	opt_data[BootSafe].setting = m_chkSafeMode.GetCheck();	
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkTop() 
{
	opt_data[LoadTop].setting = m_chkTop.GetCheck();	
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkWarn() 
{
	opt_data[BootWarn].setting = m_chkWarn.GetCheck();	
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkDisable1() 
{
	UpdateData(TRUE);
	opt_data[DisableLog].setting = m_int_DisableLog;
	Update_Profile_Selection();
}

void CBootOptDlg::OnchkSystem1() 
{
	UpdateData(TRUE);	
	opt_data[SystemReg].setting = m_int_SystemReg;
	Update_Profile_Selection();
}

//////////////////////////////
// Combo box handlers
//////////////////////////////
// I'm using the CBN_SELENDOK event to trap a control change instead of CBN_SELCHANGE.
// This prevents the combo box from firing change events if the list is open and the
// user arrows around to select an item. Instead, the change event is triggered only
// when the user selects an item, and allows PreTranslateMessage() to 
// intercept the {Esc} key and close the box without changing the selection.
// If you use CBN_SELCHANGE and the mouse pointer is over the list when the user
// presses {Esc}, the box selects the item the mouse was pointing to!
//////////////////////////////

// Default menu selection
void CBootOptDlg::OnSelendokcmbDefault() 
{
	opt_data[BootMenuDefault].setting = m_cmbDefault.GetCurSel() + 1;
	Update_Profile_Selection();
}

// Profile Name box.
void CBootOptDlg::OnDropdowncmbProfile() 
{
	// When the user opens the list, change the status message.
	m_lblStatus.SetWindowText("Select a profile to load or press {Esc} to cancel.");
}

void CBootOptDlg::OnSelendokcmbProfile() 
{
	CString scratch;
	int which;
	BOOL is_reload, not_reserved;

	which = m_cmbProfile.GetCurSel();		// Get the current selection.

	if ((which < 0) || 						// If no selection or
		(	(which == current_profile) &&	// the indicated selection is already loaded and
			(!dirty)))						// it hasn't changed,
		return;								// there's nothing to do.
	m_cmbProfile.GetLBText(which, scratch);	// Otherwise, get the selected string.
	is_reload = scratch.CompareNoCase("(Current file settings)") == 0;	// Set flags.
	not_reserved = (!is_reload) && (scratch.CompareNoCase("(Original)") != 0);
	m_cmdDeleteProfile.EnableWindow(not_reserved);	// Disable save/delete buttons for reserved profiles.
	if (is_reload)			// Did user select "(Current file settings)"?
	{
		if (Read_File())	// If so, try to read MSDOS.SYS.
		{
			if (file_paths_bad)		// If [Paths] settings aren't correct,
				Do_Path_Warning();	// display warning message.
			current_name = scratch;	// Adjust controls if successful.
			current_profile = which;
			Load_Controls();
			m_lblStatus.SetWindowText("Settings reloaded from MSDOS.SYS");
		}
		else
		{
			m_cmbProfile.SetCurSel(current_profile);	// If load failed, restore the listbox selection.
			m_lblStatus.SetWindowText("Unable to read MSDOS.SYS. Dialog settings remain unchanged.");
		}
	}
	else
	{
		if (Load_Profile(scratch))				// Try to load profile from Registry.
		{
			current_name = scratch;				// If successful, load dialog controls appropriately.
			current_profile = which;
			Load_Controls();
			scratch.Format("Profile '%s' loaded.", current_name);
			m_lblStatus.SetWindowText(scratch);
		}
		else
		{
			m_cmbProfile.SetCurSel(current_profile);	// Otherwise, restore the previous selection.
			m_lblStatus.SetWindowText("Profile load failed. Dialog settings remain unchanged.");
		}
	}
}

///////////////////////////////
// Edit box handlers
//////////////////////////////
void CBootOptDlg::OnChangetxtDelay() 
{
	Update_Profile_Selection();
}

void CBootOptDlg::OnKillfocustxtDelay() 
{
	if (!shut_down)										// Unless dialog is closing,
	{
		if (UpdateData(TRUE))							// make sure number is within range
		{
			opt_data[BootDelay].setting = m_int_Delay;	// and if so, store the setting.
			Update_Profile_Selection();
		}
	}
}

void CBootOptDlg::OnChangetxtTimeout() 
{
	Update_Profile_Selection();
}

void CBootOptDlg::OnKillfocustxtTimeOut() 
{
	if (!shut_down)
	{
		if (UpdateData(TRUE))
		{
			opt_data[BootMenuDelay].setting = m_int_Timeout;
			Update_Profile_Selection();
		}
	}
}

///////////////////////////////////
// Commmand button handlers.
///////////////////////////////////
void CBootOptDlg::OncmdAbout() 
{
	OnSysCommand(IDM_ABOUTBOX, NULL);	// Just issue the About Box command.
}

void CBootOptDlg::OncmdApply() 
{	// Give user a chance to cancel.
	if (AfxMessageBox(MSG_CONFIRM_REWRITE, MB_YESNO | MB_DEFBUTTON2) != IDYES)
	{
		m_lblStatus.SetWindowText("Rewrite of MDSOS.SYS cancelled.");
		return;
	}
	switch (Save_Settings())	// Try to rewrite MSDOS.SYS.
	{
	case SAVE_OK:
		if (!dirty && current_profile >= 0)	// If a profile is loaded and data hasn't changed,
		{	// Display appropriate message.
			m_lblStatus.SetWindowText("MSDOS.SYS rewritten using the displayed profile.");
		
			if (m_cmbProfile.GetCurSel() < 0)	// If edit field doesn't match the profile name,
				m_cmbProfile.SetCurSel(current_profile);	// update it.
		}
		else
		{	// Otherwise, force the "(Current file settings)" selection.
			current_name = "(Current file settings)";
			m_lblStatus.SetWindowText("MSDOS.SYS rewritten using current dialog settings.");
			Synch_Profile_Name();
		}
		Set_Button_Status();
		Copy_To_Last();
		break;
	case SAVE_FAIL_NO_ACCESS:
		m_lblStatus.SetWindowText("MSDOS.SYS not rewritten -- could not access the file.");
		break;
	case SAVE_FAIL_NO_BACKUP:
		m_lblStatus.SetWindowText("MSDOS.SYS not rewritten -- could not create backup file MSDOS.BKP.");
		break;
	case SAVE_FAIL_RESTORED:
		m_lblStatus.SetWindowText("Error writing to MSDOS.SYS -- original restored from backup.");
		break;
	case SAVE_FAIL_NOT_RESTORED:
		m_lblStatus.SetWindowText("Error writing to MSDOS.SYS -- unable to restore from backup.");
		break;
	case SAVE_FAIL_NOT_CREATED:
		m_lblStatus.SetWindowText("Rewrite failed -- MSDOS.SYS does not exist and could not be created.");
	}
}

void CBootOptDlg::OncmdRestart() 
{	// Give user a chance to bail out.
	if (AfxMessageBox(MSG_QUERY_RESTART, MB_ICONEXCLAMATION | MB_OKCANCEL | MB_DEFBUTTON2) != IDOK)
	{
		m_lblStatus.SetWindowText("Restart cancelled.");
		return;
	}
	ExitWindowsEx(EWX_LOGOFF | EWX_REBOOT, NULL);	// If user didn't cancel, restart Windows
	EndDialog(IDOK);								// and close the dialog.
}

void CBootOptDlg::OncmdSaveProfile() 
{
	CSaveAsDlg dlg;
	CString scratch, msg;
	int which;

	if (current_name.IsEmpty() ||	// Initialize the name for the Save Profile dialog.
		current_name.CompareNoCase("(Original)") == 0 ||
		current_name.CompareNoCase("(Current file settings)") == 0)
		dlg.m_strName = "";
	else
		dlg.m_strName = current_name;
	switch (dlg.DoModal())	// Launch the dialog.
	{
	case IDOK:
		break;
	case IDCANCEL:
		m_lblStatus.SetWindowText("Profile save cancelled.");
		return;
	default:	// Shouldn't happen, but just in case...
		m_lblStatus.SetWindowText("Unable to create the Save Profile dialog.");
		return;
	}
	scratch = dlg.m_strName;
	which = m_cmbProfile.FindStringExact(-1, scratch);
	if (which != CB_ERR)	// If name already exists,
	{
		m_cmbProfile.GetLBText(which, scratch);	// Match its case with the list box string
		AfxFormatString1(msg, MSG_CONFIRM_OVERWRITE, scratch);	// Prompt for confirmation
		if (AfxMessageBox(msg, MB_OKCANCEL | MB_ICONQUESTION | MB_DEFBUTTON2, MSG_CONFIRM_OVERWRITE) != IDOK)
		{	// Done unless user says "OK".
			m_lblStatus.SetWindowText("Profile save cancelled.");
			return;
		}
	}
	if (Save_Profile(scratch))	// Save the profile.
	{
		current_name = scratch;
		if (which == CB_ERR)	// If name was not already in use, add it to the list and select it.
			m_cmbProfile.SetCurSel(current_profile = m_cmbProfile.AddString(current_name));
		else					// Otherwise, just make sure it's selected.
			m_cmbProfile.SetCurSel(current_profile = which);
		m_cmdDeleteProfile.EnableWindow(TRUE);	// Make sure the Delete button is enabled.
		scratch.Format("Profile saved as '%s'", current_name);
		m_lblStatus.SetWindowText(scratch);
		Copy_To_Last();
	}
	else
	{	// Report error if save bombed.
		AfxMessageBox(MSG_SAVE_FAILED, MB_ICONEXCLAMATION);
		m_lblStatus.SetWindowText("Profile not saved.");
	}
}

void CBootOptDlg::OncmdDeleteProfile() 
{
	CString sub_key = "Software\\PC Magazine\\Boot Options\\1.0\\Profiles\\";
	CString msg;
	int which;

	which = m_cmbProfile.GetCurSel();				// Get index of current selection.
	AfxFormatString1(msg, MSG_CONFIRM_DEL, current_name);
	if (AfxMessageBox(msg, MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON2, MSG_CONFIRM_DEL) != IDYES)
	{
		m_lblStatus.SetWindowText("Profile delete cancelled.");
		return;
	}
	sub_key += current_name;						// Finish building the registry key name.
	if (RegDeleteKey(HKEY_CURRENT_USER, sub_key))	// Try to delete the key.
	{												// Report error if delete failed.
		AfxMessageBox(MSG_REGISTRY_ERROR, MB_ICONEXCLAMATION);
		m_lblStatus.SetWindowText("Profile not deleted.");
	}
	else
	{												// Otherwise, confirm deletion.
		msg.Format("Profile '%s' deleted.", current_name);
		m_lblStatus.SetWindowText(msg);
		m_cmbProfile.DeleteString(which);			// Delete string from list
		current_profile = -1;						// Reset current selection and profile name.
		current_name = "";
		m_cmdDeleteProfile.EnableWindow(FALSE);
		m_cmbProfile.SetFocus();
	}
}

void CBootOptDlg::OncmdFindProfile() 
{
	BOOL any_found = FALSE, original_found = FALSE;
	int i, j, old_settings[SettingCount], old_profile;
	int original_index, any_index, current_index;
	CString scratch, msg;

	old_profile = m_cmbProfile.GetCurSel();
	current_index = m_cmbProfile.FindStringExact(-1, "(Current file settings)");
	for (i = 0; i < SettingCount; old_settings[i] = opt_data[i].setting, i++);	// Make local copy of global data.
	for (i = 0; i < m_cmbProfile.GetCount(); i++)	// Loop through the list.
	{	// Skip if its the "(Current file settings)" entry or the profile that's already loaded.
		if (i == old_profile || i == current_index)
			continue;
		m_cmbProfile.GetLBText(i, scratch);	// Get the profile's name
		if (!Load_Profile(scratch))			// Quit if load fails.
			break;
		for (j = 0; j < SettingCount; j++)	// Compare to saved settings.
		{	// Break out of loop if any of the settings don't match.
			if (old_settings[j] != opt_data[j].setting)
				break;
		}
		if (j == SettingCount)				// Was there a match?
		{									// Was it the "(Original)" profile?
			if (scratch.CompareNoCase("(Original)") == 0)
			{								// If so, set flag,
				original_found = TRUE;
				original_index = i;			// save its position in the list, and keep looking.
			}
			else
			{	// Otherwise, signal that a profile _other_ than "(Original)" matched,
				any_found = TRUE;
				any_index = i;	// Save its index,
				break;			// and stop looking.
			}
		}
	}
	if (any_found || original_found)	// If profile was found,
	{
		Copy_To_Last();					// Set the new selection.
		current_profile = any_found ? 				   	// Use the "(Original)" selection
							any_index : original_index; // only if it was the only match.
		m_cmbProfile.SetCurSel(current_profile);
		m_cmbProfile.GetLBText(current_profile, current_name);
		msg.Format("Profile '%s' matches the current dialog settings.", current_name);
		m_lblStatus.SetWindowText(msg);
	}
	else
	{	// Otherwise, display error message.
		if (old_profile < 0 || old_profile == current_index)
		{
			AfxMessageBox(MSG_NO_MATCH, MB_ICONINFORMATION);
			m_lblStatus.SetWindowText("No matching profiles found.");
		}
		else
		{
			AfxMessageBox(MSG_NO_OTHER_MATCH, MB_ICONINFORMATION);
			m_lblStatus.SetWindowText("No other matching profiles found.");
		}
	}
	for (i = 0; i < SettingCount; opt_data[i].setting = old_settings[i], i++)	// Restore global data from local copy.
	Set_Button_Status();	// Make sure the dialog is in synch.
	m_cmbProfile.SetFocus();
}

// Helper functions
/////////////////////////////////
// Read MSDOS.SYS
// Returns FALSE is file is missing or inaccessible.
// Sets global file_paths_bad variable appropriately.
// Loads global opt_data[] array with [Options] settings.
// Note that this function does not access any of the Dialog controls
// since it may be called from CBootOptApp before the dialog is displayed.
////////////////////////////////
BOOL CBootOptDlg::Read_File(void)
{
	int i, x;
	HANDLE myfile;
	SECURITY_ATTRIBUTES sa = {sizeof(sa), NULL, FALSE};
	char buffer[MAX_PATH + 1];
	CString path_settings[3];

	myfile = CreateFile(sysfilename, 	// First, make sure the file exists.
						GENERIC_READ, FILE_SHARE_WRITE, &sa, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (myfile == INVALID_HANDLE_VALUE)
		return FALSE;	// If it doesn't, signal failure.
	CloseHandle(myfile);
	for (i = 0; i < 3; i++)	// Read the [Paths] section.
	{
		x = GetPrivateProfileString("Paths", path_keys[i], "**", buffer, 255, sysfilename);
		if ((buffer[0] != '*') && (buffer[1] != '*'))
		{
			buffer[x] = 0;
			path_settings[i] = buffer;
		}
		else
			path_settings[i].Empty();
	}
	file_paths_bad = ((path_settings[0][0] != win_host_drive) ||
						(win_directory.CompareNoCase(path_settings[1]) != 0) ||
						(win_directory.CompareNoCase(path_settings[2]) != 0));
	for (i = 0; i < SettingCount; i++)	// Then the [Options] section.
	{	// Read setting from file.
		x = GetPrivateProfileInt("Options", opt_data[i].name, -1, sysfilename);
		if (x < 0)										// If key was not specified,
		{
			opt_data[i].file = opt_data[i].sysdefault;	// Use the Windows default and
			opt_data[i].forced = FALSE;					// indicate that key wasn't present in the file.
		}
		else											// Otherwise,
		{
			if (x > opt_data[i].max)					// make sure it's within the legal range.
				x = opt_data[i].max;
			if (x < opt_data[i].min)
				x = opt_data[i].min;
			opt_data[i].file = x;						// Set the value from the file
			opt_data[i].forced = TRUE;					// and indicate that key was present.
		}
		opt_data[i].setting = opt_data[i].file;			// Match user settings with file settings.
	}
	if (opt_data[BootMenuDefault].forced)				// Handle special case for menu default.
	{
		if (opt_data[Network].setting == 0)				// make sure it's within range.
			if (opt_data[BootMenuDefault].setting == (opt_data[BootMulti].setting ? 8 : 7))
				--opt_data[BootMenuDefault].setting;
	}
	if (opt_data[DisableLog].forced)	// Handle special case for undocumented switches
		++opt_data[DisableLog].setting;
	if (opt_data[SystemReg].forced)
		++opt_data[SystemReg].setting;
	Copy_To_Last();	// Make copy of settings for later comparison
	return TRUE;	// Report success to caller.
}

////////////////////////////////////
// Load dialog controls from the global array.
////////////////////////////////////
void CBootOptDlg::Load_Controls(void)
{
	BOOL keys, menu, win;

	m_chkAlways.SetCheck(opt_data[BootMenu].setting);
	m_chkWarn.SetCheck(opt_data[BootWarn].setting);
	m_chkTop.SetCheck(opt_data[LoadTop].setting);
	m_chkSafeMode.SetCheck(opt_data[BootSafe].setting);
	m_chkNetwork.SetCheck(opt_data[Network].setting);
	m_chkLogo.SetCheck(opt_data[Logo].setting);
	m_chkKeys.SetCheck(opt_data[BootKeys].setting);
	m_chkGUI.SetCheck(opt_data[BootGUI].setting);
	m_chkDualBoot.SetCheck(opt_data[BootMulti].setting);
	m_chkDrvSpace.SetCheck(opt_data[DrvSpace].setting);
	m_chkDblSpace.SetCheck(opt_data[DblSpace].setting);
	m_chkDoubleBuffer.SetCheck(opt_data[DoubleBuffer].setting);
	m_chkBootWin.SetCheck(opt_data[BootWin].setting);
	m_int_Delay = opt_data[BootDelay].setting;
	m_int_Timeout = opt_data[BootMenuDelay].setting;
	m_int_SystemReg = opt_data[SystemReg].setting;
	m_int_DisableLog = opt_data[DisableLog].setting;
	UpdateData(FALSE);		// Update controls that use DDV transfer.
	Build_Menu_List();
	keys = opt_data[BootKeys].setting;
	menu = opt_data[BootMenu].setting;
	win = opt_data[BootWin].setting;
	m_chkAlways.EnableWindow(keys);
	m_txtDelay.EnableWindow(keys && !menu);
	m_lblStartup.EnableWindow(keys && !menu);
	m_txtTimeOut.EnableWindow(keys);
	m_lblTimeout.EnableWindow(keys);
	m_cmbDefault.EnableWindow(keys);
	m_lblSelection.EnableWindow(keys);
	m_chkDualBoot.EnableWindow(keys);
	m_chkNetwork.EnableWindow(keys);
	m_chkGUI.EnableWindow(win);
	m_chkLogo.EnableWindow(win);
	m_chkDualBoot.EnableWindow(win);
}

////////////////////////////////
// Build the selection list in the combo box
// and select the appropriate item
////////////////////////////////
void CBootOptDlg::Build_Menu_List(void)
{
	int menu_index = 4;
	CString scratch;

	m_cmbDefault.ResetContent();							// Zap the list box.
	m_cmbDefault.AddString("1. Normal");					// First three items are always the same.
	m_cmbDefault.AddString("2. Logged (\\BOOTLOG.TXT)");
	m_cmbDefault.AddString("3. Safe Mode");
	if (opt_data[Network].setting)							// If this item is present,
	{
		m_cmbDefault.AddString("4. Safe mode with network support");	// Add it to the list and update
		++ menu_index;													// the index for the remaining items.
	}
	scratch.Format("%1u. Step-by-step confirmation", menu_index++);
	m_cmbDefault.AddString(scratch);
	scratch.Format("%1u. Command prompt only", menu_index++);
	m_cmbDefault.AddString(scratch);
	scratch.Format("%1u. Safe mode command prompt only", menu_index++);
	m_cmbDefault.AddString(scratch);
	if (opt_data[BootMulti].setting)
	{
		scratch.Format("%1u. Previous version of MS-DOS", menu_index);
		m_cmbDefault.AddString(scratch);
	}
	m_cmbDefault.SetCurSel(opt_data[BootMenuDefault].setting - 1);
}

/////////////////////////////////////
// Writes current options to MSDOS.SYS.
// Returns one of the save_settings_status enumerated values (declared in BOOTOPT.H)
// If error occurs, displays an appropriate message box but does not update the m_lblStatus caption.
// This function may be called directly from CBootOptApp before the dialog is displayed,
// so why bother to update a control that isn't visible?
/////////////////////////////////////
int CBootOptDlg::Save_Settings(void)
{
	int i, value;
	DWORD old_attr, written;
	CString scratch, buffer;
	BOOL result, zap, file_exists;
	char padding[73], root_dir[4];
	HANDLE myfile;
 	SECURITY_ATTRIBUTES sa = {sizeof(sa), NULL, FALSE};
	LPTSTR dummy;

	for (i = 0; i < 3; i++)
		root_dir[i] = sysfilename[i];
	root_dir[3] = 0;
	file_exists = SearchPath(root_dir, "MSDOS", ".SYS", 73, padding, &dummy) != 0;
	if (file_exists)								// If file is present,
	{
		old_attr = GetFileAttributes(sysfilename);						// If it is, save its attributes
		if (!SetFileAttributes(sysfilename, FILE_ATTRIBUTE_ARCHIVE))	// Clear the attributes.
		{
			AfxMessageBox(MSG_NO_ACCESS, MB_ICONEXCLAMATION);			// Error if unable to do so.
			return SAVE_FAIL_NO_ACCESS;
		}
		if (!CopyFile(sysfilename, bakfilename, FALSE))			// Try to make a backup copy of the file.
		{
			AfxMessageBox(MSG_NO_BACKUP, MB_ICONEXCLAMATION);	// Report error and quit if unable to do so.
			return SAVE_FAIL_NO_BACKUP;
		}
		myfile = CreateFile(sysfilename, 	// zap the file to zero bytes.
							GENERIC_WRITE,
							0,
							&sa,
							TRUNCATE_EXISTING,
							FILE_ATTRIBUTE_NORMAL | FILE_FLAG_WRITE_THROUGH,
							NULL);
	}
	else									// If file doesn't exist,
	{
		myfile = CreateFile(sysfilename,	// try to create it.
							GENERIC_WRITE, 
							0, 
							&sa, 
							CREATE_ALWAYS, 
							FILE_ATTRIBUTE_NORMAL | FILE_FLAG_WRITE_THROUGH, 
							NULL);
		if (myfile == NULL)					// If creation fails, report the error.
		{
			AfxMessageBox(MSG_CREATE_FAIL, MB_ICONSTOP);
			return SAVE_FAIL_NOT_CREATED;
		}
	}
	// Build the [Paths] section of the file.
	buffer.Format("[Paths]\r\nHostWinBootDrv=%c\r\nWinBootDir=%s\r\nWinDir=%s\r\n\r\n",
					win_host_drive,
					win_directory,
					win_directory);
	// Build the [Options] section of the file.
	buffer += "[Options]\r\n";
	for (i = 0; i < SettingCount; i++)	// Determine whether write each key to the file
	{									// or skip it if the current setting matches the system default.
		value = opt_data[i].setting;
		switch (i)
		{
		case Network:			// Always force the Network= setting.
			zap = FALSE;
			break;
		case DisableLog:		// Special case for undocumented switches.
		case SystemReg:
			zap = opt_data[i].setting == 0;
			--value;
			break;
		default:
			zap = opt_data[i].setting == opt_data[i].sysdefault;
		}
		if (!zap)				// If the key is to be written,
		{
			scratch.Format("%s=%u\r\n", opt_data[i].name, value);	// append it to the buffer.
			buffer += scratch;
		}
	}

	buffer +=	"\r\n;\r\n;The following lines are required "	// Add the padding comments.
				"for compatibility with other programs.\r\n"
				";Do not remove them (MSDOS.SYS needs to be >1024 bytes).\r\n";
	for (i = 'a'; i <= 's'; i++)	// Append the padding comments to the buffer.
	{
		buffer += ";xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
		buffer += (TCHAR) i;
		buffer += "\r\n";
	}
	WriteFile(myfile, (LPCTSTR) buffer, buffer.GetLength(), &written, NULL);	// Write the buffer to the file.
	result = ((DWORD) buffer.GetLength() == written);
	CloseHandle(myfile);	// Close the file.
	if (!result)			// Try to clean up if any errors occurred.
	{
		scratch.Format("Error writing to %s.\n\n", sysfilename);
		if (file_exists)	// If the file already existed,
		{					// try to restore from the backup and report success or failure to the user.
			if (CopyFile(bakfilename, sysfilename, FALSE))
			{
				buffer.Format("%sFile was restored from %s.", scratch, bakfilename);
				result = SAVE_FAIL_RESTORED;
			}
			else
			{
				buffer.Format("%sUnable to restore file from backup", scratch);
				result = SAVE_FAIL_NOT_RESTORED;
			}	
		}
		else	// If the file didn't already exist,
		{
			buffer.Format("%sFile could not be created.");	// report the failure
			DeleteFile(sysfilename);						// and delete the partial file.
			result = SAVE_FAIL_NOT_CREATED;
		}
		AfxMessageBox((LPCTSTR) buffer, MB_ICONEXCLAMATION);	// Report error to user.
	}
	else
	{
		result = SAVE_OK;
		file_paths_bad = FALSE;
	}
	if (file_exists)	// If we didn't have to create the file, 
		SetFileAttributes(sysfilename, old_attr);	// restore its original attributes.
	return result;	// Back to caller.
}

/////////////////////////////////
// Saves current dialog settings in the Registry
// using the specified key name.
// Note: This function doesn't care if the key already exists.
// Checking for overwrites is taken care of before this is called.
/////////////////////////////////
BOOL CBootOptDlg::Save_Profile(LPCTSTR profile_name)
{
	HKEY base_key, profile_key;
	LONG reg_result;
	DWORD disposition;
	int i;
	DWORD key_data[SettingCount];

	// Open the "Profiles" key, creating it if necessary.
	reg_result = RegCreateKeyEx(HKEY_CURRENT_USER,
								"Software\\PC Magazine\\Boot Options\\1.0\\Profiles",
								0,
								NULL,
								REG_OPTION_NON_VOLATILE,
								KEY_ALL_ACCESS,
								NULL,
								&base_key,
								&disposition);
	if (reg_result)	// Done if error.
		return FALSE;
	// Create a subkey named after the profile, or open it if it's already there.
	reg_result = RegCreateKeyEx(base_key,
								profile_name,
								0,
								NULL,
								REG_OPTION_NON_VOLATILE,
								KEY_ALL_ACCESS,
								NULL,
								&profile_key,
								&disposition);

	RegCloseKey(base_key);	// Done with the "Profiles" key.
	if (reg_result)			// Done if error.
		return FALSE;
	for (i = 0; i < SettingCount; i++)	// Transfer numeric settings to local array.
		key_data[i] = opt_data[i].setting;
	reg_result = RegSetValueEx( profile_key, 	// Save numeric settings as binary data.
								"Options",
								0,
								REG_BINARY,
								(LPBYTE) key_data,
								sizeof(key_data));

	RegCloseKey(profile_key);			// Close the key.
	return reg_result == ERROR_SUCCESS;	// Report ultimate success or failure to caller.
}

////////////////////////////
// Reads the specified profile from the Registry.
// Returns FALSE if any of the Registry functions fail.
// Since this function may be called from CBootOptApp before the dialog is displayed,
// it does not alter any of the dialog's controls.
////////////////////////////
BOOL CBootOptDlg::Load_Profile(LPCTSTR profile_name)
{
	HKEY base_key, profile_key;
	LONG reg_result;
	int i;
	DWORD setting_buffer[SettingCount];
	DWORD data_size;

	if (RegOpenKeyEx(	HKEY_CURRENT_USER,	// Try to open the Profiles key.
						"Software\\PC Magazine\\Boot Options\\1.0\\Profiles",
						0,
						KEY_QUERY_VALUE,
						&base_key) != ERROR_SUCCESS)
		return FALSE;
	reg_result = RegOpenKeyEx(	base_key, 	// Open the key for the specified profile.
								profile_name, 0, KEY_QUERY_VALUE, &profile_key);
	RegCloseKey(base_key);
	if (reg_result)			// Report failure if unable to open the key.
		return FALSE;
	reg_result = RegQueryValueEx(profile_key, 	// Check the size of the data stored for the numeric settings.
					"Options" , 0, NULL, NULL, &data_size);
	if ( (reg_result != ERROR_SUCCESS) || (data_size != sizeof(setting_buffer)) )
	{
		RegCloseKey(profile_key);	// Report error if the function failed or data size is not an exact match.
		return FALSE;
	}
	reg_result = RegQueryValueEx(profile_key,	// Once data size has been verified, retrieve the data itself.
					"Options", 0, NULL, (LPBYTE) setting_buffer, &data_size);
	RegCloseKey(profile_key);
	if (reg_result)
		return FALSE;
	for (i = 0; i < SettingCount; i++)	// Transfer the setting data from temporary storage to the global arrays.
		opt_data[i].setting = setting_buffer[i];
	Copy_To_Last();	// Make a copy of the settings for later comparison.
	return TRUE;	// Indicate success
}
	
//////////////////////////////
// Reads the Registry and fills the ProfileName
// list box with the names of all profiles found.
// This function is only called once during initial setup,
// so we know that the Profile Name combo box is empty.
//////////////////////////////
void CBootOptDlg::Get_Profile_Names(void)
{
	HKEY base_key;
	LONG reg_result;
	int i = 0;
	char string_buffer[255];
	DWORD data_size;
	FILETIME last_write;

	if (RegOpenKeyEx(	HKEY_CURRENT_USER,	// Try to open the Profiles key.
						"Software\\PC Magazine\\Boot Options\\1.0\\Profiles",
						0,
						KEY_ENUMERATE_SUB_KEYS,
						&base_key) != ERROR_SUCCESS)
		return;
	while (TRUE)								// Loop through each profile.
	{
		data_size = sizeof(string_buffer);
		reg_result = RegEnumKeyEx(	base_key, 	// Read the next key name.
									i++,
									string_buffer,
									&data_size,
									0,
									NULL,
									NULL,
									&last_write);
		if (reg_result)							// Bail out if error,
			break;
		m_cmbProfile.AddString(string_buffer);	// otherwise add name to the list box.
	}
	RegCloseKey(base_key);
	if (reg_result != ERROR_NO_MORE_ITEMS)		// Report error if all entries were not read.
		AfxMessageBox(MSG_REGISTRY_BAD, MB_ICONEXCLAMATION);
	m_cmbProfile.AddString("(Current file settings)");	// Add the "(Current file settings)" reserved entry.
}

///////////////////////////////
// Checks the Profile Name combo box for string matching
// the current_name variable. Selects corresponding item if
// a match is found and updates current_profile to match the
// list entry's case.
///////////////////////////////
void CBootOptDlg::Synch_Profile_Name(void)
{
	int which;

	if (m_cmbProfile.GetCount() == 0)	// Nothing to do if list is empty.
		return;
	which = m_cmbProfile.FindStringExact(-1, current_name);	// See if string is already present in the list.
	if (which != CB_ERR)
	{
		m_cmbProfile.SetCurSel(which);					// If so, make sure it's highlighted.
		m_cmbProfile.GetLBText(which, current_name);	// And that current_name matches its case.
		current_profile = which;	// Disable delete button if it's one of the reserved entries.
		m_cmdDeleteProfile.EnableWindow((current_name.CompareNoCase("(Original)") != 0) &&
										(current_name.CompareNoCase("(Current file settings)") !=0));
	}
	else	// If not, disable the Delete button.
		m_cmdDeleteProfile.EnableWindow(FALSE);
}
///////////////////////////////////
// Handles the Profile Name status display.
// Called when any setting changes.
///////////////////////////////////
void CBootOptDlg::Update_Profile_Selection(void)
{

	if (Compare_To_Last())	// Compare current settings to last profile saved/loaded.
	{						// Don't display the status message if the selection didn't actually change.
		if (current_profile != m_cmbProfile.GetCurSel())
			m_lblStatus.SetWindowText("Settings match the displayed profile.");
		m_cmbProfile.SetCurSel(current_profile);	// Restore selection.
		Set_Button_Status();
		dirty = FALSE;
	}
	else
	{
		m_cmbProfile.SetCurSel(-1);				// Clear selection if not.
		m_cmdDeleteProfile.EnableWindow(FALSE);	// Disable Delete button.
		m_lblStatus.SetWindowText("Setting changed since last load or save.");
		dirty = TRUE;
	}
}

///////////////////////////////////
// Handles initial load of MSDOS.SYS and creation of (Original) profile, if necessary.
// Returns FALSE if program execution cannot continue.
// Specifically:
//	  -> MSDOS.SYS was corrupt and both the Paths and (Original) profile data could not be read
//       from the Registry.
//    -> Paths and (Original) profile keys did not exist and could not be created.
//    -> Settings in [Paths] section of MSDOS.SYS do not match the Paths Registry keys,
//		 user chose to update the Registry, and the update failed.
///////////////////////////////////
BOOL CBootOptDlg::Do_Initial_Setup(void)
{
	HKEY profile_key;
	BOOL load_failed, no_original;

	load_failed = !Read_File();	// Try to read MSDOS.SYS.
	no_original = RegOpenKeyEx(HKEY_CURRENT_USER,	// See if (Original) profile exists.
							  "Software\\PC Magazine\\Boot Options\\1.0\\Profiles\\(Original)",
							  0, KEY_ALL_ACCESS, &profile_key) != ERROR_SUCCESS;
	if (!no_original)	// Close Registry key if the profile was there.
		RegCloseKey(profile_key);
	if (load_failed)
	{	// MSDOS.SYS could not be read.
		AfxMessageBox(MSG_READ_FAIL, MB_ICONSTOP);
		if (no_original)
		{	// (Original) profile not present, cannot proceed.
			AfxMessageBox(MSG_NO_RECOVERY, MB_ICONSTOP);
			return FALSE;
		}
		else
		{	// Otherwise, try to load the original profile.
			if (Load_Profile("(Original)"))
			{	// If load succeeds, let the user know what's going on
				if (AfxMessageBox(MSG_EMERGENCY_RELOAD, MB_ICONQUESTION | MB_YESNO) == IDYES)
				{	// and ask if they want to try rewriting MSDOS.SYS using the (Original) profile.
					if (Save_Settings() == SAVE_OK)
						current_name = "(Current file settings)";
					else
						current_name = "(Original)";
				}
				Load_Controls();	// Initialize the dialog controls.
			}
			else
			{	// If load fails, there's nothing else we can do.
				AfxMessageBox(MSG_NO_RECOVERY, MB_ICONSTOP);
				return FALSE;
			}
		}
	}
	else
	{	// MSDOS.SYS was read successfully, so initialize the dialog controls.
		current_name = "(Current file settings)";
		Load_Controls();
		if (no_original)	// If (Original) profile doesn't yet exist, try to create it.
		{
			if (!Save_Profile("(Original)"))
			{
				AfxMessageBox(MSG_REGISTRY_ERROR, MB_ICONEXCLAMATION);
				return FALSE;
			}
		}
		if (file_paths_bad)		// If [Paths] settings weren't correct,
			Do_Path_Warning();	// display warning message.
	}
	return TRUE;
}

///////////////////////////
// Copies the current settings for later comparison
///////////////////////////
void CBootOptDlg::Copy_To_Last(void)
{
	int i;

	for (i = 0; i < SettingCount; last_loaded[i] = opt_data[i].setting, i++);
	dirty = FALSE;	// Clear "dirty data" flag.
}

/////////////////////////////
// Compares current settings to the last profile loaded or saved.
// Returns TRUE if they are the same
/////////////////////////////
BOOL CBootOptDlg::Compare_To_Last(void)
{
	int i;
	
	for (i = 0; i < SettingCount; i++)
	{
		if (last_loaded[i] != opt_data[i].setting)
			return FALSE;
	}
	return TRUE;
}

///////////////////////////////
// Enables or disables the Save and Delete command buttons
// based on the state of the Profile Name combo box.
///////////////////////////////
void CBootOptDlg::Set_Button_Status(void)
{
	CString scratch;
	int which;
	BOOL allow_save;

	m_cmbProfile.GetWindowText(scratch);	// Get the text
	scratch.TrimRight();
	scratch.TrimLeft();
	allow_save = ((scratch.CompareNoCase("(Original)") != 0) &&	// Set flag if name is neither empty nor one of the reserved names.
				  (scratch.CompareNoCase("(Current file settings)") != 0) &&
				  (scratch.GetLength() != 0));
	which = m_cmbProfile.FindStringExact(-1, scratch);	// See if the string already exists in the list.
	m_cmdDeleteProfile.EnableWindow((which != CB_ERR) && allow_save);	// Enable/disable Delete button appropriately.
}

//////////////////////////////////////
// Handle warning message when [Paths] settings in MSDOS.SYS are wrong.
void CBootOptDlg::Do_Path_Warning(void)
{
	CString msg1, msg2;

	msg1.Format("1. Windows 95 is installed in the %s folder.\n2. ", win_directory);
	if (win_drive_compressed)
		msg2.Format("The host for drive %c: is %c:", win_directory[0], win_host_drive);
	else
		msg2.Format("Drive %c: is not a compressed volume.", win_host_drive);
	msg1 += msg2;
	AfxFormatString1(msg2, MSG_PATHS_BAD, msg1);
	AfxMessageBox(msg2, MB_ICONINFORMATION, MSG_PATHS_BAD);
}
