// -[KeepHeading]-


// -[Copyright]-

/**
 * (c) Step Ahead Software Pty Ltd 1996. All rights reserved. Registered
 * users may use this applet in their web pages.
 */
import java.lang.*;


// -[KeepBeforeClass]-
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.FontMetrics;
import	java.awt.Image;
import java.applet.Applet;


// -[Class]-

/**
 * @jTitle           ImageApplet
 * @jAuthor          Chris Colman
 * @jOverridability  can be overridden
 * @jDescription
 * ImageApplet is a JAVA applet that demonstrates how to display an image
 * on the screen.
 * 
 * @see              Applet
 */
public 
class ImageApplet extends Applet
{
// -[KeepWithinClass]-


// -[Fields]-



/**
 * Image object.
 */
protected Image image;



/**
 * A string object containing the JAVelin text with a message.
 */
protected String javString= "Javelin (tm) - Reach for the sky!";



/**
 * Font used for central message.
 */
protected Font largeFont= new Font("TimesRoman",Font.BOLD,24);



// -[Methods]-

/**
 * Initializes the applet.
 */
public void init()
{
	resize(400, 400);
	image = getImage(getDocumentBase(), "backg.gif");
}




/**
 * Called whenever a window needs updating.
 */
public void paint(Graphics g)
{
	Rectangle r = bounds();

	g.drawImage(image, 0, 0, r.width, r.height, this);

	// Remember current font so that we can restore things back
	// to the way they were when finished
	Font oldFont = g.getFont();
	Color oldColor = g.getColor();

	g.setColor(Color.red);

	g.setFont(largeFont);
	FontMetrics fm = g.getFontMetrics();
	
	g.drawString(javString,
										 (r.width - fm.stringWidth(javString))/2,
										 (r.height - fm.getHeight())/2);

	g.setFont(oldFont);
	g.setColor(oldColor);
}
}
