// -[KeepHeading]-


// -[Copyright]-

/**
 * (c) Copyright 1993-1994. Step Ahead Software Pty Limited. All rights
 * reserved.
 */
import java.lang.*;


// -[KeepBeforeClass]-
import java.applet.*;
import java.awt.*;


// -[Class]-

/**
 * @jTitle           GraphicsApplet
 * @jOverridability  can be overridden
 * @jDescription
 * Main window of graphics application.
 * 
 * @see              Applet
 */
public 
class GraphicsApplet extends Applet
{
// -[KeepWithinClass]-


// -[Fields]-



/**
 * Name of the graphics application.
 */
protected String message= new String("Javelin - reach for the sky!");



/**
 * Font used to print message.
 */
protected Font messageFont= new Font("TimesRoman", Font.BOLD|Font.ITALIC, 24);

;


// -[Methods]-

/**
 * Called whenever the mouse button is pressed.
 */
public boolean mouseDown(Event evt, int x, int y)
{
	// Caused paint to be called
	repaint();

	return true;
}

/**
 * This function is called once at startup for the applet. Here you should
 * do any necessary initialization.
 */
public void init()
{
	resize(400, 300);
}

/**
 * Paints the applet window. At this stage it does nothing but in later
 * examples it does.
 */
public void paint(Graphics g)
{
	Rectangle r = bounds();

	Color oldColor = g.getColor();
	Font oldFont = g.getFont();

	// Paint a blue sky
	g.setColor(Color.blue);
	g.fillRect(0, 0, r.width, r.height);

	// Draw some shapes in random positions
	for (int i = 0; i < 10; i++)
	{
		Shape shape = new Circle(
			(int)(Math.random() * r.width),
			(int)(Math.random() * r.height),
			(int)(Math.random() * 30));

		shape.show(g);

		shape = new Box(
			(int)(Math.random() * r.width),
			(int)(Math.random() * r.height),
			(int)(Math.random() * 100),
			(int)(Math.random() * 40));

		shape.show(g);
	}

	g.setColor(Color.white);

	g.drawString("Click mouse to change scene", 10, 20);

	g.setFont(messageFont);

	g.drawString(message, 10, 50);
	
	g.setFont(oldFont);
	g.setColor(oldColor);
}

}


