VERSION 4.00
Begin VB.Form frmTCP 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Winsock TCP Sample"
   ClientHeight    =   7215
   ClientLeft      =   1140
   ClientTop       =   2265
   ClientWidth     =   12195
   Height          =   7620
   Left            =   1080
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7215
   ScaleWidth      =   12195
   ShowInTaskbar   =   0   'False
   Top             =   1920
   Width           =   12315
   Begin VB.CommandButton btnClear 
      Caption         =   "Clear"
      Height          =   375
      Left            =   4200
      TabIndex        =   34
      Top             =   2040
      Width           =   1215
   End
   Begin VB.CheckBox chkTestDataType 
      Caption         =   "Test different Data Type"
      Height          =   255
      Left            =   7080
      TabIndex        =   33
      Top             =   120
      Width           =   2175
   End
   Begin VB.TextBox txtTestRecv 
      Height          =   5775
      Left            =   9600
      MultiLine       =   -1  'True
      TabIndex        =   32
      Top             =   480
      Width           =   2415
   End
   Begin VB.TextBox txtClntRecv 
      Height          =   855
      Left            =   5760
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   26
      Top             =   1680
      Width           =   3615
   End
   Begin VB.TextBox txtSvrRecv 
      Height          =   975
      Left            =   5640
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   23
      Top             =   4320
      Width           =   3735
   End
   Begin VB.TextBox txtSend 
      Height          =   855
      Left            =   5760
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   4
      Text            =   "tcptst.frx":0000
      Top             =   480
      Width           =   3615
   End
   Begin VB.CommandButton btnSend 
      Caption         =   "Send"
      Enabled         =   0   'False
      Height          =   375
      Left            =   4200
      TabIndex        =   20
      Top             =   1080
      Width           =   1215
   End
   Begin VB.CommandButton btnCloseListen 
      Caption         =   "Close Listen"
      Enabled         =   0   'False
      Height          =   375
      Left            =   4080
      TabIndex        =   19
      Top             =   4560
      Width           =   1215
   End
   Begin VB.TextBox txtProgressSvr 
      BackColor       =   &H00C0C0C0&
      Height          =   375
      Left            =   0
      TabIndex        =   18
      Top             =   6720
      Width           =   9495
   End
   Begin VB.TextBox txtSvrStatus 
      Height          =   975
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   17
      Top             =   5760
      Width           =   9495
   End
   Begin VB.CommandButton btnListen 
      Caption         =   "Listen"
      Height          =   375
      Left            =   4080
      TabIndex        =   16
      Top             =   4080
      Width           =   1215
   End
   Begin VB.TextBox txtLocalPortSvr 
      Height          =   285
      Left            =   1560
      TabIndex        =   3
      Text            =   "7"
      Top             =   4800
      Width           =   2295
   End
   Begin VB.TextBox txtProgress 
      BackColor       =   &H00C0C0C0&
      Height          =   375
      Left            =   0
      TabIndex        =   13
      Top             =   3360
      Width           =   9495
   End
   Begin VB.CommandButton txtClose 
      Caption         =   "Close"
      Height          =   375
      Left            =   4200
      TabIndex        =   12
      Top             =   1560
      Width           =   1215
   End
   Begin VB.TextBox txtStatus 
      Height          =   375
      Left            =   0
      TabIndex        =   10
      Text            =   "Closed"
      Top             =   3000
      Width           =   9495
   End
   Begin VB.CommandButton btnConnect 
      Caption         =   "Connect"
      Height          =   375
      Left            =   4200
      TabIndex        =   9
      Top             =   600
      Width           =   1215
   End
   Begin VB.TextBox txtLocalPort 
      Height          =   285
      Left            =   1560
      TabIndex        =   2
      Text            =   "0"
      Top             =   1320
      Width           =   2295
   End
   Begin VB.TextBox txtRemotePort 
      Height          =   285
      Left            =   1560
      TabIndex        =   1
      Text            =   "7"
      Top             =   960
      Width           =   2295
   End
   Begin VB.TextBox txtRemoteHost 
      Height          =   285
      Left            =   1560
      TabIndex        =   0
      Text            =   "127.0.0.1"
      Top             =   600
      Width           =   2295
   End
   Begin WINSOCKLib.TCP TCPAccepted 
      Index           =   0
      Left            =   2640
      Top             =   3960
      _ExtentX        =   1058
      _ExtentY        =   1058
      RemoteHost      =   ""
      RemotePort      =   0
      LocalPort       =   0
   End
   Begin WINSOCKLib.TCP TCPSvr 
      Left            =   1680
      Top             =   3960
      _ExtentX        =   1058
      _ExtentY        =   1058
      RemoteHost      =   ""
      RemotePort      =   0
      LocalPort       =   0
   End
   Begin WINSOCKLib.TCP TCPClnt 
      Left            =   1920
      Top             =   0
      _ExtentX        =   1058
      _ExtentY        =   1058
      RemoteHost      =   ""
      RemotePort      =   0
      LocalPort       =   0
   End
   Begin VB.Label lblIncoming 
      Height          =   255
      Left            =   240
      TabIndex        =   35
      Top             =   5160
      Width           =   4455
   End
   Begin VB.Label lblReceivedBytes 
      Height          =   255
      Left            =   7080
      TabIndex        =   31
      Top             =   3960
      Width           =   1695
   End
   Begin VB.Label lblLocalIP2 
      Height          =   255
      Left            =   1560
      TabIndex        =   30
      Top             =   4440
      Width           =   2295
   End
   Begin VB.Label lblLocalIP1 
      Height          =   255
      Left            =   1560
      TabIndex        =   29
      Top             =   1680
      Width           =   2295
   End
   Begin VB.Label Label8 
      Caption         =   "RemoteHost    RemoteIP    RemotePort       =========      LocalHost    LocalIP    LocalPort   ========   Status"
      Height          =   255
      Left            =   120
      TabIndex        =   28
      Top             =   5520
      Width           =   9255
   End
   Begin VB.Label Label13 
      Caption         =   "Data received:"
      Height          =   255
      Left            =   5760
      TabIndex        =   27
      Top             =   1440
      Width           =   1815
   End
   Begin VB.Label Label12 
      Caption         =   "Data received:"
      Height          =   255
      Left            =   5640
      TabIndex        =   25
      Top             =   3960
      Width           =   1215
   End
   Begin VB.Label Label11 
      Caption         =   "Data to send:"
      Height          =   255
      Left            =   5760
      TabIndex        =   24
      Top             =   120
      Width           =   1095
   End
   Begin VB.Label Label10 
      Caption         =   "Server"
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   13.5
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   240
      TabIndex        =   22
      Top             =   3960
      Width           =   1215
   End
   Begin VB.Label Label9 
      Caption         =   "Client"
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   13.5
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   240
      TabIndex        =   21
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label Label7 
      Caption         =   "Local IP:"
      Height          =   255
      Left            =   240
      TabIndex        =   15
      Top             =   4440
      Width           =   1095
   End
   Begin VB.Label Label6 
      Caption         =   "Local Port:"
      Height          =   255
      Left            =   240
      TabIndex        =   14
      Top             =   4800
      Width           =   1095
   End
   Begin VB.Line Line1 
      BorderWidth     =   3
      X1              =   0
      X2              =   9480
      Y1              =   3840
      Y2              =   3840
   End
   Begin VB.Label Label5 
      Caption         =   "RemoteHost    RemoteIP    RemotePort       =========      LocalHost    LocalIP    LocalPort   ========   Status"
      Height          =   255
      Left            =   240
      TabIndex        =   11
      Top             =   2640
      Width           =   10095
   End
   Begin VB.Label Label4 
      Caption         =   "Local Port:"
      Height          =   255
      Left            =   240
      TabIndex        =   8
      Top             =   1320
      Width           =   1215
   End
   Begin VB.Label Label3 
      Caption         =   "Local IP:"
      Height          =   255
      Left            =   240
      TabIndex        =   7
      Top             =   1680
      Width           =   1095
   End
   Begin VB.Label Label2 
      Caption         =   "Remote Port:"
      Height          =   255
      Left            =   240
      TabIndex        =   6
      Top             =   960
      Width           =   1095
   End
   Begin VB.Label Label1 
      Caption         =   "Remote Host"
      Height          =   255
      Left            =   240
      TabIndex        =   5
      Top             =   600
      Width           =   1095
   End
End
Attribute VB_Name = "frmTCP"
Attribute VB_Creatable = False
Attribute VB_Exposed = False




Dim nAccepted As Integer
Dim IndexList() As Integer

Dim strformat As String
Dim numformat As String
Dim sepstr As String
Dim sectionstr As String

Dim fTestDataType As Integer

Dim totalSendLen As Long
Dim nSent As Long ' bytes sent
Sub RefreshStatus(ByVal strProgress As String)
    txtStatus = Format(TCPClnt.RemoteHost, strformat)
    txtStatus = txtStatus & sepstr & Format(TCPClnt.RemoteHostIP, strformat)
    txtStatus = txtStatus & sepstr & Format(TCPClnt.RemotePort, numformat)
    txtStatus = txtStatus & sectionstr & Format(TCPClnt.LocalHostName, strformat)
    txtStatus = txtStatus & sepstr & Format(TCPClnt.LocalIP, strformat)
    txtStatus = txtStatus & sepstr & Format(TCPClnt.LocalPort, numformat)
    txtStatus = txtStatus & sectionstr & Format(status(TCPClnt.State), strformat)
    
    txtProgress = strProgress
End Sub

Sub temptest()
Dim msgstr As String

    msgstr = ""
    Dim v As String
    TCPAccepted(Index).PeekData v
    msgstr = msgstr & v

    Dim s$
    TCPAccepted(Index).PeekData s$, vbString
    msgstr = msgstr & s$
    
    Dim vt
    TCPAccepted(Index).PeekData vt, vbString
    msgstr = msgstr & vt
        
    s$ = "abce"
    Dim vt2
    vt2 = s$
    TCPAccepted(Index).PeekData vt2
    msgstr = msgstr & vt2
    
    Dim s2$
    TCPAccepted(Index).PeekData s2$
    msgstr = msgstr & s2$
    
    Debug.Print msgstr
    

End Sub

Sub TestSend()
' For testing different data types
' no error checking here

    'test byte,
    TCPClnt.SendData CByte(70)
    
    'test integer
    TCPClnt.SendData CInt(101)
    'test long
    TCPClnt.SendData CLng(8765432)
    'test single
    TCPClnt.SendData CSng(5.6)
    'test double
    TCPClnt.SendData CDbl(6.123456)
    'test currency
    TCPClnt.SendData CCur(7000.54321)
    'test Date
    TCPClnt.SendData Date
    'test Boolean
    TCPClnt.SendData CBool(True)
    'test Error
    TCPClnt.SendData CVErr(345)
    ' test fixed size string
Dim fixstr As String * 30
    fixstr = "Fix string 30"
    TCPClnt.SendData fixstr
Dim ba(3) As Byte
    ' test byte array
    ba(0) = CByte(65)
    ba(1) = CByte(66)
    ba(2) = CByte(67)
    ba(3) = CByte(68)
    TCPClnt.SendData ba

    ' test user type
Dim myuser As MyUsertype
Dim mybyte As MyByteType

    myuser.fld1 = CDbl(98.778899)
    myuser.fld2 = CInt(101)
    
    LSet mybyte = myuser
    
    TCPClnt.SendData mybyte.bFld
    
    totalSendLen = totalSendLen + Len(fixstr) + LenB(myuser) + 4 + 41
End Sub



Sub TestRecv(ByVal Index As Integer)
' for testing differnt data types
' no error checking
' assume same app, data sent in received all at one time
    
Dim msg As String
Dim val As Variant

    'test byte
    TCPAccepted(Index).GetData val, vbByte
    msg = "Byte: " & CByte(val)

    'test integer
    TCPAccepted(Index).GetData val, vbInteger
    msg = msg & Chr(13) & Chr(10) & "Integer: " & val

    'test long
    TCPAccepted(Index).GetData val, vbLong
    msg = msg & Chr(13) & Chr(10) & "Long: " & val

    'test single
    TCPAccepted(Index).GetData val, vbSingle
    msg = msg & Chr(13) & Chr(10) & "Single: " & val

    'test double
    TCPAccepted(Index).GetData val, vbDouble
    msg = msg & Chr(13) & Chr(10) & "Double: " & val

    'test currency
    TCPAccepted(Index).GetData val, vbCurrency
    msg = msg & Chr(13) & Chr(10) & "Currency: " & val

    'test Date
    TCPAccepted(Index).GetData val, vbDate
    msg = msg & Chr(13) & Chr(10) & "Date: " & val

    'test Boolean
    TCPAccepted(Index).GetData val, vbBoolean
    msg = msg & Chr(13) & Chr(10) & "Boolean: " & val

    'test Error
    TCPAccepted(Index).GetData val, vbError
    msg = msg & Chr(13) & Chr(10) & "Error/SCODE: " & CStr(val)

    ' test fixed string
Dim fixstr As String * 30
    TCPAccepted(Index).GetData val, vbString, Len(fixstr)
    msg = msg & Chr(13) & Chr(10) & "Fix str: " & val

    ' test byte array
    TCPAccepted(Index).GetData val, vbArray + vbByte, 4

    msg = msg & Chr(13) & Chr(10) & "Byte array: " & val(0) & " " & val(1) _
            & " " & val(2) & " " & val(3)

    'test user define type
Dim myuser As MyUsertype
Dim mybyte As MyByteType

    TCPAccepted(Index).GetData val, vbArray + vbByte, Len(myuser)
    
Dim i As Integer
    For i = 0 To Len(myuser) - 1
       mybyte.bFld(i) = val(i)
    Next
    LSet myuser = mybyte
    msg = msg & Chr(13) & Chr(10) & "user type: " & myuser.fld1 & " " & myuser.fld2
    
    ' test string, use default
    TCPAccepted(Index).GetData val, vbString
    msg = msg & Chr(13) & Chr(10) & "String: " & val

    ' end testing different data types
    txtTestRecv = msg

End Sub



Sub RefreshSvrStatus(ByVal strProgress As String)
Dim NL As String

    NL = Chr(13) & Chr(10)

    txtSvrStatus = "Server:" & NL
    txtSvrStatus = txtSvrStatus & sectionstr & Format(TCPSvr.LocalHostName, strformat)
    txtSvrStatus = txtSvrStatus & sepstr & Format(TCPSvr.LocalIP, strformat)
    txtSvrStatus = txtSvrStatus & sepstr & Format(TCPSvr.LocalPort, numformat)
    txtSvrStatus = txtSvrStatus & sectionstr & Format(status(TCPSvr.State), strformat)

    ' display all accepted connections

    txtSvrStatus = txtSvrStatus & NL & "Accepted Connections: " & nAccepted
    If nAccepted > 0 Then
        For i = 0 To UBound(IndexList, 1)
            If (IndexList(i) = 1) Then
                txtSvrStatus = txtSvrStatus & NL & Format(TCPAccepted(i).RemoteHost, strformat)
                txtSvrStatus = txtSvrStatus & sepstr & Format(TCPAccepted(i).RemoteHostIP, strformat)
                txtSvrStatus = txtSvrStatus & sepstr & Format(TCPAccepted(i).RemotePort, numformat)
                txtSvrStatus = txtSvrStatus & sectionstr & Format(TCPAccepted(i).LocalHostName, strformat)
                txtSvrStatus = txtSvrStatus & sepstr & Format(TCPAccepted(i).LocalIP, strformat)
                txtSvrStatus = txtSvrStatus & sepstr & Format(TCPAccepted(i).LocalPort, numformat)
                txtSvrStatus = txtSvrStatus & sectionstr & Format(status(TCPAccepted(i).State), strformat)
'                txtSvrStatus = txtSvrStatus & sepstr & Format(TCPAccepted(i).BytesToBeSent, numformat)
'                txtSvrStatus = txtSvrStatus & sepstr & Format(TCPAccepted(i).BytesReceived, numformat)
            End If
        Next
    End If
    
    txtProgressSvr = strProgress

End Sub



Private Sub btnClear_Click()
    txtClntRecv = ""
    txtSvrRecv = ""
    txtTestRecv = ""
End Sub

Private Sub btnCloseListen_Click()
    TCPSvr.Close
    RefreshSvrStatus ("Server stopped listening")
    btnListen.Enabled = True
    btnCloseListen.Enabled = False
End Sub

Private Sub btnConnect_Click()
    TCPClnt.RemoteHost = txtRemoteHost
    TCPClnt.RemotePort = txtRemotePort
    TCPClnt.LocalPort = txtLocalPort

    On Error Resume Next
    TCPClnt.Connect
    If (Err.Number = 0) Then
        btnConnect.Enabled = False
        RefreshStatus ("Initiated connect: Successful")
    Else
        RefreshStatus ("Initiated connect: " & Err.Number & " " & Err.Description)
    End If

End Sub



Private Sub btnListen_Click()

    TCPSvr.LocalPort = txtLocalPortSvr
    On Error Resume Next
    TCPSvr.Listen
    If (Err.Number = 0) Then
        btnListen.Enabled = False
        btnCloseListen.Enabled = True
        RefreshSvrStatus ("Started Listening - Successful")
    Else
        RefreshSvrStatus ("Started Listening - " & Err.Number & " " & Err.Description)
    End If
    
End Sub

Private Sub btnSend_Click()
    totalSendLen = 0

' For testing different data types
    If (fTestDataType = 1) Then
        TestSend
    End If
    On Error Resume Next
    ' send string
    nSent = 0
    TCPClnt.SendData txtSend
    If Err.Number <> 0 Then
        RefreshStatus ("Send data: " & Err.Number & " " & Err.Description)
    Else
        totalSendLen = totalSendLen + Len(txtSend.Text)
        RefreshStatus ("Submitted: " & totalSendLen & " bytes")
    End If

End Sub

Private Sub chkTestDataType_Click()
    fTestDataType = chkTestDataType
    If (fTestDataType = 0) Then
        frmTCP.Width = txtSvrStatus.Width + ((txtTestRecv.Left - txtSvrStatus.Width) * 2)
    Else
        frmTCP.Width = txtSvrStatus.Width + txtTestRecv.Width + ((txtTestRecv.Left - txtSvrStatus.Width) * 2)
    End If
    
End Sub



Private Sub Form_Load()
    ReDim IndexList(0)
    IndexList(0) = 0
    nAccepted = 0
    txtLocalPortSvr.SelLength = Len(txtLocalPortSvr)
    strformat = "!@@@@@@@@@@@@@@@"  '15
    numformat = "#########0" '10
    sepstr = "  "  ' seperation string 3
    sectionstr = "   ========   "
    
    ' temporary
    status(0) = "Close"
    status(1) = "Open"
    status(2) = "Listening"
    status(3) = "Connection pending"
    status(4) = "Resolving host"
    status(5) = "Host resolved"
    status(6) = "Connecting"
    status(7) = "Connected"
    status(8) = "peer is closing connection"
    status(9) = "Error"

    lblLocalIP1 = TCPClnt.LocalIP
    lblLocalIP2 = TCPSvr.LocalIP
    
    ' whether to test different data types 1/0 Test/NoTest
    ' when testing different data types - assume same app, data sent in received all at one time
    fTestDataType = 0
    If (fTestDataType = 0) Then
        frmTCP.Width = txtSvrStatus.Width + ((txtTestRecv.Left - txtSvrStatus.Width) * 2)
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
Dim i
    ' just in case user didn't click on close
    TCPClnt.Close
    TCPSvr.Close

    For i = 0 To UBound(IndexList, 1)
        If IndexList(i) = 1 Then
            TCPAccepted(i).Close
        End If
        ' unload controls that are loaded at runtime
        If (i <> 0) Then Unload TCPAccepted(i)
    Next
    
End Sub


Private Sub TCPAccepted_Error(Index As Integer, Number As Integer, Description As String, Scode As Long, Source As String, HelpFile As String, HelpContext As Long, CancelDisplay As Boolean)
    CancelDisplay = True
    TCPAccepted(Index).Close
    nAccepted = nAccepted - 1
    IndexList(Index) = 0
    RefreshSvrStatus (Number & Description)

End Sub

Private Sub TCPAccepted_Close(Index As Integer)
    TCPAccepted(Index).Close
    nAccepted = nAccepted - 1
    IndexList(Index) = 0
    RefreshSvrStatus ("Accepted connection is closed by peer")
End Sub

Private Sub TCPAccepted_Connect(Index As Integer)
    MsgBox "Should never get this event for this accepted object"
End Sub



Private Sub TCPAccepted_ConnectionRequest(Index As Integer, ByVal lRequestID As Long)
    MsgBox "Should never get this event for this accepted object"
End Sub


Private Sub TCPAccepted_DataArrival(Index As Integer, ByVal lBytesTotal As Long)
Dim val As Variant
Dim i As Integer

    ' Receive data as binary
' For testing different data types

    On Error Resume Next
    If (fTestDataType = 1) Then
        TCPAccepted(Index).PeekData val, vbArray + vbByte, lBytesTotal
    Else
        TCPAccepted(Index).GetData val, vbArray + vbByte, lBytesTotal
    End If
    
    If (Err.Number <> 0) Then  'error
        RefreshSvrStatus (Err.Number & " " & Err.Description)
    Else
        lblReceivedBytes = lBytesTotal & "  bytes"
        ' Display binary data
        For i = 0 To UBound(val)
            txtSvrRecv = txtSvrRecv & Chr(val(i))
        Next
        ' echo back
        TCPAccepted(Index).SendData CVar(val)
        If (Err.Number <> 0) Then
            RefreshSvrStatus ("Received " & lBytesTotal & "  bytes, echo back failed: " & Err.Number & " " & Err.Description)
        Else
            RefreshSvrStatus ("Received " & lBytesTotal & "  bytes, Echoed back " & lBytesTotal & " bytes.")
        End If
    End If

' For testing different data types
    If (fTestDataType = 1) Then
       TestRecv (Index)
    End If
End Sub

Private Sub TCPClnt_Error(Number As Integer, Description As String, Scode As Long, Source As String, HelpFile As String, HelpContext As Long, CancelDisplay As Boolean)
    CancelDisplay = True
    TCPClnt.Close
    RefreshStatus (Number & Description)
    btnConnect.Enabled = True

End Sub

Private Sub TCPClnt_Close()
    ' server initiate the close
    TCPClnt.Close
    RefreshStatus ("Connection close by peer")
    btnSend.Enabled = False
    btnConnect.Enabled = True
End Sub

Private Sub TCPClnt_Connect()
    RefreshStatus ("Connected")
    btnSend.Enabled = True
End Sub


Private Sub TCPClnt_ConnectionRequest(ByVal lRequestID As Long)
    MsgBox "Should never get this event for client"
End Sub


Private Sub TCPClnt_DataArrival(ByVal lBytesTotal As Long)
Dim val As Variant
Dim i As Integer

    On Error Resume Next
    ' Receive data as binary
    TCPClnt.GetData val, vbArray + vbByte, lBytesTotal

    If (Err.Number <> 0) Then  'error
        RefreshStatus (txtProgress & "  new data arrived, receive failed: " & Err.Number & " " & Err.Description)
    Else
        ' Display binary data
        For i = 0 To UBound(val)
            txtClntRecv = txtClntRecv & Chr(val(i))
        Next
        RefreshStatus (txtProgress & "  Received " & lBytesTotal & "  bytes")
    End If

End Sub


Private Sub TCPClnt_SendComplete()
    txtProgress = txtProgress & " Send complete."
End Sub

Private Sub TCPClnt_SendProgress(ByVal bytesSent As Long, ByVal bytesRemaining As Long)
    nSent = nSent + bytesSent
    txtProgress = txtProgress & " Sent: " & nSent
End Sub

Private Sub TCPSvr_Error(Number As Integer, Description As String, Scode As Long, Source As String, HelpFile As String, HelpContext As Long, CancelDisplay As Boolean)
    CancelDisplay = True
    TCPSvr.Close
    RefreshSvrStatus (Number & Description)
End Sub

Private Sub TCPSvr_Close()
    MsgBox "Should never get this event for server"
End Sub

Private Sub TCPSvr_Connect()
    MsgBox "Should never get this event for server"
End Sub



Private Sub TCPSvr_ConnectionRequest(ByVal lRequestID As Long)

    lblIncoming = "New incoming connection from " & TCPSvr.RemoteHostIP _
                & " Port: " & TCPSvr.RemotePort
    
    ' find a control, or load a new one
    For Index = 0 To UBound(IndexList, 1)
        If IndexList(Index) = 0 Then
            Exit For
        End If
    Next
    
    If Index > UBound(IndexList, 1) Then
        ReDim Preserve IndexList(Index)
        IndexList(Index) = 0
        Load TCPAccepted(Index)
    End If
    
    On Error Resume Next
    TCPAccepted(Index).Accept (lRequestID)
    If (Err.Number = 0) Then
        nAccepted = nAccepted + 1
        IndexList(Index) = 1
        RefreshSvrStatus ("Accept new connection: Successful")
    Else
        RefreshSvrStatus ("Accept new connection: " & Err.Number & " " & Err.Description)
    End If
outofhere:
End Sub


Private Sub TCPSvr_DataArrival(ByVal lBytesTotal As Long)
    MsgBox "Should never get this event for server"
End Sub



Private Sub TCP1_Error(Number As Integer, Description As String, Scode As Long, Source As String, HelpFile As String, HelpContext As Long, CancelDisplay As Boolean)

End Sub

Private Sub txtClose_Click()
    TCPClnt.Close
    RefreshStatus ("Closed")
    btnSend.Enabled = False
    btnConnect.Enabled = True
End Sub



Private Sub txtLocalPortSvr_Change()
    txtRemotePort = txtLocalPortSvr
End Sub


