VERSION 4.00
Begin VB.Form MainForm 
   Caption         =   "NetManage SMTP Client Control Sample"
   ClientHeight    =   4170
   ClientLeft      =   2220
   ClientTop       =   4200
   ClientWidth     =   7770
   Height          =   4860
   Left            =   2160
   ScaleHeight     =   4170
   ScaleWidth      =   7770
   Top             =   3570
   Width           =   7890
   Begin VB.Frame Frame2 
      Caption         =   "Low Level Commands"
      Height          =   1815
      Left            =   4080
      TabIndex        =   15
      Top             =   0
      Width           =   3495
      Begin VB.CommandButton btnQuit 
         Caption         =   "&Quit"
         Height          =   375
         Left            =   1560
         TabIndex        =   19
         Top             =   360
         Width           =   1215
      End
      Begin VB.CommandButton btnConnect 
         Caption         =   "&Connect"
         Height          =   375
         Left            =   240
         TabIndex        =   18
         Top             =   360
         Width           =   1095
      End
      Begin VB.TextBox txtParam 
         Height          =   285
         Left            =   120
         TabIndex        =   17
         Text            =   "netpp_users"
         Top             =   1320
         Width           =   1215
      End
      Begin VB.Label Label7 
         Caption         =   "Command Parameters"
         Height          =   255
         Left            =   120
         TabIndex        =   16
         Top             =   960
         Width           =   1695
      End
   End
   Begin VB.ListBox OriginatorList 
      Height          =   255
      ItemData        =   "smtpcmd.frx":0000
      Left            =   2160
      List            =   "smtpcmd.frx":0002
      TabIndex        =   6
      Top             =   120
      Width           =   1575
   End
   Begin VB.TextBox SubjectField 
      Height          =   285
      Left            =   840
      TabIndex        =   4
      Text            =   "test subject"
      Top             =   1560
      Width           =   2895
   End
   Begin VB.ListBox RecipientList 
      Height          =   255
      ItemData        =   "smtpcmd.frx":0004
      Left            =   2160
      List            =   "smtpcmd.frx":0006
      TabIndex        =   7
      Top             =   600
      Width           =   1575
   End
   Begin VB.ComboBox CCField 
      Height          =   315
      Left            =   840
      TabIndex        =   3
      Top             =   1080
      Width           =   2895
   End
   Begin VB.ComboBox ToField 
      Height          =   315
      Left            =   840
      TabIndex        =   2
      Text            =   "peterm"
      Top             =   600
      Width           =   1215
   End
   Begin VB.ComboBox FromField 
      Height          =   315
      Left            =   840
      TabIndex        =   1
      Text            =   "TestSender"
      Top             =   120
      Width           =   1215
   End
   Begin VB.Frame Frame1 
      Height          =   495
      Left            =   840
      TabIndex        =   10
      Top             =   2760
      Width           =   3015
      Begin VB.TextBox ServerField 
         Height          =   285
         Left            =   840
         TabIndex        =   8
         Top             =   120
         Width           =   2055
      End
      Begin VB.Label Label9 
         Caption         =   "Server:"
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   120
         Width           =   735
      End
   End
   Begin VB.TextBox BodyField 
      Height          =   735
      Left            =   840
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   5
      Text            =   "smtpcmd.frx":0008
      Top             =   2040
      Width           =   3015
   End
   Begin ComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   300
      Left            =   0
      TabIndex        =   20
      Top             =   3870
      Width           =   7770
      _Version        =   65536
      _ExtentX        =   13705
      _ExtentY        =   529
      _StockProps     =   68
      AlignSet        =   -1  'True
      SimpleText      =   ""
      NumPanels       =   3
      i1              =   "smtpcmd.frx":001B
      i2              =   "smtpcmd.frx":00E8
      i3              =   "smtpcmd.frx":01B5
   End
   Begin SMTPCTLib.SMTP smtpct1 
      Left            =   0
      Top             =   360
      _ExtentX        =   635
      _ExtentY        =   635
      RemoteHost      =   "mail"
      RemotePort      =   25
      ConnectTimeout  =   0
      RecvTimeout     =   0
      NotificationMode=   0
   End
   Begin RichtextLib.RichTextBox RichTextBox1 
      Height          =   1935
      Left            =   4080
      TabIndex        =   14
      Top             =   1920
      Width           =   3495
      _Version        =   65536
      _ExtentX        =   6165
      _ExtentY        =   3413
      _StockProps     =   69
      BackColor       =   -2147483643
      ScrollBars      =   2
      TextRTF         =   $"smtpcmd.frx":0282
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "CC:"
      Height          =   375
      Left            =   0
      TabIndex        =   13
      Top             =   1080
      Width           =   735
   End
   Begin VB.Label Label8 
      Alignment       =   1  'Right Justify
      Caption         =   "Subject:"
      Height          =   375
      Left            =   0
      TabIndex        =   11
      Top             =   1560
      Width           =   735
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "To:"
      Height          =   255
      Left            =   240
      TabIndex        =   9
      Top             =   600
      Width           =   495
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "From:"
      Height          =   255
      Left            =   0
      TabIndex        =   0
      Top             =   120
      Width           =   735
   End
   Begin VB.Menu File 
      Caption         =   "File"
      Begin VB.Menu FileExit 
         Caption         =   "Exit"
      End
   End
   Begin VB.Menu Edit 
      Caption         =   "Edit"
      Begin VB.Menu EditClearForm 
         Caption         =   "Clear Form"
      End
   End
   Begin VB.Menu Send 
      Caption         =   "Send"
      Begin VB.Menu SendMethod 
         Caption         =   "SendDoc"
      End
   End
   Begin VB.Menu Execute 
      Caption         =   "Execute"
      Begin VB.Menu Reset 
         Caption         =   "&Reset"
      End
      Begin VB.Menu Verify 
         Caption         =   "&Verify"
      End
      Begin VB.Menu Expand 
         Caption         =   "&Expand"
      End
      Begin VB.Menu Help 
         Caption         =   "&Help"
      End
      Begin VB.Menu Quit 
         Caption         =   "&Quit"
      End
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_Creatable = False
Attribute VB_Exposed = False



Private inputDocStmState As String
Private dataToSend As Boolean
Private articleData As Variant





Sub InitHeaders()

    Smtpct1.DocInput.Headers.Clear

    InitHeader FromField, "From"
    InitHeader ToField, "To"
    InitHeader CCField, "CC"
    Smtpct1.DocInput.Headers.Add "Subject", SubjectField.Text
    
    'Smtpct1.DocInput.headers.Add "X-Priority", " 3 (Normal)"
    'Smtpct1.DocInput.headers.Add "X-Mailer", "Chameleon B95_21, TCP/IP for Windows, NetManage Inc."
    Smtpct1.DocInput.Headers.Add "Message-Id", "<NNTPCT." & Date & ".rick.jesse@rickport.netmanage.com>"
    Smtpct1.DocInput.Headers.Add "Content-Type", "TEXT/PLAIN; charset=US-ASCII"
    Smtpct1.DocInput.Headers.Add "Content-Length", " " & Len(mailMsg) + 2
    
End Sub

Sub InitHeader(combo As ComboBox, headerAttr As String) '

    For I = 0 To combo.ListCount - 1
        Smtpct1.DocInput.Headers.Add headerAttr, combo.List(I)
    Next I
    
End Sub


'
Sub AddHeaderItem(combo As ComboBox, attr As String)
        combo.AddItem combo.Text
        
        If attr = "From" Then
            OriginatorList.AddItem attr & ": " & combo.Text
        Else
            RecipientList.AddItem attr & ": " & combo.Text
        End If
        
        combo.Text = ""
End Sub


Sub PrintEventMsg(msg As String)

    RichTextBox1.Text = RichTextBox1.Text & vbCrLf & msg
    RichTextBox1.SelStart = 128000
End Sub


Sub UpdateProperties()
    'TimeoutField.Text = Smtpct1.Timeout
    ServerField.Text = Smtpct1.RemoteHost
End Sub

'
'
'
Sub SendArticleData()

        ' stream data to nntpct control
        
        While DocStream1.Outputs(0).TargetIsReady And dataToSend
            DocStream1.Outputs(0).ProcessData (articleData)
            dataToSend = False 'just send one block of data for now
        Wend
    
        ' are we finished sending data?
        If Not dataToSend Then
        
            If DocStream1.Outputs(0).TargetIsReady Then
                DocStream1.Outputs(0).EndData
                inputDocStmState = "none"
            Else 'else will wait to OnTargetReady is called again
                inputDocStmState = "end"
            End If
            
        End If
End Sub





Function ValidateFields() As Boolean

    ValidateFields = False
    
    If ServerField.Text = "" Then
        MsgBox "Please enter you mail server name", 48
    ElseIf FromField.ListCount = 0 Then
        MsgBox "Please enter your mail address in the 'From:' list.", 48
    ElseIf ToField.ListCount = 0 Then
        MsgBox "Please enter a recipient's mail address in the 'To:' list.", 48
    Else
        ValidateFields = True
    End If
    
End Function

Private Sub btnConnect_Click()
Smtpct1.Connect
End Sub

Private Sub btnQuit_Click()
Smtpct1.Quit
End Sub


Private Sub CCField_KeyUp(KeyCode As Integer, Shift As Integer)
    If KeyCode = vbKeyReturn Then
        AddHeaderItem CCField, "CC"
    End If

End Sub


Private Sub DocStream1_OnTargetCancel(ByVal outputItem As DocOutput)
    inputDocStmState = "none"
    MsgBox "Send mail operation canceled by target.", 48
End Sub

Private Sub DocStream1_OnTargetReady(ByVal outputItem As DocOutput)
                
    Debug.Print "OnTargetReady:" & intputDocStmState
      
    Select Case inputDocStmState
    
    Case "begin"
    
        DocStream1.Outputs(0).BeginData
        
        ' set up state variables
        
        If inputDocStmState = "begin" Then
            inputDocStmState = "process"
            dataToSend = True
    
            If BodyField.Text = "" Then
                articleData = ""
            Else
                articleData = MainForm.BodyField.Text
            End If
        
            SendArticleData
        End If
            
    Case "process"
    
        SendArticleData
    
    Case "end"
    
        DocStream1.Outputs(0).EndData
        inputDocStmState = "none"

    End Select

End Sub



Private Sub CCField_LostFocus()
    If (Not CCField.Text = "") Then
        AddHeaderItem CCField, "CC"
    End If


End Sub

Private Sub Command1_Click()
Smtpct1.Expand expandList
End Sub

Private Sub Command2_Click()
Smtpct1.Connect "engdns.bandley1.netmanage.com"
End Sub

Private Sub EditClearForm_Click()
    FromField.Clear
    ToField.Clear
    CCField.Clear
    SubjectField.Text = ""
    BodyField.Text = ""
    OriginatorList.Clear
    RecipientList.Clear
    
End Sub

Private Sub Expand_Click()
Smtpct1.Expand txtParam.Text
End Sub

Private Sub FileExit_Click()
    Unload MainForm
End Sub

Private Sub Form_Load()

    Smtpct1.RemoteHost = "engdns.bandley1.netmanage.com"
    UpdateProperties
    
End Sub











Private Sub FromField_KeyUp(KeyCode As Integer, Shift As Integer)
    
    If KeyCode = vbKeyReturn Then
        AddHeaderItem FromField, "From"
    End If
    
End Sub


Private Sub SendDocStream_Click()

    If ValidateFields Then

        Dim h As Object
        Set h = DocStream1.Outputs(0).Headers

        InitHeaders
    
        inputDocStmState = "begin"
        DocStream1.Outputs(0).Init
        
    End If
    
End Sub


Private Sub FromField_LostFocus()

    If (Not FromField.Text = "") Then
        AddHeaderItem FromField, "From"
    End If


End Sub

Private Sub Help_Click()
On Error GoTo errhandler
Smtpct1.Help txtParam.Text
Exit Sub
errhandler:
If Err.Number = 1005 Then errText = "Wrong State for This Command"
MsgBox "Error: " & Err.Number
End Sub

Private Sub OriginatorList_Click()

End Sub

Private Sub Quit_Click()
Smtpct1.Quit
End Sub


Private Sub Reset_Click()
Smtpct1.Reset
End Sub

Private Sub SendMethod_Click()
    
    If ValidateFields Then
    
        Dim body As String

        InitHeaders
        Smtpct1.SendDoc , , BodyField.Text

    End If
    
End Sub


Private Sub Smtpct1_OnCloseSend()
    UpdateProperties
End Sub

Private Sub Smtpct1_OnStateChange()

    UpdateProperties
End Sub


Private Sub Smtpct1_OnData()
    UpdateProperties
End Sub

Private Sub Smtpct1_OnDataEnd()
    UpdateProperties
End Sub

Private Sub Smtpct1_OnHelo()
    UpdateProperties
End Sub

Private Sub Smtpct1_OnHelp()
    UpdateProperties
End Sub

Private Sub Smtpct1_OnMail()
    UpdateProperties
End Sub


Private Sub Smtpct1_OnOpenSend()
    UpdateProperties
End Sub


Private Sub Smtpct1_OnQuit()
    UpdateProperties
End Sub


Private Sub Smtpct1_OnRcpt()
    UpdateProperties
End Sub


Private Sub Smtpct1_OnSendData()
    UpdateProperties
End Sub


Private Sub Smtpct1_OnSendMail()
    MsgBox "send mail completed"
End Sub

Private Sub Smtpct1_OnVerify()
    UpdateProperties
End Sub







Private Sub Smtpct1_Busy(ByVal isBusy As Boolean)
    If (isBusy = False) Then
        PrintEventMsg ("Idle: " & Smtpct1.ReplyString)
        StatusBar1.Panels(3).Text = "Idle"
    Else
        PrintEventMsg ("Busy")
        StatusBar1.Panels(3).Text = "Busy"
    End If
    
End Sub

Private Sub Smtpct1_Error(Number As Integer, Description As String, Scode As Long, Source As String, HelpFile As String, HelpContext As Long, CancelDisplay As Boolean)
    PrintEventMsg ("Error: " & Description)
End Sub


Private Sub Smtpct1_ProtocolStateChanged(ByVal ProtocolState As Integer)
    PrintEventMsg ("ProtocolStateChanged: " & ProtocolState)
    StatusBar1.Panels(2).Text = Smtpct1.ProtocolStateString
    
End Sub

Private Sub Smtpct1_StateChanged(ByVal State As Integer)
    PrintEventMsg ("StateChanged: " & State)
    StatusBar1.Panels(1).Text = Smtpct1.StateString
End Sub

Private Sub ToField_KeyUp(KeyCode As Integer, Shift As Integer)
    If KeyCode = vbKeyReturn Then
        AddHeaderItem ToField, "To"
    End If

End Sub


Private Sub ToField_LostFocus()
    If (Not ToField.Text = "") Then
        AddHeaderItem ToField, "To"
    End If


End Sub


Private Sub Verify_Click()
Smtpct1.Verify txtParam.Text
End Sub


